/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.algart.arrays.Arrays;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.ExecutionStatus;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ParameterSetter;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.modules.core.scalars.creation.CreateScalar;
import net.algart.external.UsedForExternalCommunication;
import net.algart.json.Jsons;

public abstract class Executor
extends ExecutionBlock {
    public static final String ENUM_VALUE_OF_NAME_CUSTOM_METHOD = "valueOfName";
    public static final String STANDARD_VISIBLE_RESULT_PARAMETER_NAME = "visibleResult";
    public static final String SETTINGS = "settings";
    public static final String OUTPUT_EXECUTOR_ID_NAME = "_sys___executor_id";
    public static final String OUTPUT_PLATFORM_ID_NAME = "_sys___platform_id";
    public static final String OUTPUT_RESOURCE_FOLDER_NAME = "_sys___resource_folder";
    public static final System.Logger LOG;
    protected static final boolean LOGGABLE_INFO;
    protected static final boolean LOGGABLE_DEBUG;
    protected static final boolean LOGGABLE_TRACE;
    private static final boolean CREATE_EXECUTION_KEY_FILE;
    private static final boolean WARNING_FOR_DEPRECATED_PARAMETERS;
    private static final Map<String, Map<String, ParameterSetter>> EXECUTOR_CLASS_SETTERS;
    private static final Map<String, Map<String, ParameterValueType>> EXECUTOR_CLASS_PARAMETER_TYPES;
    static final Set<String> NON_SETTERS;
    private final Set<String> onChangeParametersAutomaticDisabledParameters = new HashSet<String>();
    private boolean onChangeParametersAutomatic = true;
    private final Map<String, ParameterSetter> parameterSetters;
    private final Map<String, ParameterValueType> parameterTypes;
    private String defaultInputPortName = DEFAULT_INPUT_PORT;
    private String defaultOutputPortName = DEFAULT_OUTPUT_PORT;
    private final ExecutionStatus status = ExecutionStatus.newNamedInstance(this.getClass().getName());
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean multithreadingEnvironment = false;
    private volatile long startProcessingTimeStamp = Long.MIN_VALUE;
    private volatile long endProcessingTimeStamp = Long.MIN_VALUE;
    private final AtomicLong serviceTime = new AtomicLong(0L);
    private boolean timingEnabled = true;
    private volatile boolean cancellingFurtherExecutionRequested = false;
    private boolean usingVisibleResultParameter = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor() {
        String className = this.getClass().getName();
        if (this.loggingEnabled()) {
            Executor.logDebug(() -> "Creating executor " + className);
        }
        Map<String, Map<String, ParameterSetter>> map = EXECUTOR_CLASS_SETTERS;
        synchronized (map) {
            Map<String, ParameterSetter> setters = EXECUTOR_CLASS_SETTERS.get(className);
            Map<String, ParameterValueType> parameterTypes = EXECUTOR_CLASS_PARAMETER_TYPES.get(className);
            if (setters == null) {
                assert (parameterTypes == null);
                setters = ParameterSetter.findSetters(this);
                parameterTypes = new TreeMap<String, ParameterValueType>();
                for (Map.Entry<String, ParameterSetter> entry : setters.entrySet()) {
                    parameterTypes.put(entry.getKey(), entry.getValue().getControlValueType());
                }
                EXECUTOR_CLASS_SETTERS.put(className, setters);
                EXECUTOR_CLASS_PARAMETER_TYPES.put(className, parameterTypes);
            }
            this.parameterSetters = setters;
            this.parameterTypes = parameterTypes;
        }
    }

    @Override
    public String defaultInputPortName() {
        return this.defaultInputPortName;
    }

    public void defaultInputPortName(String newDefaultInputPortName) {
        Objects.requireNonNull(newDefaultInputPortName, "Null newDefaultInputPortName");
        this.defaultInputPortName = newDefaultInputPortName;
    }

    @Override
    public String defaultOutputPortName() {
        return this.defaultOutputPortName;
    }

    public void defaultOutputPortName(String newDefaultOutputPortName) {
        Objects.requireNonNull(newDefaultOutputPortName, "Null newDefaultOutputPortName");
        this.defaultOutputPortName = newDefaultOutputPortName;
    }

    public final void setDefaultInputPort(String newDefaultInputPortName, DataType dataType) {
        Objects.requireNonNull(newDefaultInputPortName, "Null newDefaultInputPortName");
        Objects.requireNonNull(dataType, "Null dataType");
        this.removeInputPort(this.defaultInputPortName);
        this.defaultInputPortName = newDefaultInputPortName;
        if (!this.addPort(Port.newInput(newDefaultInputPortName, dataType))) {
            throw new IllegalStateException("Cannot add new default input port " + newDefaultInputPortName);
        }
    }

    public final void setDefaultOutputPort(String newDefaultOutputPortName, DataType dataType) {
        Objects.requireNonNull(newDefaultOutputPortName, "Null newDefaultOutputPortName");
        Objects.requireNonNull(dataType, "Null dataType");
        this.removeOutputPort(this.defaultOutputPortName);
        this.defaultOutputPortName = newDefaultOutputPortName;
        if (!this.addPort(Port.newOutput(newDefaultOutputPortName, dataType))) {
            throw new IllegalStateException("Cannot add new default output port " + newDefaultOutputPortName);
        }
    }

    public final void setDefaultInputMat(String newDefaultInputPortName) {
        this.setDefaultInputPort(newDefaultInputPortName, DataType.MAT);
    }

    public final void setDefaultOutputMat(String newDefaultOutputPortName) {
        this.setDefaultOutputPort(newDefaultOutputPortName, DataType.MAT);
    }

    public final void setDefaultInputNumbers(String newDefaultInputPortName) {
        this.setDefaultInputPort(newDefaultInputPortName, DataType.NUMBERS);
    }

    public final void setDefaultOutputNumbers(String newDefaultOutputPortName) {
        this.setDefaultOutputPort(newDefaultOutputPortName, DataType.NUMBERS);
    }

    public final void setDefaultInputScalar(String newDefaultInputPortName) {
        this.setDefaultInputPort(newDefaultInputPortName, DataType.SCALAR);
    }

    public final void setDefaultOutputScalar(String newDefaultOutputPortName) {
        this.setDefaultOutputPort(newDefaultOutputPortName, DataType.SCALAR);
    }

    public Executor putSettings(JsonObject settings) {
        return this.putSettings(settings == null ? null : Jsons.toPrettyString(settings));
    }

    public Executor putSettings(String settings) {
        this.putStringScalar(SETTINGS, settings);
        return this;
    }

    public final <T extends Data> Map<String, T> allOutputContainers(Class<? extends T> dataClass, boolean onlyRequested) {
        Objects.requireNonNull(dataClass, "Null data class");
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (Port port : this.outputPorts()) {
            assert (port != null) : "Null output port (impossible)";
            assert (port.getName() != null) : "Null output port name (impossible)";
            assert (port.getDataType() != null) : "Null output port data type (impossible) in port " + port.getName();
            if (!port.getDataType().typeClass().isAssignableFrom(dataClass) || onlyRequested && !this.checkOutputNecessary(port)) continue;
            result.put(port.getName(), port.getData(dataClass, true));
        }
        return result;
    }

    @Override
    public boolean checkOutputNecessary(Port outputPort) {
        return super.checkOutputNecessary(outputPort) || outputPort != null && this.isVisibleResultNecessary() && this.isVisiblePort(outputPort);
    }

    @Override
    public ExecutionStatus status() {
        return this.status;
    }

    @Override
    public String statusData(int dataCode) {
        ExecutionStatus.DataKind dataKind = ExecutionStatus.DataKind.ofOrNull(dataCode);
        return dataKind == null ? null : dataKind.data(this.status);
    }

    public final ExtensionSpecification.Platform executorPlatform() {
        String id = this.getPlatformId();
        if (id == null) {
            return null;
        }
        return InstalledExtensions.allInstalledPlatformsMap().get(id);
    }

    public final Path executorResourceFolder() {
        ExtensionSpecification.Platform platform = this.executorPlatform();
        if (platform == null) {
            return null;
        }
        return platform.resourcesFolderOrNull();
    }

    public final void showStatus(String message) {
        this.status().setMessageString(message);
    }

    public final void showStatus(Supplier<String> message) {
        this.status().setMessage(message);
    }

    public final boolean isMultithreadingEnvironment() {
        return this.multithreadingEnvironment;
    }

    public final void setMultithreadingEnvironment(boolean multithreadingEnvironment) {
        this.multithreadingEnvironment = multithreadingEnvironment;
    }

    public final boolean isTimingEnabled() {
        return this.timingEnabled;
    }

    public final void setTimingEnabled(boolean timingEnabled) {
        this.timingEnabled = timingEnabled;
    }

    public final boolean isUsingVisibleResultParameter() {
        return this.usingVisibleResultParameter;
    }

    public final void useVisibleResultParameter() {
        this.usingVisibleResultParameter = true;
        this.disableOnChangeParameterAutomatic(STANDARD_VISIBLE_RESULT_PARAMETER_NAME);
    }

    public final boolean isCancellingExecutionRequested() {
        for (Port port : this.inputPorts()) {
            if (!port.isCancellingExecutionRequested()) continue;
            return true;
        }
        return false;
    }

    public final boolean isCancellingFurtherExecutionRequested() {
        return this.cancellingFurtherExecutionRequested;
    }

    public final void requestCancellingFurtherExecution() {
        this.cancellingFurtherExecutionRequested = true;
        for (Port port : this.outputPorts()) {
            if (!port.isConnected()) continue;
            port.requestCancellingExecution();
        }
    }

    public final void requestContinuingFurtherExecution() {
        this.cancellingFurtherExecutionRequested = false;
        for (Port port : this.outputPorts()) {
            port.requestContinuingExecution();
        }
    }

    public final void fillSystemOutputs() {
        this.setOutputScalar(OUTPUT_EXECUTOR_ID_NAME, this::getExecutorId);
        this.setOutputScalar(OUTPUT_PLATFORM_ID_NAME, this::getPlatformId);
        this.setOutputScalarIfNecessary(OUTPUT_RESOURCE_FOLDER_NAME, this::executorResourceFolder);
    }

    public final Collection<String> allParameters() {
        return Collections.unmodifiableSet(this.parameterTypes.keySet());
    }

    public final ParameterValueType parameterControlValueType(String parameterName) {
        return this.parameterTypes.get(parameterName);
    }

    public final Class<?> parameterJavaType(String parameterName) {
        ParameterSetter setter = this.parameterSetters.get(parameterName);
        return setter == null ? null : setter.parameterType;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void reset() {
        this.initialized.set(true);
        this.initialize();
    }

    @Override
    public void execute() {
        this.execute(ExecutionBlock.ExecutionMode.NORMAL);
    }

    @Override
    public void execute(ExecutionBlock.ExecutionMode executionMode) {
        long processingTime;
        long outputTime;
        long inputTime;
        long endTime;
        long t2Processing;
        long t1Processing;
        Objects.requireNonNull(executionMode, "Null executionMode");
        if (!this.initialized.getAndSet(true)) {
            this.initialize();
        }
        long t1 = System.nanoTime();
        this.resetTiming();
        if (this.isCancellingExecutionRequested()) {
            this.requestCancellingFurtherExecution();
            if (executionMode.isNormalLogging() && this.loggingEnabled() && LOGGABLE_DEBUG) {
                Executor.logDebug(() -> (String)(this.getExecutorId() == null ? "  " : "  [" + this.getExecutorId() + "] ") + this.getClass().getName() + " - execution SKIPPED");
            }
            return;
        }
        this.requestContinuingFurtherExecution();
        this.fillSystemOutputs();
        Path keyFile = Paths.get("___execution_" + this.getClass().getName(), new String[0]);
        try {
            ExecutionBlock caller;
            if (CREATE_EXECUTION_KEY_FILE) {
                try {
                    Files.createFile(keyFile, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.WARNING, "Cannot create key file " + String.valueOf(keyFile), (Throwable)e);
                }
            }
            this.status.open((caller = this.getCaller()) instanceof Executor ? ((Executor)caller).status : null);
            this.status.setStartProcessingTimeStamp(t1);
            this.status.setExecutorClass(this.getClass());
            this.status.setClassInformationIncluded(true);
            t1Processing = System.nanoTime();
            this.process();
            this.postprocess();
            t2Processing = System.nanoTime();
        }
        catch (Error | RuntimeException e) {
            if (executionMode.isNormalLogging()) {
                LOG.log(System.Logger.Level.ERROR, "Cannot execute " + this.getClass().getSimpleName() + " due to: " + String.valueOf(e));
            }
            throw e;
        }
        finally {
            this.status.close();
            if (CREATE_EXECUTION_KEY_FILE) {
                try {
                    Files.delete(keyFile);
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.WARNING, "Cannot delete key file " + String.valueOf(keyFile), (Throwable)e);
                }
            }
        }
        boolean noInputOuput = this.startProcessingTimeStamp == Long.MIN_VALUE && this.endProcessingTimeStamp == Long.MIN_VALUE;
        long startTime = this.startProcessingTimeStamp == Long.MIN_VALUE ? t1Processing : this.startProcessingTimeStamp;
        long l = endTime = this.endProcessingTimeStamp == Long.MIN_VALUE ? t2Processing : this.endProcessingTimeStamp;
        if (noInputOuput) {
            inputTime = 0L;
            outputTime = 0L;
            processingTime = t2Processing - t1Processing;
        } else {
            inputTime = startTime - t1Processing;
            outputTime = t2Processing - endTime;
            processingTime = endTime - startTime - this.serviceTime.get();
        }
        if (executionMode.isNormalLogging() && this.loggingEnabled() && LOGGABLE_DEBUG) {
            String timing = (String)(this.getExecutorId() == null ? "  " : "  [" + this.getExecutorId() + "] ") + String.format("@%08X ", System.identityHashCode(this)) + this.getClass().getName() + " executed in " + (noInputOuput ? String.format(Locale.US, "%.3f ms", (double)(t2Processing - t1Processing) * 1.0E-6) : String.format(Locale.US, "%.3f ms: %.3f ms in + %s%.3f ms executing + %.3f ms out", (double)(t2Processing - t1Processing) * 1.0E-6, (double)inputTime * 1.0E-6, this.serviceTime.get() == 0L ? "" : String.format(Locale.US, "%.3f ms service + ", (double)this.serviceTime.get() * 1.0E-6), (double)processingTime * 1.0E-6, (double)outputTime * 1.0E-6));
            Executor.logDebug(timing);
        }
        long t2 = System.nanoTime();
        if (this.isTimingEnabled()) {
            long systemTime = t1Processing - t1 + (t2 - t2Processing);
            Timing.INSTANCE.accumulate(t2 - t1, processingTime, inputTime, outputTime, this.serviceTime.get(), systemTime);
        }
    }

    @Override
    @UsedForExternalCommunication
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.OUTPUT, this.visibleOutputPortName());
    }

    public final ExecutionVisibleResultsInformation defaultVisibleResultsInformation(Port.Type portType, String portName) {
        Port port;
        Objects.requireNonNull(portType, "Null port type");
        ExecutionVisibleResultsInformation result = new ExecutionVisibleResultsInformation();
        if (this.isVisibleResultDisabled()) {
            return result;
        }
        if (portName != null && (port = this.getPort(portType, portName)) != null) {
            result.setPorts(port);
        }
        return result;
    }

    public boolean isVisibleResultDisabled() {
        return this.isCancellingFurtherExecutionRequested();
    }

    public boolean isVisiblePort(Port port) {
        Objects.requireNonNull(port);
        return port.isOutput() && port.getName().equals(this.visibleOutputPortName());
    }

    public void initialize() {
    }

    public abstract void process();

    public void postprocess() {
        if (this.multithreadingEnvironment) {
            for (Port outputPort : this.outputPorts()) {
                outputPort.getData().serializeMemory();
            }
        }
    }

    public String visibleOutputPortName() {
        String defaultResult = this.defaultOutputPortName();
        if (this.usingVisibleResultParameter) {
            return this.parameters().getString(STANDARD_VISIBLE_RESULT_PARAMETER_NAME, defaultResult);
        }
        return defaultResult;
    }

    @Override
    public void onChangeParameter(String name) {
        Objects.requireNonNull(name, "Null parameter name");
        if (!WARNING_FOR_DEPRECATED_PARAMETERS && this.deprecatedParameter(name)) {
            LOG.log(System.Logger.Level.DEBUG, () -> "Old-style parameter " + name + " found for " + String.valueOf(this.getClass()) + ", we recommend resaving the chain file (" + (String)(this.getContextName() == null ? "no context" : "context \"" + this.getContextName() + "\"") + (String)(this.getContextPath() == null ? "" : " at " + this.getContextPath()) + ")");
        } else if (this.onChangeParametersAutomatic && !this.onChangeParametersAutomaticDisabledParameters.contains(name)) {
            this.onChangeParameterAutomatic(name);
        }
    }

    public final void disableOnChangeParametersAutomatic() {
        this.onChangeParametersAutomatic = false;
    }

    public final void disableOnChangeParameterAutomatic(String parameterName) {
        this.onChangeParametersAutomaticDisabledParameters.add(parameterName);
    }

    @Override
    public void close() {
        super.close();
        if (this.loggingEnabled()) {
            Executor.logDebug(() -> "Destroying executor " + this.getClass().getName());
        }
        this.freeAllPortData();
    }

    public String toString() {
        return "Executor " + this.getClass().getName();
    }

    public final long getStartProcessingTimeStamp() {
        return this.startProcessingTimeStamp;
    }

    public final long getEndProcessingTimeStamp() {
        return this.endProcessingTimeStamp;
    }

    public final long getServiceTime() {
        return this.serviceTime.get();
    }

    public final void setStartProcessingTimeStamp() {
        this.startProcessingTimeStamp = System.nanoTime();
    }

    public final void setEndProcessingTimeStamp() {
        if (this.endProcessingTimeStamp == Long.MIN_VALUE) {
            this.endProcessingTimeStamp = System.nanoTime();
        }
    }

    public final void addServiceTime(long elapsedServiceTimeInNanoseconds) {
        this.serviceTime.addAndGet(elapsedServiceTimeInNanoseconds);
    }

    public final void resetTiming() {
        this.startProcessingTimeStamp = Long.MIN_VALUE;
        this.endProcessingTimeStamp = Long.MIN_VALUE;
        this.serviceTime.set(0L);
    }

    protected boolean loggingEnabled() {
        return true;
    }

    protected boolean skipStandardAutomaticParameters() {
        return false;
    }

    protected final void onChangeParameterAutomatic(String parameterName) {
        long t2;
        long t1 = LOGGABLE_TRACE ? System.nanoTime() : 0L;
        ParameterSetter setter = this.parameterSetters.get(parameterName);
        if (setter != null) {
            setter.set(this);
        } else {
            LOG.log(System.Logger.Level.WARNING, () -> String.valueOf(this.getClass()) + " has no setter for parameter \"" + parameterName + "\" (" + (String)(this.getContextName() == null ? "no context" : "context \"" + this.getContextName() + "\"") + (String)(this.getContextPath() == null ? "" : " at " + this.getContextPath()) + ")");
        }
        long l = t2 = LOGGABLE_TRACE ? System.nanoTime() : 0L;
        if (this.loggingEnabled()) {
            LOG.log(System.Logger.Level.TRACE, () -> String.valueOf(this.getClass()) + " set parameter \"" + parameterName + "\": " + (double)(t2 - t1) * 0.001 + " mcs");
        }
    }

    public static long infoTime() {
        return LOGGABLE_INFO ? System.nanoTime() : 0L;
    }

    public static long debugTime() {
        return LOGGABLE_DEBUG ? System.nanoTime() : 0L;
    }

    public static long allocatedMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static long configAllocatedMemory() {
        return LOGGABLE_DEBUG ? Executor.allocatedMemory() : 0L;
    }

    public static long fineAllocatedMemory() {
        return LOGGABLE_TRACE ? Executor.allocatedMemory() : 0L;
    }

    public static void startTimingOfExecutingAll() {
        LOG.log(System.Logger.Level.INFO, () -> String.format("Starting executing in Java%n%s", Timing.INSTANCE.startingInfo()));
        Timing.INSTANCE.startTiming();
    }

    public static void finishTimingOfExecutingAll() {
        Timing.INSTANCE.finishTiming();
        LOG.log(System.Logger.Level.INFO, () -> String.format("Finishing executing in Java%n%s", Timing.INSTANCE.finishingInfo()));
        Timing.INSTANCE.startTiming();
    }

    protected static void logInfo(Supplier<String> msgSupplier) {
        LOG.log(System.Logger.Level.INFO, msgSupplier);
    }

    protected static void logInfo(String msg) {
        LOG.log(System.Logger.Level.INFO, msg);
    }

    protected static void logDebug(Supplier<String> msgSupplier) {
        LOG.log(System.Logger.Level.DEBUG, msgSupplier);
    }

    protected static void logDebug(String msg) {
        LOG.log(System.Logger.Level.DEBUG, msg);
    }

    protected static void logTrace(Supplier<String> msgSupplier) {
        LOG.log(System.Logger.Level.TRACE, msgSupplier);
    }

    protected static void logTrace(String msg) {
        LOG.log(System.Logger.Level.TRACE, msg);
    }

    protected static System.Logger.Level ofLogLevel(String name) {
        return switch (name) {
            case "SEVERE", "1000" -> System.Logger.Level.ERROR;
            case "900" -> System.Logger.Level.WARNING;
            case "800" -> System.Logger.Level.INFO;
            case "CONFIG", "700", "FINE", "500" -> System.Logger.Level.DEBUG;
            case "FINER", "400", "FINEST", "300" -> System.Logger.Level.TRACE;
            default -> System.Logger.Level.valueOf(name);
        };
    }

    private boolean deprecatedParameter(String name) {
        return name.startsWith("$__") || this instanceof CreateScalar && name.equals("nullValue") || name.equals("autoContrastVisibleResult");
    }

    static {
        Executor.addTaskBeforeExecutingAll(Executor::startTimingOfExecutingAll);
        Executor.addTaskAfterExecutingAll(Executor::finishTimingOfExecutingAll);
        LOG = System.getLogger(Executor.class.getName());
        LOGGABLE_INFO = LOG.isLoggable(System.Logger.Level.INFO);
        LOGGABLE_DEBUG = LOG.isLoggable(System.Logger.Level.DEBUG);
        LOGGABLE_TRACE = LOG.isLoggable(System.Logger.Level.TRACE);
        CREATE_EXECUTION_KEY_FILE = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.createExecutionKeyFile", (boolean)false);
        WARNING_FOR_DEPRECATED_PARAMETERS = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.warningForDeprecatedParameters", (boolean)true);
        EXECUTOR_CLASS_SETTERS = new HashMap<String, Map<String, ParameterSetter>>();
        EXECUTOR_CLASS_PARAMETER_TYPES = new HashMap<String, Map<String, ParameterValueType>>();
        NON_SETTERS = new HashSet<String>(Arrays.asList("setDefaultInputPort", "setDefaultOutputPort", "setDefaultInputMat", "setDefaultOutputMat", "setDefaultInputNumbers", "setDefaultOutputNumbers", "setDefaultInputScalar", "setDefaultOutputScalar", "setBooleanParameter", "setIntParameter", "setLongParameter", "setDoubleParameter", "setStringParameter", "setVisibleResultNecessary", "setAllOutputsNecessary", "setMultithreadingEnvironment", "setTimingEnabled", "setSessionId", "setOwnerId", "setContextId", "setContextName", "setContextPath", "setCurrentDirectory", "setInterruptionRequested"));
    }

    public static final class Timing {
        private static final Timing INSTANCE = new Timing();
        private volatile boolean active = false;
        private long startTimeStamp = Long.MIN_VALUE;
        private long finishTimeStamp = Long.MIN_VALUE;
        private long totalTime = 0L;
        private long processingTime = 0L;
        private long inputTime = 0L;
        private long outputTime = 0L;
        private long serviceTime = 0L;
        private long systemTime = 0L;
        private final Object lock = new Object();

        private Timing() {
        }

        public static Timing getInstance() {
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.lock;
            synchronized (object) {
                this.startTiming();
                this.active = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Object object = this.lock;
            synchronized (object) {
                this.active = false;
                this.finishTiming();
            }
        }

        public boolean isActive() {
            return this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String startingInfo() {
            Object object = this.lock;
            synchronized (object) {
                return "Start " + Timing.commonInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String finishingInfo() {
            Object object = this.lock;
            synchronized (object) {
                double elapsed = (double)this.finishTimeStamp - (double)this.startTimeStamp;
                return "Finish " + Timing.commonInfo() + String.format(Locale.US, "Timing:%n  elapsed time %.3f ms%n    total execute() time %.3f ms%n      processing           %.3f ms%n      input                %.3f ms%n      output               %.3f ms%n      service              %.3f ms%n      timing/logging       %.3f ms%n    external operations    %.3f ms%n", elapsed * 1.0E-6, (double)this.totalTime * 1.0E-6, (double)this.processingTime * 1.0E-6, (double)this.inputTime * 1.0E-6, (double)this.outputTime * 1.0E-6, (double)this.serviceTime * 1.0E-6, (double)this.systemTime * 1.0E-6, (elapsed - (double)this.totalTime) * 1.0E-6);
            }
        }

        public static String memoryInfo() {
            Runtime rt = Runtime.getRuntime();
            return String.format(Locale.US, "Used memory: %.5f MB / %.5f MB%n", (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0, (double)rt.maxMemory() / 1048576.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startTiming() {
            Object object = this.lock;
            synchronized (object) {
                if (this.active) {
                    return;
                }
                this.totalTime = 0L;
                this.processingTime = 0L;
                this.inputTime = 0L;
                this.outputTime = 0L;
                this.serviceTime = 0L;
                this.systemTime = 0L;
                this.startTimeStamp = System.nanoTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishTiming() {
            Object object = this.lock;
            synchronized (object) {
                this.finishTimeStamp = System.nanoTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void accumulate(long fullTime, long processingTime, long inputTime, long outputTime, long serviceTime, long systemTime) {
            Object object = this.lock;
            synchronized (object) {
                this.totalTime += fullTime;
                this.processingTime += processingTime;
                this.inputTime += inputTime;
                this.outputTime += outputTime;
                this.serviceTime += serviceTime;
                this.systemTime += systemTime;
            }
        }

        private static String commonInfo() {
            return String.format(Locale.US, "time: %s%n", new Date()) + Timing.memoryInfo();
        }
    }
}

