/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.Executor;

public enum LogLevel {
    OFF(System.Logger.Level.OFF),
    ERROR(System.Logger.Level.ERROR),
    WARNING(System.Logger.Level.WARNING),
    INFO(System.Logger.Level.INFO),
    DEBUG(System.Logger.Level.DEBUG),
    CONFIG(System.Logger.Level.DEBUG, "CONFIG"),
    TRACE(System.Logger.Level.TRACE),
    PRINTLN_TO_CONSOLE(null, "println"){

        @Override
        public void log(String message) {
            System.out.println(message);
        }

        @Override
        public void finishStage() {
            System.out.println();
        }
    }
    ,
    PRINT_TO_CONSOLE(null, "print"){

        @Override
        public void log(String message) {
            if (((String)message).length() > 190) {
                message = ((String)message).substring(0, 187) + "...";
            }
            System.out.print("        \r" + (String)message + "\r");
        }

        @Override
        public void removeMessage(String previousMessage) {
            if (previousMessage != null && !previousMessage.isEmpty()) {
                System.out.print("\r" + LogLevel.repeat(' ', Math.min(190, previousMessage.length())));
            }
        }

        @Override
        public void finishStage() {
            System.out.println();
        }
    };

    private static final int MAX_PRINT_TO_CONSOLE_LENGTH = 190;
    private static final Map<String, LogLevel> ALL_TYPES;
    private final System.Logger.Level level;
    private final String name;

    private LogLevel(System.Logger.Level level) {
        this(level, level.getName());
    }

    private LogLevel(System.Logger.Level level, String name) {
        this.level = level;
        this.name = name;
    }

    public System.Logger.Level level() {
        return this.level;
    }

    public String levelName() {
        return this.name;
    }

    public boolean isLoggable() {
        return this.isLoggable(Executor.LOG);
    }

    public boolean isLoggable(System.Logger logger) {
        Objects.requireNonNull(logger, "Null logger");
        return this.level == null || logger.isLoggable(this.level);
    }

    public void log(String message) {
        this.log(Executor.LOG, message);
    }

    public void log(System.Logger logger, String message) {
        Objects.requireNonNull(logger, "Null logger");
        if (this.level == null) {
            throw new AssertionError((Object)"Invalid usage");
        }
        if (message != null) {
            logger.log(this.level, message);
        }
    }

    public void removeMessage(String previousMessage) {
    }

    public void finishStage() {
    }

    public static LogLevel of(String levelName) {
        LogLevel result = ALL_TYPES.get(levelName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown logging level name: " + levelName);
        }
        return result;
    }

    private static String repeat(char c, int count) {
        char[] result = new char[count];
        Arrays.fill(result, c);
        return String.valueOf(result);
    }

    public static void main(String[] args) {
        System.out.println((Object)LogLevel.of("print"));
        System.out.println((Object)LogLevel.of("println"));
        System.out.println((Object)LogLevel.of("OFF"));
    }

    static {
        ALL_TYPES = Arrays.stream(LogLevel.values()).collect(Collectors.toMap(LogLevel::levelName, level -> level));
    }
}

