/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import java.util.Objects;
import net.algart.executors.api.chains.ChainSpecification;

public final class ChainLink {
    final String srcPortId;
    final String destPortId;

    private ChainLink(String srcPortId, String destPortId) {
        this.srcPortId = Objects.requireNonNull(srcPortId, "Null srcPortId");
        this.destPortId = Objects.requireNonNull(destPortId, "Null destPortId");
    }

    public static ChainLink of(String srcPortId, String destPortId) {
        return new ChainLink(srcPortId, destPortId);
    }

    public static ChainLink of(ChainSpecification.Link link) {
        return ChainLink.of(link.getSrcPortUuid(), link.getDestPortUuid());
    }

    public String getSrcPortId() {
        return this.srcPortId;
    }

    public String getDestPortId() {
        return this.destPortId;
    }

    public String toString() {
        return "ChainLink{srcPortId='" + this.srcPortId + "', destPortId='" + this.destPortId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainLink chainLink = (ChainLink)o;
        return this.srcPortId.equals(chainLink.srcPortId) && this.destPortId.equals(chainLink.destPortId);
    }

    public int hashCode() {
        return Objects.hash(this.srcPortId, this.destPortId);
    }
}

