/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import java.util.concurrent.atomic.AtomicInteger;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainInputPort;
import net.algart.executors.api.chains.ChainPort;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.system.PortSpecification;

public final class ChainOutputPort
extends ChainPort<ChainInputPort> {
    private final AtomicInteger countOfConnectedInputs = new AtomicInteger(0);
    private volatile boolean hasConnectedReadOnlyExecutors = false;

    private ChainOutputPort(ChainBlock block, String id, String name, ChainPortType portType, DataType dataType) {
        super(block, id, name, portType, dataType);
        if (portType.actualPortType() != Port.Type.OUTPUT) {
            throw new IllegalArgumentException("Non-output port type");
        }
    }

    public static ChainOutputPort of(ChainBlock block, String id, String name, ChainPortType portType, DataType dataType) {
        return new ChainOutputPort(block, id, name, portType, dataType);
    }

    public static ChainOutputPort of(ChainBlock block, ChainSpecification.Block.Port port) {
        return ChainOutputPort.of(block, port.getUuid(), port.getName(), port.getPortType(), port.getDataType());
    }

    public static ChainOutputPort of(ChainBlock block, PortSpecification portSpecification) {
        return ChainOutputPort.of(block, null, portSpecification.getName(), ChainPortType.OUTPUT_PORT, portSpecification.getValueType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromExecutorPort() {
        ExecutionBlock executor = this.block.getExecutor();
        switch (this.portType) {
            case OUTPUT_PORT: {
                Object object = this.chain.blocksInteractionLock;
                synchronized (object) {
                    this.data = executor.getData(this.name);
                    break;
                }
            }
            case OUTPUT_CONTROL_AS_PORT: {
                Object object = this.chain.blocksInteractionLock;
                synchronized (object) {
                    this.data.setTo(SScalar.of(executor.parameters().getString(this.name)));
                    break;
                }
            }
            default: {
                throw new AssertionError((Object)("Unknown output port type: " + String.valueOf((Object)this.portType)));
            }
        }
    }

    public void resetConnectedInputsInformation() {
        boolean hasConnectedReadOnlyExecutors = false;
        int count = 0;
        for (ChainInputPort inputPort : this.connected.values()) {
            if (!inputPort.block.isExecutedAtRunTime()) continue;
            ExecutionBlock executor = inputPort.block.executor;
            hasConnectedReadOnlyExecutors |= executor != null && executor.isReadOnlyInput();
            ++count;
        }
        this.hasConnectedReadOnlyExecutors = hasConnectedReadOnlyExecutors;
        this.countOfConnectedInputs.set(count);
    }

    public int reduceCountOfConnectedInputs() {
        int result = this.countOfConnectedInputs.decrementAndGet();
        if (result < 0) {
            throw new IllegalStateException("Negative counter of connected input ports in " + String.valueOf(this));
        }
        return result;
    }

    public int getCountOfConnectedInputs() {
        int result = this.countOfConnectedInputs.get();
        if (result < 0) {
            throw new IllegalStateException("Negative counter of connected input ports in " + String.valueOf(this));
        }
        return result;
    }

    public boolean hasConnectedReadOnlyExecutors() {
        return this.hasConnectedReadOnlyExecutors;
    }

    public boolean isStandardOutput() {
        return this.block.isStandardOutput();
    }

    public ChainOutputPort cleanCopy(ChainBlock newBlock) {
        return new ChainOutputPort(newBlock, this.id, this.name, this.portType, this.dataType);
    }
}

