/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains.core;

import jakarta.json.JsonValue;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.algart.arrays.Arrays;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainLoadingException;
import net.algart.executors.api.chains.ChainRunningException;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.InterpretChain;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledPlatformsForTechnology;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.UseChainSettings;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ControlEditionType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.json.Jsons;

public final class UseChain
extends FileOperation {
    public static final String CHAIN_LANGUAGE_NAME = "chain";
    public static final String ADDITIONAL_STANDARD_CHAINS_PATH = Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.api.chains.path", null);
    public static final String DO_ACTION_NAME = "_sch___doAction";
    public static final String DO_ACTION_CAPTION = "Do actions";
    public static final String DO_ACTION_DESCRIPTION = "If set, function is executed normally. If cleared, this function just copies all input data to the output ports with the same names and types (if they exist) and does not anything else.";
    public static final String LOG_TIMING_NAME = "_sch___logTiming";
    public static final String LOG_TIMING_CAPTION = "Log timing";
    public static final String LOG_TIMING_DESCRIPTION = "If set, function analyses and prints timing statistics for all executed blocks on the log level, specified below.\nNote: actual collecting timing statistics does not depend on this flag. So, you may disable this flag for some executions and enable it only sometimes, for example, at the end of some loop: statistics will be collected always, but printed only when you need.";
    public static final boolean LOG_TIMING_DEFAULT = true;
    public static final String TIMING_LOG_LEVEL_NAME = "_sch___timingLogLevel";
    public static final String TIMING_LOG_LEVEL_CAPTION = "Timing logging level";
    public static final String TIMING_LOG_LEVEL_DESCRIPTION = "If the previous flag is set, function prints timing statistics on this log level.\nIf this parameter is specified via an input port, it may be a string, equal to one of predefined names in System.Logger.Level (\"INFO\", \"DEBUG\", etc), or an integer value, returned by Level.intValue() method.\nNote: if the current system logging level is greater this value, logging is not performed and timing statistics is not collected.";
    public static final String TIMING_LOG_LEVEL_DEFAULT = System.Logger.Level.DEBUG.getName();
    public static final String TIMING_NUMBER_OF_CALLS_NAME = "_sch___timingNumberOfCalls";
    public static final String TIMING_NUMBER_OF_CALLS_CAPTION = "Number N of calls for timing";
    public static final String TIMING_NUMBER_OF_CALLS_DESCRIPTION = "This function collects and analyses timing statistics for execution time for the last N calls of every block.\nMust be non-negative. Zero value N=0 disables timing.\nNote: changing this value leads to resetting the statistics.";
    public static final int TIMING_NUMBER_OF_CALLS_DEFAULT = 10;
    public static final String TIMING_NUMBER_OF_PERCENTILES_NAME = "_sch___timingNumberOfPercentiles";
    public static final String TIMING_NUMBER_OF_PERCENTILES_CAPTION = "Number M of percentiles for timing";
    public static final String TIMING_NUMBER_OF_PERCENTILES_DESCRIPTION = "If timing is performed, this function finds M percentiles from all N times of execution of every block, including minimum and maximum. For example, M=5 means finding 5 percentiles 0% (minimum), 25%, 50% (median), 75%, 100% (maximum). M=2 means finding only minimum and maximum. M=1 means finding only 50% percentile (median).\nMinimal value M=0, then percentiles are not analysed at all.";
    public static final int TIMING_NUMBER_OF_PERCENTILES_DEFAULT = 5;
    public static final String VISIBLE_RESULT_PARAMETER_NAME = "_sch___visibleResult";
    public static final String VISIBLE_RESULT_PARAMETER_CAPTION = "Visible result";
    static final String RECURSIVE_LOADING_BLOCKED_MESSAGE = "[recursive loading chain blocked]";
    private static final InstalledPlatformsForTechnology CHAIN_PLATFORMS = InstalledPlatformsForTechnology.of("chain");
    private static final DefaultExecutorLoader<Chain> CHAIN_LOADER = new DefaultExecutorLoader("chains loader");
    private static final Set<String> NOW_USED_CHAIN_IDS;
    private String subChainJsonContent = "";
    private boolean fileExistenceRequired = true;
    private boolean executeIsolatedLoadingTimeFunctions = true;
    private boolean overrideBehaviour = false;
    private boolean multithreading = false;
    private boolean executeAll = false;
    private volatile ExecutorFactory executorFactory = null;
    private ExecutorSpecification chainExecutorSpecification = null;
    final AtomicInteger loadedChainsCount = new AtomicInteger(0);

    public UseChain() {
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public static UseChain getInstance(String sessionId) {
        return UseChain.setSession(new UseChain(), sessionId);
    }

    public static UseChain getSharedInstance() {
        return UseChain.setShared(new UseChain());
    }

    public static DefaultExecutorLoader<Chain> chainLoader() {
        return CHAIN_LOADER;
    }

    @Override
    public UseChain setFile(String file) {
        super.setFile(file);
        return this;
    }

    public String getSubChainJsonContent() {
        return this.subChainJsonContent;
    }

    public UseChain setSubChainJsonContent(String subChainJsonContent) {
        this.subChainJsonContent = UseChain.nonNull(subChainJsonContent);
        return this;
    }

    public boolean isFileExistenceRequired() {
        return this.fileExistenceRequired;
    }

    public UseChain setFileExistenceRequired(boolean fileExistenceRequired) {
        this.fileExistenceRequired = fileExistenceRequired;
        return this;
    }

    public boolean executeIsolatedLoadingTimeFunctions() {
        return this.executeIsolatedLoadingTimeFunctions;
    }

    public UseChain setExecuteIsolatedLoadingTimeFunctions(boolean executeIsolatedLoadingTimeFunctions) {
        this.executeIsolatedLoadingTimeFunctions = executeIsolatedLoadingTimeFunctions;
        return this;
    }

    public boolean isOverrideBehaviour() {
        return this.overrideBehaviour;
    }

    public UseChain setOverrideBehaviour(boolean overrideBehaviour) {
        this.overrideBehaviour = overrideBehaviour;
        return this;
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public UseChain setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
        return this;
    }

    public boolean isExecuteAll() {
        return this.executeAll;
    }

    public UseChain setExecuteAll(boolean executeAll) {
        this.executeAll = executeAll;
        return this;
    }

    public ExecutorSpecification chainExecutorSpecification() {
        return this.chainExecutorSpecification;
    }

    public static ChainExecutor newSharedExecutor(Path file) throws IOException {
        return UseChain.newSharedExecutor(file, CreateMode.REQUEST_ALL);
    }

    public static ChainExecutor newSharedExecutor(Path file, CreateMode createMode) throws IOException {
        return UseChain.newSharedExecutor(ChainSpecification.read(file), createMode);
    }

    public static ChainExecutor newSharedExecutor(ChainSpecification specification, CreateMode createMode) {
        return UseChain.getSharedInstance().newExecutor(specification, createMode);
    }

    public ChainExecutor newExecutor(Path file, CreateMode createMode) throws IOException {
        return this.newExecutor(ChainSpecification.read(file), createMode);
    }

    public ChainExecutor newExecutor(ChainSpecification specification, CreateMode createMode) {
        return this.use(specification).newExecutor(createMode);
    }

    @Override
    public void process() {
        if (!this.getFile().trim().isEmpty()) {
            try {
                this.useSeveralPaths(this.completeSeveralFilePaths());
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        } else {
            String subChainJsonContent = this.subChainJsonContent.trim();
            if (subChainJsonContent.isEmpty()) {
                throw new IllegalArgumentException("One of arguments \"Chain JSON file/folder\" or \"Chain JSON content\" must be non-empty");
            }
            this.useContent(subChainJsonContent);
        }
    }

    public ExecutorFactory executorFactory() {
        String sessionId = this.getSessionId();
        if (sessionId == null) {
            throw new IllegalStateException("Cannot create executor factory: session ID was not set");
        }
        ExecutorFactory executorFactory = this.executorFactory;
        if (executorFactory == null) {
            this.executorFactory = executorFactory = UseChain.globalLoaders().newFactory(sessionId);
        }
        return executorFactory;
    }

    public void useSeveralPaths(List<Path> chainSpecificationPaths) throws IOException {
        Objects.requireNonNull(chainSpecificationPaths, "Null chains paths");
        StringBuilder sb = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? new StringBuilder() : null;
        for (Path path : chainSpecificationPaths) {
            this.usePath(path, null, sb);
        }
        if (sb != null) {
            this.getScalar().setTo(sb.toString());
        }
    }

    public void usePath(Path chainSpecificationPath) throws IOException {
        this.usePath(chainSpecificationPath, null, null);
    }

    public int usePath(Path chainSpecificationPath, ExtensionSpecification.Platform platform, StringBuilder report) throws IOException {
        Objects.requireNonNull(chainSpecificationPath, "Null chains path");
        if (!Files.exists(chainSpecificationPath, new LinkOption[0])) {
            if (this.fileExistenceRequired) {
                throw new FileNotFoundException("Chain file or chains folder " + String.valueOf(chainSpecificationPath) + " does not exist");
            }
            return 0;
        }
        List<ChainSpecification> chainSpecifications = Files.isDirectory(chainSpecificationPath, new LinkOption[0]) ? ChainSpecification.readAllIfValid(chainSpecificationPath, true) : Collections.singletonList(ChainSpecification.read(chainSpecificationPath));
        this.use(chainSpecifications, platform, report);
        return chainSpecifications.size();
    }

    public void useContent(String chainJsonContent) {
        ChainSpecification chainSpecification = ChainSpecification.of(chainJsonContent);
        long t1 = UseChain.infoTime();
        Optional<Chain> chain = this.useIfNonRecursive(chainSpecification);
        long t2 = UseChain.infoTime();
        LOG.log(chain.isPresent() ? System.Logger.Level.DEBUG : System.Logger.Level.INFO, () -> String.format(Locale.US, "Chain \"%s\"%s %screated from text parameter in %.3f ms", chain.isEmpty() ? RECURSIVE_LOADING_BLOCKED_MESSAGE : ((Chain)chain.get()).name(), UseChain.additionalChainInformation(chain.orElse(null)), chain.isPresent() ? "" : "not ", (double)(t2 - t1) * 1.0E-6));
        if (this.isOutputNecessary(DEFAULT_OUTPUT_PORT)) {
            this.getScalar().setTo("Chain:\nCategory: '" + chainSpecification.chainCategory() + "'\nName: '" + chainSpecification.chainName() + "'");
        }
    }

    public void use(List<ChainSpecification> chainSpecifications, StringBuilder report) {
        this.use(chainSpecifications, null, report);
    }

    public Chain use(ChainSpecification chainSpecification) {
        Optional<Chain> result = this.useIfNonRecursive(chainSpecification);
        if (result.isEmpty()) {
            throw new IllegalStateException("Recursive using of the chain is not allowed here");
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Chain> useIfNonRecursive(ChainSpecification chainSpecification) {
        Objects.requireNonNull(chainSpecification, "Null chainSpecification");
        String chainId = chainSpecification.getExecutor().getId();
        this.chainExecutorSpecification = null;
        Object object = NOW_USED_CHAIN_IDS;
        synchronized (object) {
            if (NOW_USED_CHAIN_IDS.contains(chainId)) {
                return Optional.empty();
            }
            NOW_USED_CHAIN_IDS.add(chainId);
        }
        try {
            object = Optional.of(this.register(chainSpecification));
            return object;
        }
        finally {
            NOW_USED_CHAIN_IDS.remove(chainId);
        }
    }

    public static void useAllInstalledInSharedContext() throws IOException {
        UseChain useChain = UseChain.getSharedInstance();
        for (ExtensionSpecification.Platform platform : CHAIN_PLATFORMS.installedPlatforms()) {
            if (!platform.hasSpecifications()) continue;
            UseChain.useInstalledFolder(useChain, platform.specificationsFolder(), platform, "installed chain specifications");
        }
        if (ADDITIONAL_STANDARD_CHAINS_PATH != null) {
            for (String folder : ADDITIONAL_STANDARD_CHAINS_PATH.split("[\\;]")) {
                UseChain.useInstalledFolder(useChain, Paths.get(folder, new String[0]), null, "additional chain specifications");
            }
        }
    }

    public static ControlSpecification createLogTimingControl(String parameterName) {
        ControlSpecification result = new ControlSpecification();
        result.setName(parameterName);
        result.setCaption(LOG_TIMING_CAPTION);
        result.setDescription(LOG_TIMING_DESCRIPTION);
        result.setValueType(ParameterValueType.BOOLEAN);
        result.setDefaultJsonValue(JsonValue.TRUE);
        result.setAdvanced(true);
        return result;
    }

    public static ControlSpecification createTimingLogLevelControl(String parameterName) {
        ControlSpecification result = new ControlSpecification();
        result.setName(parameterName);
        result.setCaption(TIMING_LOG_LEVEL_CAPTION);
        result.setDescription(TIMING_LOG_LEVEL_DESCRIPTION);
        result.setValueType(ParameterValueType.STRING);
        result.setDefaultStringValue(TIMING_LOG_LEVEL_DEFAULT);
        result.setEditionType(ControlEditionType.ENUM);
        result.setItems(List.of(new ControlSpecification.EnumItem(System.Logger.Level.WARNING.getName()), new ControlSpecification.EnumItem(System.Logger.Level.INFO.getName()), new ControlSpecification.EnumItem(System.Logger.Level.DEBUG.getName()), new ControlSpecification.EnumItem(System.Logger.Level.TRACE.getName())));
        result.setAdvanced(true);
        return result;
    }

    public static ControlSpecification createTimingNumberOfCallsControl(String parameterName) {
        ControlSpecification result = new ControlSpecification();
        result.setName(parameterName);
        result.setCaption(TIMING_NUMBER_OF_CALLS_CAPTION);
        result.setDescription(TIMING_NUMBER_OF_CALLS_DESCRIPTION);
        result.setValueType(ParameterValueType.INT);
        result.setDefaultJsonValue((JsonValue)Jsons.toJsonIntValue(10));
        result.setEditionType(ControlEditionType.VALUE);
        result.setAdvanced(true);
        return result;
    }

    public static ControlSpecification createTimingNumberOfPercentilesControl(String parameterName) {
        ControlSpecification result = new ControlSpecification();
        result.setName(parameterName);
        result.setCaption(TIMING_NUMBER_OF_PERCENTILES_CAPTION);
        result.setDescription(TIMING_NUMBER_OF_PERCENTILES_DESCRIPTION);
        result.setValueType(ParameterValueType.INT);
        result.setDefaultJsonValue((JsonValue)Jsons.toJsonIntValue(5));
        result.setEditionType(ControlEditionType.VALUE);
        result.setAdvanced(true);
        return result;
    }

    public static ControlSpecification createVisibleResultControl(ExecutorSpecification specification, String parameterName) {
        String firstEnumValue = null;
        ArrayList<ControlSpecification.EnumItem> items = new ArrayList<ControlSpecification.EnumItem>();
        for (PortSpecification portSpecification : specification.getOutputPorts().values()) {
            String executorPortName = portSpecification.getName();
            if (firstEnumValue == null && !executorPortName.equals("settings")) {
                firstEnumValue = executorPortName;
            }
            items.add(new ControlSpecification.EnumItem(executorPortName));
        }
        if (items.size() < 2) {
            return null;
        }
        if (firstEnumValue == null) {
            firstEnumValue = specification.getOutputPorts().values().iterator().next().getName();
        }
        ControlSpecification result = new ControlSpecification();
        result.setName(parameterName);
        result.setCaption(VISIBLE_RESULT_PARAMETER_CAPTION);
        result.setValueType(ParameterValueType.ENUM_STRING);
        result.setEditionType(ControlEditionType.ENUM);
        result.setItems(items);
        result.setDefaultStringValue(firstEnumValue);
        return result;
    }

    public static void addSettingsPorts(ExecutorSpecification result) {
        result.addFirstInputPort(new PortSpecification().setName("settings").setValueType(DataType.SCALAR));
        result.addFirstOutputPort(new PortSpecification().setName("settings").setHint("Actually used settings (JSON)").setAdvanced(true).setValueType(DataType.SCALAR));
    }

    private void use(List<ChainSpecification> chainSpecifications, ExtensionSpecification.Platform platform, StringBuilder report) {
        ChainSpecification.checkIdDifference(chainSpecifications);
        int n = chainSpecifications.size();
        for (int i = 0; i < n; ++i) {
            Optional<Chain> chain;
            ChainSpecification chainSpecification = chainSpecifications.get(i);
            long t1 = UseChain.infoTime();
            if (platform != null) {
                chainSpecification.addTags(platform.getTags());
                chainSpecification.setPlatformId(platform.getId());
                chainSpecification.setPlatformCategory(platform.getCategory());
            }
            try {
                chain = this.useIfNonRecursive(chainSpecification);
            }
            catch (ChainLoadingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ChainRunningException("Cannot load the chain " + String.valueOf(chainSpecification.getSpecificationFile()), e);
            }
            long t2 = UseChain.infoTime();
            int index = i;
            LOG.log(chain.isPresent() ? System.Logger.Level.DEBUG : System.Logger.Level.INFO, () -> String.format(Locale.US, "Chain %s\"%s\"%s %sloaded from %s in %.3f ms", n > 1 ? index + 1 + "/" + n + " " : "", chainSpecification.getExecutor().getName(), UseChain.additionalChainInformation(chain.orElse(null)), chain.isPresent() ? "" : "not ", chainSpecification.getSpecificationFile().toAbsolutePath(), (double)(t2 - t1) * 1.0E-6));
        }
        if (report != null) {
            for (ChainSpecification specification : chainSpecifications) {
                Path file = specification.getSpecificationFile();
                Object message = file != null ? file.toString() : specification.canonicalName() + " (no file)";
                report.append((String)message).append("\n");
            }
        }
    }

    private Chain register(ChainSpecification chainSpecification) {
        Objects.requireNonNull(chainSpecification, "Null chainSpecification");
        if (this.getSessionId() == null) {
            throw new IllegalStateException("Cannot register new chain: session ID was not set");
        }
        ExecutorFactory executorFactory = this.executorFactory();
        Chain chain = Chain.of(this, executorFactory, chainSpecification);
        if (chain.getCurrentDirectory() == null) {
            chain.setCurrentDirectory(this.getCurrentDirectory());
        }
        if (this.overrideBehaviour) {
            chain.setMultithreading(this.multithreading);
            chain.setExecuteAll(this.executeAll);
        }
        CHAIN_LOADER.registerWorker(executorFactory.sessionId(), this.buildChainSpecificationAndExecuteLoadingTimeWithoutInputs(chain), chain);
        this.loadedChainsCount.incrementAndGet();
        return chain;
    }

    private ExecutorSpecification buildChainSpecificationAndExecuteLoadingTimeWithoutInputs(Chain chain) {
        String category;
        Objects.requireNonNull(chain, "Null chain");
        ExecutorSpecification result = new ExecutorSpecification();
        result.setTo(new InterpretChain());
        result.setTo(chain);
        result.setSourceInfo(null, chain.chainSpecificationPath()).setLanguageName(CHAIN_LANGUAGE_NAME);
        if (chain.hasPlatformId()) {
            result.setPlatformId(chain.platformId());
        }
        if ((category = result.getCategory()) != null) {
            result.setCategory(ExecutorSpecification.correctDynamicCategory(category, !chain.isAutogeneratedCategory()));
            result.updateCategoryPrefix(chain.platformCategory());
        }
        this.executeLoadingTimeBlocksWithoutInputs(chain, this.executeIsolatedLoadingTimeFunctions);
        result.addControl(new ControlSpecification().setName(DO_ACTION_NAME).setCaption(DO_ACTION_CAPTION).setDescription(DO_ACTION_DESCRIPTION).setValueType(ParameterValueType.BOOLEAN).setDefaultJsonValue(JsonValue.TRUE).setAdvanced(false));
        result.addControl(UseChain.createLogTimingControl(LOG_TIMING_NAME));
        result.addControl(UseChain.createTimingLogLevelControl(TIMING_LOG_LEVEL_NAME));
        result.addControl(UseChain.createTimingNumberOfCallsControl(TIMING_NUMBER_OF_CALLS_NAME));
        result.addControl(UseChain.createTimingNumberOfPercentilesControl(TIMING_NUMBER_OF_PERCENTILES_NAME));
        UseChain.addChainSettings(result, chain);
        ControlSpecification visibleResult = UseChain.createVisibleResultControl(result, VISIBLE_RESULT_PARAMETER_NAME);
        if (visibleResult != null) {
            result.addControl(visibleResult);
        }
        this.chainExecutorSpecification = result;
        return this.chainExecutorSpecification;
    }

    private void executeLoadingTimeBlocksWithoutInputs(Chain chain, boolean executeIsolatedLoadingTimeFunctions) {
        for (ChainBlock block : chain.getAllBlocks().values()) {
            if (!block.isExecutedAtLoadingTime()) continue;
            block.reinitialize(true);
            if (block.numberOfConnectedInputPorts() != 0) continue;
            ExecutionBlock executor = block.getExecutor();
            if (!executeIsolatedLoadingTimeFunctions && !(executor instanceof UseSettings)) continue;
            try {
                executor.reset();
                executor.execute(ExecutionBlock.ExecutionMode.SILENT);
            }
            catch (ChainLoadingException e) {
                throw e;
            }
            catch (IOError | AssertionError | RuntimeException e) {
                throw new ChainLoadingException(((Throwable)e).getMessage(), (Throwable)e);
            }
        }
    }

    private static void useInstalledFolder(UseChain useChain, Path folder, ExtensionSpecification.Platform platform, String name) throws IOException {
        long t1 = System.nanoTime();
        int n = useChain.usePath(folder, platform, null);
        long t2 = System.nanoTime();
        UseChain.logInfo(() -> String.format(Locale.US, "Loading %d %s from %s: %.3f ms", n, name, folder, (double)(t2 - t1) * 1.0E-6));
    }

    private static String additionalChainInformation(Chain chain) {
        if (chain == null) {
            return " [recursive loading chain blocked]";
        }
        return !chain.hasSettings() ? "" : ", " + String.valueOf(chain.getSettingsBuilder());
    }

    private static void addChainSettings(ExecutorSpecification result, Chain chain) {
        ChainBlock useChainSettingsBlock = UseChain.findUseChainSettings(chain);
        if (useChainSettingsBlock == null) {
            UseSettings.addChainControlsAndPorts(result, null);
            return;
        }
        UseChainSettings useChainSettings = (UseChainSettings)useChainSettingsBlock.getExecutor();
        SettingsBuilder mainSettingsBuilder = useChainSettings.settingsBuilder();
        chain.assignSettings(mainSettingsBuilder);
        UseSettings.addChainControlsAndPorts(result, mainSettingsBuilder);
        result.setSettings(mainSettingsBuilder.specification());
        result.createOptionsIfAbsent().createServiceIfAbsent().setSettingsId(mainSettingsBuilder.id());
        UseChain.addSettingsPorts(result);
    }

    private static ChainBlock findUseChainSettings(Chain chain) {
        for (ChainBlock block : chain.getAllBlocks().values()) {
            if (!block.isExecutedAtLoadingTime() || !(block.getExecutor() instanceof UseChainSettings)) continue;
            return block;
        }
        return null;
    }

    static {
        UseChain.globalLoaders().register(CHAIN_LOADER);
        NOW_USED_CHAIN_IDS = Collections.synchronizedSet(new HashSet());
    }
}

