/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import java.util.Objects;
import java.util.UUID;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.external.UsedForExternalCommunication;

public enum DataType {
    MAT("mat", UUID.fromString("031FC202-0193-4933-AB2E-D81492CE67E0")){

        @Override
        public Class<? extends Data> typeClass() {
            return SMat.class;
        }

        @Override
        public Data createEmpty() {
            return new SMat();
        }
    }
    ,
    SCALAR("scalar", UUID.fromString("869bc442-bd01-4094-afc1-783b9ed1c24e")){

        @Override
        public Class<? extends Data> typeClass() {
            return SScalar.class;
        }

        @Override
        public Data createEmpty() {
            return new SScalar();
        }
    }
    ,
    NUMBERS("numbers", UUID.fromString("C72A2A31-75BA-4E09-A02B-A9CBC4AC62D2")){

        @Override
        public Class<? extends Data> typeClass() {
            return SNumbers.class;
        }

        @Override
        public Data createEmpty() {
            return new SNumbers();
        }
    };

    private final String typeName;
    @UsedForExternalCommunication
    private final UUID uuid;

    private DataType(String name, UUID uuid) {
        this.typeName = Objects.requireNonNull(name, "Null name");
        this.uuid = Objects.requireNonNull(uuid, "Null uuid");
    }

    @UsedForExternalCommunication
    public final String typeName() {
        return this.typeName;
    }

    @UsedForExternalCommunication
    public final UUID uuid() {
        return this.uuid;
    }

    public abstract Data createEmpty();

    public abstract Class<? extends Data> typeClass();

    @UsedForExternalCommunication
    public static DataType ofTypeName(String name) {
        DataType result = DataType.ofTypeNameOrNull(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown name " + name);
        }
        return result;
    }

    public static DataType ofTypeNameOrNull(String name) {
        Objects.requireNonNull(name, "Null name");
        for (DataType type : DataType.values()) {
            if (!type.typeName.equals(name)) continue;
            return type;
        }
        return null;
    }

    public static DataType ofUUID(UUID uuid) {
        Objects.requireNonNull(uuid, "Null uuid");
        for (DataType type : DataType.values()) {
            if (!type.uuid.equals(uuid)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown UUID " + String.valueOf(uuid));
    }

    public static DataType ofUUID(String uuid) {
        DataType result = DataType.ofUUIDOrNull(uuid);
        if (result == null) {
            throw new IllegalArgumentException("Unknown UUID " + uuid);
        }
        return result;
    }

    public static DataType ofUUIDOrNull(String uuid) {
        Objects.requireNonNull(uuid, "Null uuid");
        for (DataType type : DataType.values()) {
            if (!type.uuid.toString().equals(uuid)) continue;
            return type;
        }
        return null;
    }
}

