/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.extensions;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.executors.api.SystemEnvironment;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.system.ExecutionSystemConfigurationException;
import net.algart.external.UsedForExternalCommunication;

public class InstalledExtensions {
    public static String CORE_PLATFORM_ID = "b58342ef-eaf4-4645-b672-d001f327293f";
    @UsedForExternalCommunication
    public static final String EXTENSIONS_ROOT_PROPERTY = "net.algart.executors.root";
    @UsedForExternalCommunication
    public static final String EXTENSIONS_PATH_PROPERTY = "net.algart.executors.path";
    @UsedForExternalCommunication
    public static final String EXTENSIONS_CHECK_EXISTING_PATHS_PROPERTY = "net.algart.executors.check.existing.paths";
    public static final boolean ENABLE_REPLACEMENT_IN_EXTENSIONS_PROPERTIES = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.pathReplacementAllowed", (boolean)false);
    public static final String EXTENSIONS_ROOT = InstalledExtensions.replaceHome(Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.root", null));
    public static final String EXTENSIONS_PATH = InstalledExtensions.replaceHome(Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.path", null));
    public static final boolean CHECK_EXISTING_PATHS = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.check.existing.paths", (boolean)true);

    private InstalledExtensions() {
    }

    public static Path extensionPath(String path) {
        Objects.requireNonNull(path, "Null path");
        return Path.of(path, new String[0]).toAbsolutePath().normalize();
    }

    public static Collection<Path> installedExtensionsPaths() {
        try {
            if (EXTENSIONS_PATH != null) {
                String[] split = EXTENSIONS_PATH.split("\\" + File.pathSeparator);
                return Arrays.stream(split).map(InstalledExtensions::extensionPath).toList();
            }
            if (EXTENSIONS_ROOT != null) {
                return ExtensionSpecification.allExtensionFolders(InstalledExtensions.extensionPath(EXTENSIONS_ROOT));
            }
        }
        catch (IOException | InvalidPathException e) {
            throw new IllegalStateException("Installed extensions root path " + EXTENSIONS_ROOT + ", defined in \"net.algart.executors.root\" system.property, is problematic: scanning it leads to I/O exception " + String.valueOf(e), e);
        }
        throw new IllegalStateException("Installed extensions paths are not defined: they should be set either via the system property \"net.algart.executors.path\" (separated by \"" + File.pathSeparator + "\") or via the system property \"net.algart.executors.root\" (root folder of all extensions, which will be scanned recursively)");
    }

    public static List<ExtensionSpecification> allInstalledExtensions() {
        return InstalledPlatformsHolder.installedExtensions();
    }

    public static List<ExtensionSpecification.Platform> allInstalledPlatforms() {
        return InstalledPlatformsHolder.installedPlatforms();
    }

    public static Map<String, ExtensionSpecification.Platform> allInstalledPlatformsMap() {
        return InstalledPlatformsHolder.installedPlatformsMap();
    }

    public static ExtensionSpecification.Platform installedPlatform(String id) {
        Objects.requireNonNull(id, "Null platform ID");
        ExtensionSpecification.Platform platform = InstalledExtensions.allInstalledPlatformsMap().get(id);
        if (platform == null) {
            throw new IllegalArgumentException("Platform with ID \"" + id + "\" is not installed");
        }
        return platform;
    }

    public static void checkDependencies(Map<String, ExtensionSpecification.Platform> platformMap) {
        Objects.requireNonNull(platformMap, "Null platformMap");
        if (!platformMap.isEmpty() && !platformMap.containsKey(CORE_PLATFORM_ID)) {
            throw new ExecutionSystemConfigurationException("No core platform installed (ID \"" + CORE_PLATFORM_ID + "\")");
        }
        for (ExtensionSpecification.Platform platform : platformMap.values()) {
            Objects.requireNonNull(platform, "Null platform inside platformMap");
            List<ExtensionSpecification.Platform.Dependency> dependencies = platform.getDependencies();
            for (ExtensionSpecification.Platform.Dependency dependency : dependencies) {
                if (platformMap.containsKey(dependency.getId())) continue;
                String id = dependency.getId();
                assert (id != null);
                String name = dependency.getName();
                String description = dependency.getDescription();
                throw new ExecutionSystemConfigurationException("Platform \"" + platform.getName() + "\", ID \"" + platform.getId() + "\" depends on non-existing platform" + (String)(name == null ? "" : " \"" + name + "\"") + ", ID \"" + id + "\"" + (String)(description == null ? "" : " (" + description + ")"));
            }
        }
    }

    private static String replaceHome(String path) {
        return ENABLE_REPLACEMENT_IN_EXTENSIONS_PROPERTIES ? SystemEnvironment.replaceHomeEnvironmentVariable(path) : path;
    }

    private static class InstalledPlatformsHolder {
        private static List<ExtensionSpecification> installedExtensions = null;
        private static List<ExtensionSpecification.Platform> installedPlatforms = null;
        private static Map<String, ExtensionSpecification.Platform> installedPlatformsMap = null;

        private InstalledPlatformsHolder() {
        }

        private static synchronized List<ExtensionSpecification> installedExtensions() {
            InstalledPlatformsHolder.load();
            return installedExtensions;
        }

        private static synchronized List<ExtensionSpecification.Platform> installedPlatforms() {
            InstalledPlatformsHolder.load();
            return installedPlatforms;
        }

        private static synchronized Map<String, ExtensionSpecification.Platform> installedPlatformsMap() {
            InstalledPlatformsHolder.load();
            return installedPlatformsMap;
        }

        private static void load() {
            if (installedExtensions == null) {
                try {
                    ArrayList<ExtensionSpecification> extensions = new ArrayList<ExtensionSpecification>();
                    ArrayList<ExtensionSpecification.Platform> platforms = new ArrayList<ExtensionSpecification.Platform>();
                    LinkedHashMap<String, ExtensionSpecification.Platform> platformsMap = new LinkedHashMap<String, ExtensionSpecification.Platform>();
                    for (Path path : InstalledExtensions.installedExtensionsPaths()) {
                        ExtensionSpecification extension = ExtensionSpecification.readFromFolder(path);
                        extensions.add(extension);
                        for (ExtensionSpecification.Platform platform : extension.getPlatforms()) {
                            if (CHECK_EXISTING_PATHS) {
                                platform.checkExistingPathsIfRequired();
                            }
                            platform.setImmutable();
                            ExtensionSpecification.Platform existing = platformsMap.put(platform.getId(), platform);
                            if (existing != null) {
                                throw new IOException("Invalid set of extensions: duplicate id \"" + platform.getId() + "\" for platform, named \"" + platform.getName() + "\", in folder " + String.valueOf(path) + " (there is another platform with this id, named \"" + existing.getName() + "\")");
                            }
                            platforms.add(platform);
                        }
                    }
                    installedExtensions = Collections.unmodifiableList(extensions);
                    installedPlatforms = Collections.unmodifiableList(platforms);
                    installedPlatformsMap = Collections.unmodifiableMap(platformsMap);
                    InstalledExtensions.checkDependencies(installedPlatformsMap);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
    }
}

