/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.graalvm.GraalContextCustomizer;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.io.IOAccess;

public enum GraalSafety implements GraalContextCustomizer
{
    PURE(false, "pure"){

        @Override
        public void customize(Context.Builder builder) {
        }
    }
    ,
    SAFE(true, "safe"){

        @Override
        public void customize(Context.Builder builder) {
            builder.allowIO(IOAccess.ALL);
            builder.allowHostAccess(HostAccess.ALL);
            builder.allowHostClassLookup(GraalSafety::isSafeClass);
        }
    }
    ,
    ALL_ACCESS(true, "all-access"){

        @Override
        public void customize(Context.Builder builder) {
            GraalContextCustomizer.ALL_ACCESS.customize(builder);
        }

        @Override
        public boolean isAllAccess() {
            return true;
        }
    };

    private static final Set<String> SAFE_CLASSES;
    private final boolean supportedJavaAccess;
    private final String safetyName;

    private GraalSafety(boolean supportedJavaAccess, String safetyName) {
        this.supportedJavaAccess = supportedJavaAccess;
        this.safetyName = safetyName;
    }

    public String safetyName() {
        return this.safetyName;
    }

    public static GraalSafety ofOrNull(String name) {
        Objects.requireNonNull(name, "Null safety name");
        for (GraalSafety safety : GraalSafety.values()) {
            if (!name.equals(safety.safetyName)) continue;
            return safety;
        }
        return null;
    }

    @Override
    public boolean isJavaAccessSupported() {
        return this.supportedJavaAccess;
    }

    public boolean isWorkingDirectorySupported() {
        return this != PURE;
    }

    public String toString() {
        return this.safetyName;
    }

    private static boolean isSafeClass(String className) {
        return SAFE_CLASSES.contains(className);
    }

    static {
        SAFE_CLASSES = new HashSet<String>(Arrays.asList(Object.class.getCanonicalName(), String.class.getCanonicalName(), Locale.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), Math.class.getCanonicalName(), StrictMath.class.getCanonicalName(), Arrays.class.getCanonicalName(), Character.TYPE.getCanonicalName(), Boolean.TYPE.getCanonicalName(), Byte.TYPE.getCanonicalName(), Short.TYPE.getCanonicalName(), Integer.TYPE.getCanonicalName(), Long.TYPE.getCanonicalName(), Float.TYPE.getCanonicalName(), Double.TYPE.getCanonicalName(), char[].class.getCanonicalName(), boolean[].class.getCanonicalName(), byte[].class.getCanonicalName(), short[].class.getCanonicalName(), int[].class.getCanonicalName(), long[].class.getCanonicalName(), float[].class.getCanonicalName(), double[].class.getCanonicalName(), Color.class.getCanonicalName(), BufferedImage.class.getCanonicalName(), BasicStroke.class.getCanonicalName(), RenderingHints.class.getCanonicalName(), Point2D.Float.class.getCanonicalName(), Point2D.Double.class.getCanonicalName(), Polygon.class.getCanonicalName(), Rectangle2D.Float.class.getCanonicalName(), Rectangle2D.Double.class.getCanonicalName(), Font.class.getCanonicalName(), Ellipse2D.Float.class.getCanonicalName(), Ellipse2D.Double.class.getCanonicalName(), Line2D.Float.class.getCanonicalName(), Line2D.Double.class.getCanonicalName(), AffineTransform.class.getCanonicalName(), AffineTransformOp.class.getCanonicalName(), RescaleOp.class.getCanonicalName(), LookupOp.class.getCanonicalName(), ColorConvertOp.class.getCanonicalName(), ConvolveOp.class.getCanonicalName(), GradientPaint.class.getCanonicalName(), SScalar.class.getCanonicalName(), SNumbers.class.getCanonicalName(), SMat.class.getCanonicalName()));
    }
}

