/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.scriptengine;

import javax.script.ScriptException;

public final class JavaScriptException
extends RuntimeException {
    private static final long serialVersionUID = -1909706924795350246L;

    public JavaScriptException(String message, ScriptException cause) {
        super(message, cause);
    }

    public static RuntimeException wrap(ScriptException scriptException, String javaScript) {
        Throwable cause = scriptException.getCause();
        if (cause != null) {
            cause = cause.getCause();
        }
        if (cause instanceof NullPointerException || cause instanceof IllegalArgumentException || cause instanceof IllegalStateException || cause instanceof UnsupportedOperationException) {
            return (RuntimeException)cause;
        }
        return new JavaScriptException(scriptException.getMessage() + "\nOccurred while attempt to execute JavaScript code:\n" + JavaScriptException.reduce(javaScript), scriptException);
    }

    private static String reduce(String value) {
        return value == null ? "" : (value.length() > 1024 ? value.substring(0, 1024) + "..." : value);
    }
}

