/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains.core;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.multichains.MultiChain;
import net.algart.executors.api.multichains.core.CombineMultiChainSettings;
import net.algart.executors.api.multichains.core.UseMultiChain;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.system.ExecutorFactory;

public abstract class MultiChainExecutor
extends Executor {
    private volatile MultiChain multiChain = null;

    public MultiChain multiChain() {
        MultiChain multiChain = this.multiChain;
        if (multiChain == null) {
            this.multiChain = multiChain = MultiChainExecutor.registeredMultiChain(this.getSessionId(), this.getExecutorId());
        }
        return multiChain;
    }

    public ExecutorFactory executorFactory() {
        return this.multiChain().executorFactory();
    }

    public SettingsBuilder settingsBuilder() {
        return this.multiChain().settingsBuilder();
    }

    public CombineMultiChainSettings newCombine() {
        return this.multiChain().newCombine();
    }

    public void selectChainVariant(String variant) {
        Objects.requireNonNull(variant, "Null variant");
        this.setStringParameter(this.multiChain().selectedChainParameter(), variant);
    }

    @Override
    public void close() {
        MultiChain multiChain = this.multiChain;
        if (multiChain != null) {
            this.multiChain = null;
            multiChain.freeResources();
        }
        super.close();
    }

    @Override
    public String toString() {
        return "Executor of " + String.valueOf(this.multiChain != null ? this.multiChain : "some non-initialized multi-chain");
    }

    public static MultiChain registeredMultiChain(String sessionId, String executorId) {
        Objects.requireNonNull(sessionId, "Cannot find multi-chain worker: session ID is not set");
        Objects.requireNonNull(executorId, "Cannot find multi-chain worker: executor ID is not set");
        MultiChain multiChain = UseMultiChain.multiChainLoader().registeredWorker(sessionId, executorId);
        return multiChain.clone();
    }
}

