/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains.core;

import net.algart.executors.api.multichains.MultiChain;
import net.algart.executors.api.multichains.MultiChainSettingsBuilder;
import net.algart.executors.api.multichains.core.CombineMultiChainSettings;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.settings.core.CombineSettings;
import net.algart.executors.api.settings.core.GetNamesOfSettings;
import net.algart.executors.api.settings.core.SplitSettings;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ExecutorSpecification;

public final class UseMultiChainSettings
extends UseSettings {
    private volatile MultiChain multiChain = null;

    public MultiChain getMultiChain() {
        return this.multiChain;
    }

    public void setMultiChain(MultiChain multiChain) {
        this.multiChain = multiChain;
    }

    @Override
    public ExecutorSpecification buildCombineSpecification(SettingsBuilder settingsBuilder) {
        if (this.multiChain == null) {
            throw new IllegalStateException("MultiChain is not set: UseMultiChainSettings cannot be used");
        }
        ExecutorSpecification result = super.buildCombineSpecification(settingsBuilder);
        result.createOptionsIfAbsent().createControllingIfAbsent().setGrouping(true).setGroupSelector(this.multiChain.selectedChainParameter());
        return result;
    }

    @Override
    protected boolean isNeedToAddOwner() {
        return true;
    }

    @Override
    protected SettingsBuilder newSettings(SettingsSpecification settingsSpecification) {
        if (this.multiChain == null) {
            throw new IllegalStateException("multiChain is not set: newSettings cannot be used");
        }
        return new MultiChainSettingsBuilder(settingsSpecification, this.multiChain);
    }

    @Override
    protected CombineSettings newCombineSettings() {
        return new CombineMultiChainSettings();
    }

    @Override
    protected SplitSettings newSplitSettings() {
        throw new UnsupportedOperationException("This method should not be called: " + String.valueOf(this.getClass()) + " must be used only for creating multi-chain settings, which has no split_id");
    }

    @Override
    protected GetNamesOfSettings newGetNamesOfSettings() {
        throw new UnsupportedOperationException("This method should not be called: " + String.valueOf(this.getClass()) + " must be used only for creating multi-chain settings, which has no get_names_id");
    }
}

