/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.parameters;

import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.parameters.NoValidParameterException;
import net.algart.executors.api.parameters.Parameters;
import net.algart.json.Jsons;

public enum ParameterValueType {
    INT("int", (Class)Integer.TYPE, new String[]{"int32"}){

        @Override
        public Integer toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Parameters.smartParseInt(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Integer toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.intValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonIntValue(0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            int v;
            try {
                v = Parameters.smartParseInt(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.toJsonIntValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJsonIntValue(parameters.getInteger(name));
        }
    }
    ,
    LONG("long", (Class)Long.TYPE, new String[]{"int64"}){

        @Override
        public Long toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Parameters.smartParseLong(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Long toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.longValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonIntValue(0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            long v;
            try {
                v = Parameters.smartParseLong(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.toJsonLongValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJsonLongValue(parameters.getLong(name));
        }
    }
    ,
    FLOAT("float", (Class)Float.TYPE, new String[0]){

        @Override
        public Float toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Float.valueOf((float)Double.parseDouble(stringValue));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Float toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return Float.valueOf((float)jsonNumber.doubleValue());
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonDoubleValue(0.0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return DOUBLE.toJsonValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return DOUBLE.toJsonValue(parameters, name);
        }
    }
    ,
    DOUBLE("double", (Class)Double.TYPE, new String[0]){

        @Override
        public Double toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Double toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.doubleValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonDoubleValue(0.0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            double v;
            try {
                v = Double.parseDouble(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.toJsonDoubleValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJsonDoubleValue(parameters.getDouble(name));
        }
    }
    ,
    BOOLEAN("boolean", (Class)Boolean.TYPE, new String[0]){

        @Override
        public Boolean toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            return Parameters.smartParseBoolean(stringValue);
        }

        @Override
        public Boolean toParameter(JsonValue jsonValue) {
            if (jsonValue == null) {
                return null;
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                return Boolean.FALSE;
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonBooleanValue(false);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            Boolean v = Parameters.smartParseBoolean(scalar);
            if (v == null) {
                return this.emptyJsonValue();
            }
            return Jsons.toJsonBooleanValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJsonBooleanValue(parameters.getBoolean(name));
        }
    }
    ,
    STRING("String", (Class)String.class, new String[]{"scalar"}){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public String toParameter(JsonValue jsonValue) {
            if (jsonValue == null) {
                return null;
            }
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                return "false";
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                return "true";
            }
            if (jsonValue instanceof JsonNumber) {
                return jsonValue.toString();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.toJsonStringValue("");
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return Jsons.toJsonStringValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJsonStringValue(parameters.getString(name));
        }
    }
    ,
    ENUM_STRING("String", (Class)Enum.class, new String[]{"scalar"}){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public Object toParameter(JsonValue jsonValue) {
            return STRING.toParameter(jsonValue);
        }

        @Override
        public JsonValue emptyJsonValue() {
            return STRING.emptyJsonValue();
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return STRING.toJsonValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return STRING.toJsonValue(parameters, name);
        }
    }
    ,
    SETTINGS("settings", (Class)JsonObject.class, new String[0]){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public Object toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonObject) {
                return jsonValue;
            }
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.newEmptyJson();
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            Objects.requireNonNull(scalar, "Null scalar");
            try {
                return Jsons.toJson(scalar, true);
            }
            catch (JsonException e) {
                return this.emptyJsonValue();
            }
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJson(parameters.getString(name, null), true);
        }
    };

    private final String typeName;
    private final Class<?> javaType;
    private final String[] typeNameAliases;
    private static final Map<String, ParameterValueType> ALL_TYPES;
    private static final ParameterValueType[] FOR_SUITABLE_JAVA_OBJECT;

    private ParameterValueType(String typeName, Class<?> javaType, String ... typeNameAliases) {
        this.typeName = typeName;
        this.javaType = javaType;
        this.typeNameAliases = typeNameAliases;
    }

    public String typeName() {
        return this.typeName;
    }

    public Class<?> javaType() {
        return this.javaType;
    }

    public abstract Object toParameter(String var1);

    public abstract Object toParameter(JsonValue var1);

    public Object toSmartParameter(JsonValue jsonValue) {
        Object probe = this.toParameter(jsonValue);
        if (probe != null) {
            return probe;
        }
        for (ParameterValueType parameterValueType : FOR_SUITABLE_JAVA_OBJECT) {
            probe = parameterValueType.toParameter(jsonValue);
            if (probe == null) continue;
            return probe;
        }
        return null;
    }

    public abstract JsonValue emptyJsonValue();

    public abstract JsonValue toJsonValue(Parameters var1, String var2) throws NoValidParameterException;

    public abstract JsonValue toJsonValue(String var1);

    public boolean isAllowedInExecutor() {
        return this != SETTINGS;
    }

    public boolean isSettings() {
        return this == SETTINGS;
    }

    public static ParameterValueType of(String name) {
        ParameterValueType result = ALL_TYPES.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown parameter value type: " + name);
        }
        return result;
    }

    public static ParameterValueType ofOrNull(String name) {
        return ALL_TYPES.get(name);
    }

    public static void main(String[] args) {
        for (ParameterValueType type : ParameterValueType.values()) {
            System.out.printf("%s: %s, %s, %s, %s%n", new Object[]{type, type.typeName(), Arrays.toString(type.typeNameAliases), ParameterValueType.of(type.typeName()), type.emptyJsonValue()});
            for (String v : Arrays.asList("TRUE", "12", "12.3", "axd", "{\"key\":12}")) {
                System.out.printf("  %s: %s%n", v, type.toJsonValue(v));
            }
        }
    }

    static {
        ALL_TYPES = new LinkedHashMap<String, ParameterValueType>();
        FOR_SUITABLE_JAVA_OBJECT = new ParameterValueType[]{SETTINGS, STRING, DOUBLE, BOOLEAN};
        for (ParameterValueType type : ParameterValueType.values()) {
            if (type == ENUM_STRING) continue;
            ALL_TYPES.put(type.typeName, type);
            for (String alias : type.typeNameAliases) {
                ALL_TYPES.put(alias, type);
            }
        }
    }
}

