/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.jep.JepPlatforms;
import net.algart.executors.api.python.JepCaller;
import net.algart.executors.api.python.PythonSpecification;
import net.algart.executors.api.python.core.InterpretPython;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.jep.additions.GlobalPythonConfiguration;

public class UsingPython {
    public static final String PYTHON_LANGUAGE_NAME = "Python";
    public static final String SUPPLIED_PYTHON_ROOTS_OUTPUT_NAME = "_py_supplied_python_roots";
    public static final String SUPPLIED_PYTHON_ROOTS_OUTPUT_CAPTION = "supplied python roots";
    public static final String SUPPLIED_PYTHON_ROOTS_OUTPUT_HINT = "List of Python root folders, supplied by this application and added to Python search paths";
    public static final String SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_NAME = "_py_supplied_python_specification";
    public static final String SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_CAPTION = "supplied python specification";
    public static final String SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_HINT = "List of Python executor specification folders, supplied by this application and used to find Python-based executors";
    private static final DefaultExecutorLoader<JepCaller> JEP_CALLER_LOADER = new DefaultExecutorLoader("Python JEP loader");

    private UsingPython() {
    }

    public static DefaultExecutorLoader<JepCaller> jepCallerLoader() {
        return JEP_CALLER_LOADER;
    }

    public static int usePath(String sessionId, Path pythonSpecificationPath, ExtensionSpecification.Platform platform) throws IOException {
        Objects.requireNonNull(pythonSpecificationPath, "Null path to Python specification files");
        List<PythonSpecification> pythonSpecifications = Files.isDirectory(pythonSpecificationPath, new LinkOption[0]) ? PythonSpecification.readAllIfValid(pythonSpecificationPath) : Collections.singletonList(PythonSpecification.read(pythonSpecificationPath));
        ExecutorSpecification.checkIdDifference(pythonSpecifications);
        int n = pythonSpecifications.size();
        for (int i = 0; i < n; ++i) {
            PythonSpecification pythonSpecification = pythonSpecifications.get(i);
            Executor.LOG.log(System.Logger.Level.DEBUG, "Loading Python caller " + (String)(n > 1 ? i + 1 + "/" + n + " " : "") + "from " + String.valueOf(pythonSpecification.getSpecificationFile()) + "...");
            if (platform != null) {
                pythonSpecification.updateCategoryPrefix(platform.getCategory());
                pythonSpecification.addTags(platform.getTags());
                pythonSpecification.setPlatformId(platform.getId());
            }
            UsingPython.use(sessionId, pythonSpecification);
        }
        return n;
    }

    public static void use(String sessionId, PythonSpecification pythonSpecification) throws IOException {
        UsingPython.correctPythonExecutorSpecification(pythonSpecification);
        JepCaller jepCaller = JepCaller.of(pythonSpecification);
        JEP_CALLER_LOADER.registerWorker(sessionId, pythonSpecification, jepCaller);
    }

    public static void useAllInstalledInSharedContext() throws IOException {
        for (ExtensionSpecification.Platform platform : JepPlatforms.pythonPlatforms().installedPlatforms()) {
            if (!platform.hasSpecifications()) continue;
            long t1 = System.nanoTime();
            int n = UsingPython.usePath("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f", platform.specificationsFolder(), platform);
            long t2 = System.nanoTime();
            Executor.LOG.log(System.Logger.Level.INFO, () -> String.format(Locale.US, "Loading %d installed Python specifications from %s: %.3f ms", n, platform.specificationsFolder(), (double)(t2 - t1) * 1.0E-6));
        }
    }

    public static void initializePython() {
        GlobalPythonConfiguration.INSTANCE.loadFromSystemProperties().useForJep();
        String pythonHome = GlobalPythonConfiguration.INSTANCE.pythonHomeInformation().pythonHome();
        Executor.LOG.log(System.Logger.Level.INFO, () -> "Python home: " + (pythonHome == null ? "n/a" : pythonHome));
    }

    private static void correctPythonExecutorSpecification(PythonSpecification pythonSpecification) {
        Objects.requireNonNull(pythonSpecification, "Null pythonSpecification");
        pythonSpecification.setTo(new InterpretPython());
        pythonSpecification.addSystemExecutorIdPort();
        if (pythonSpecification.hasPlatformId()) {
            pythonSpecification.addSystemPlatformIdPort();
        }
        UsingPython.addSpecialOutputPorts(pythonSpecification);
        pythonSpecification.setSourceInfoForSpecification().setLanguageName(PYTHON_LANGUAGE_NAME);
    }

    private static void addSpecialOutputPorts(ExecutorSpecification result) {
        if (!result.getOutputPorts().containsKey(SUPPLIED_PYTHON_ROOTS_OUTPUT_NAME)) {
            result.addOutputPort(new PortSpecification().setName(SUPPLIED_PYTHON_ROOTS_OUTPUT_NAME).setCaption(SUPPLIED_PYTHON_ROOTS_OUTPUT_CAPTION).setHint(SUPPLIED_PYTHON_ROOTS_OUTPUT_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
        if (!result.getOutputPorts().containsKey(SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_NAME)) {
            result.addOutputPort(new PortSpecification().setName(SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_NAME).setCaption(SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_CAPTION).setHint(SUPPLIED_PYTHON_SPECIFICATIONS_OUTPUT_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    static {
        ExecutionBlock.globalLoaders().register(JEP_CALLER_LOADER);
    }
}

