/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.JsonObject;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.settings.SubSettingsInheritanceMode;
import net.algart.executors.api.settings.core.AddSubSettings;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.json.Jsons;

public final class GetSubSettings
extends Executor
implements ReadOnlyExecutionInput {
    public static final String SETTINGS = "settings";
    public static final String SUB_SETTINGS = "sub-settings";
    private String subSettingsName = "subsettings";
    private SubSettingsInheritanceMode subSettingsInheritanceMode = SubSettingsInheritanceMode.NONE;
    private boolean useSubSettingsPrefix = true;

    public GetSubSettings() {
        this.setDefaultInputScalar(SETTINGS);
        this.setDefaultOutputScalar(SUB_SETTINGS);
    }

    public String getSubSettingsName() {
        return this.subSettingsName;
    }

    public GetSubSettings setSubSettingsName(String subSettingsName) {
        this.subSettingsName = GetSubSettings.nonEmpty(subSettingsName);
        return this;
    }

    public SubSettingsInheritanceMode getSubSettingsInheritanceMode() {
        return this.subSettingsInheritanceMode;
    }

    public GetSubSettings setSubSettingsInheritanceMode(SubSettingsInheritanceMode subSettingsInheritanceMode) {
        this.subSettingsInheritanceMode = GetSubSettings.nonNull(subSettingsInheritanceMode);
        return this;
    }

    public boolean isUseSubSettingsPrefix() {
        return this.useSubSettingsPrefix;
    }

    public GetSubSettings setUseSubSettingsPrefix(boolean useSubSettingsPrefix) {
        this.useSubSettingsPrefix = useSubSettingsPrefix;
        return this;
    }

    @Override
    public void process() {
        String subSettingsKey;
        JsonObject settings = AddSubSettings.scalarToJson(this.getInputScalar(SETTINGS, true));
        JsonObject subSettings = settings.getJsonObject(subSettingsKey = this.useSubSettingsPrefix ? ControlSpecification.settingsKey(this.subSettingsName) : this.subSettingsName);
        if (subSettings == null) {
            subSettings = Jsons.newEmptyJson();
        }
        JsonObject result = this.subSettingsInheritanceMode.inherit(settings, subSettings);
        this.getScalar(SUB_SETTINGS).setTo(Jsons.toPrettyString(result));
    }
}

