/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.UseSettings;

public abstract class SettingsExecutor
extends Executor
implements ReadOnlyExecutionInput {
    volatile SettingsBuilder settingsBuilder = null;

    public SettingsBuilder settingsBuilder() {
        String sessionId = this.getSessionId();
        String executorId = this.getExecutorId();
        if (sessionId == null) {
            throw new IllegalStateException("Cannot find settings: session ID is not set");
        }
        if (executorId == null) {
            throw new IllegalStateException("Cannot find settings: executor ID is not set");
        }
        SettingsBuilder settingsBuilder = this.settingsBuilder;
        if (settingsBuilder == null) {
            settingsBuilder = UseSettings.settingsLoader().registeredWorker(sessionId, executorId);
            this.settingsBuilder = settingsBuilder.clone();
        }
        return settingsBuilder;
    }

    void setSystemOutputs() {
        SettingsBuilder settingsBuilder = this.settingsBuilder();
        if (this.hasOutputPort("_ss___settings_name")) {
            this.getScalar("_ss___settings_name").setTo(settingsBuilder.name());
        }
    }
}

