/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.JsonObject;
import java.util.Locale;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.SettingsExecutor;
import net.algart.json.Jsons;

public class SplitSettings
extends SettingsExecutor
implements ReadOnlyExecutionInput {
    public SplitSettings() {
        this.setDefaultInputScalar("settings");
        this.setDefaultOutputScalar("settings");
        this.disableOnChangeParametersAutomatic();
    }

    @Override
    public void process() {
        this.setSystemOutputs();
        long t1 = SplitSettings.debugTime();
        SettingsBuilder settingsBuilder = this.settingsBuilder();
        String s = this.getInputScalar("settings", true).getValueOrDefault("").trim();
        JsonObject inputSettings = s.isEmpty() ? Jsons.newEmptyJson() : Jsons.toJson(s);
        settingsBuilder.splitSettingsToOutputPorts(this, inputSettings);
        inputSettings = Jsons.overrideEntries(settingsBuilder.build(this), inputSettings);
        this.getScalar("settings").setTo(Jsons.toPrettyString(inputSettings));
        long t2 = SplitSettings.debugTime();
        SplitSettings.logDebug(() -> String.format(Locale.US, "Splitting settings \"%s\": %.3f ms", settingsBuilder.splitName(), (double)(t2 - t1) * 1.0E-6));
    }

    @Override
    public String toString() {
        return "Split " + String.valueOf(this.settingsBuilder != null ? this.settingsBuilder : "some non-initialized settings");
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }
}

