/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;

public final class CopyMoveFiles
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_TARGET_ABSOLUTE_PATH = "target_absolute_path";
    private boolean doAction = true;
    private Action action = Action.COPY;
    private String target = "";
    private String globPattern = "*.(dat,tmp)";

    public CopyMoveFiles() {
        this.addInputScalar("file");
        this.setDefaultOutputScalar(OUTPUT_TARGET_ABSOLUTE_PATH);
        this.addOutputScalar("absolute_path");
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public CopyMoveFiles setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public Action getAction() {
        return this.action;
    }

    public CopyMoveFiles setAction(Action action) {
        this.action = CopyMoveFiles.nonNull(action);
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public CopyMoveFiles setTarget(String target) {
        this.target = CopyMoveFiles.nonNull(target);
        return this;
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public CopyMoveFiles setGlobPattern(String globPattern) {
        this.globPattern = CopyMoveFiles.nonEmpty(globPattern);
        return this;
    }

    @Override
    public void process() {
        block13: {
            Path fileOrFolder = this.completeFilePath().toAbsolutePath();
            Path target = PathPropertyReplacement.translatePropertiesAndCurrentDirectory(this.target, this);
            this.getScalar().setTo(target);
            if (!this.doAction) {
                return;
            }
            try {
                if (Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
                    CopyMoveFiles.logDebug(() -> this.action.title + " file " + String.valueOf(fileOrFolder) + " to " + String.valueOf(target));
                    this.action.action(fileOrFolder, target);
                    break block13;
                }
                if (!Files.exists(fileOrFolder, new LinkOption[0])) {
                    throw new FileNotFoundException(String.valueOf(fileOrFolder) + " does not exist: nothing to " + this.action.verb);
                }
                if (!Files.isDirectory(target, new LinkOption[0])) {
                    throw new IllegalArgumentException("If the source file/folder is a folder, the target must also be an existing folder, but it is not so: " + String.valueOf(target));
                }
                CopyMoveFiles.logDebug(() -> this.action.title + " files " + this.globPattern + " from folder " + String.valueOf(fileOrFolder) + " to " + String.valueOf(target));
                try (DirectoryStream<Path> files = Files.newDirectoryStream(fileOrFolder, this.globPattern);){
                    for (Path f : files) {
                        if (!Files.isRegularFile(f, new LinkOption[0])) continue;
                        this.action.action(f, target.resolve(fileOrFolder.relativize(f)));
                    }
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static enum Action {
        COPY("Copying", "copy"){

            @Override
            void action(Path file, Path target) throws IOException {
                Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        ,
        MOVE("Moving", "move"){

            @Override
            void action(Path file, Path target) throws IOException {
                Files.move(file, target, StandardCopyOption.REPLACE_EXISTING);
            }
        };

        private final String title;
        private final String verb;

        private Action(String title, String verb) {
            this.title = title;
            this.verb = verb;
        }

        abstract void action(Path var1, Path var2) throws IOException;
    }
}

