/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.control;

import java.util.function.Function;
import net.algart.executors.api.Executor;
import net.algart.executors.api.HighLevelException;
import net.algart.executors.modules.core.logic.ConditionStyle;

public class ThrowException
extends Executor {
    public static final String INPUT_CONDITION = "if";
    public static final String INPUT_REASON = "reason";
    public static final String S = "s";
    public static final String X = "x";
    public static final String M = "m";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean invert = false;
    private ExceptionKind exceptionKind = ExceptionKind.ASSERTION_ERROR;
    private String message = "Some problem occurred";

    public ThrowException() {
        this.addInputScalar(INPUT_CONDITION);
        this.addInputScalar(INPUT_REASON);
        this.addInputScalar(S);
        this.addInputNumbers(X);
        this.addInputMat(M);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(S);
        this.addOutputNumbers(X);
        this.addOutputMat(M);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public ThrowException setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = conditionStyle;
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public ExceptionKind getExceptionKind() {
        return this.exceptionKind;
    }

    public ThrowException setExceptionKind(ExceptionKind exceptionKind) {
        this.exceptionKind = ThrowException.nonNull(exceptionKind);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ThrowException setMessage(String message) {
        this.message = ThrowException.nonNull(message);
        return this;
    }

    @Override
    public void process() {
        this.getScalar(S).exchange(this.getInputScalar(S, true));
        this.getNumbers(X).exchange(this.getInputNumbers(X, true));
        this.getMat(M).exchange(this.getInputMat(M, true));
        if (this.condition()) {
            this.getScalar().remove();
            String additionalInformation = this.getInputScalar(INPUT_REASON, true).getValue();
            String message = this.message + (additionalInformation != null ? additionalInformation : "");
            this.exceptionKind.throwException(message);
        } else {
            this.getScalar().setTo("O'k");
        }
    }

    public boolean condition() {
        String conditionString = this.getInputScalar(INPUT_CONDITION).getValue();
        return this.conditionStyle.toBoolean(conditionString, false) != this.invert;
    }

    public static final class ExceptionKind
    extends Enum<ExceptionKind> {
        public static final /* enum */ ExceptionKind NULL_POINTER_EXCEPTION = new ExceptionKind(NullPointerException::new);
        public static final /* enum */ ExceptionKind ILLEGAL_ARGUMENT_EXCEPTION = new ExceptionKind(IllegalArgumentException::new);
        public static final /* enum */ ExceptionKind ILLEGAL_STATE_EXCEPTION = new ExceptionKind(IllegalStateException::new);
        public static final /* enum */ ExceptionKind INDEX_OUT_OF_BOUNDS_EXCEPTION = new ExceptionKind(IndexOutOfBoundsException::new);
        public static final /* enum */ ExceptionKind UNSUPPORTED_OPERATION_EXCEPTION = new ExceptionKind(UnsupportedOperationException::new);
        public static final /* enum */ ExceptionKind ASSERTION_ERROR = new ExceptionKind(AssertionError::new);
        private final Function<String, Throwable> exception;
        private static final /* synthetic */ ExceptionKind[] $VALUES;

        public static ExceptionKind[] values() {
            return (ExceptionKind[])$VALUES.clone();
        }

        public static ExceptionKind valueOf(String name) {
            return Enum.valueOf(ExceptionKind.class, name);
        }

        private ExceptionKind(Function<String, Throwable> exception) {
            this.exception = exception;
            Throwable test = exception.apply("");
            assert (test instanceof RuntimeException || test instanceof Error) : "Invalid exception in enum";
        }

        public void throwException(String message) {
            throw new HighLevelException(this.exception.apply(message));
        }

        private static /* synthetic */ ExceptionKind[] $values() {
            return new ExceptionKind[]{NULL_POINTER_EXCEPTION, ILLEGAL_ARGUMENT_EXCEPTION, ILLEGAL_STATE_EXCEPTION, INDEX_OUT_OF_BOUNDS_EXCEPTION, UNSUPPORTED_OPERATION_EXCEPTION, ASSERTION_ERROR};
        }

        static {
            $VALUES = ExceptionKind.$values();
        }
    }
}

