/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.ifelse.scalars;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class IfScalarThenScalar
extends Executor {
    public static final String INPUT_CONDITION = "if";
    public static final String INPUT_PORT_FALSE = "false";
    public static final String INPUT_PORT_TRUE = "true";
    public static final String OUTPUT_CONDITION = "if";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean defaultCondition = false;
    private String defaultFalse = "";
    private String defaultTrue = "";
    private boolean requireInput = true;

    public IfScalarThenScalar() {
        this.addInputScalar("if");
        this.addInputScalar(INPUT_PORT_FALSE);
        this.addInputScalar(INPUT_PORT_TRUE);
        this.addOutputScalar("if");
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public IfScalarThenScalar setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = IfScalarThenScalar.nonNull(conditionStyle);
        return this;
    }

    public boolean isDefaultCondition() {
        return this.defaultCondition;
    }

    public IfScalarThenScalar setDefaultCondition(boolean defaultCondition) {
        this.defaultCondition = defaultCondition;
        return this;
    }

    public String getDefaultFalse() {
        return this.defaultFalse;
    }

    public IfScalarThenScalar setDefaultFalse(String defaultFalse) {
        this.defaultFalse = IfScalarThenScalar.nonNull(defaultFalse);
        return this;
    }

    public String getDefaultTrue() {
        return this.defaultTrue;
    }

    public IfScalarThenScalar setDefaultTrue(String defaultTrue) {
        this.defaultTrue = IfScalarThenScalar.nonNull(defaultTrue);
        return this;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public IfScalarThenScalar setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        boolean condition = this.condition();
        String trueOrFalse = this.getInputScalar(IfScalarThenScalar.portName(condition), !this.requireInput).getValue();
        String defaultValue = condition ? this.defaultTrue : this.defaultFalse;
        this.getScalar().setTo(trueOrFalse != null ? trueOrFalse : (!defaultValue.isEmpty() ? defaultValue : null));
        this.getScalar("if").setTo(condition);
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        if ("if".equals(inputPortName)) {
            return null;
        }
        return IfScalarThenScalar.portName(this.condition()).equals(inputPortName);
    }

    public boolean condition() {
        String conditionString = this.getInputScalar("if", true).getValue();
        return this.conditionStyle.toBoolean(conditionString, this.defaultCondition);
    }

    private static String portName(boolean condition) {
        return condition ? INPUT_PORT_TRUE : INPUT_PORT_FALSE;
    }
}

