/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.loops;

import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class RepeatWhile
extends Executor {
    public static final String INPUT_CONDITION = "while";
    public static final String OUTPUT_IS_FIRST = "is_first";
    public static final String OUTPUT_IS_LAST = "is_last";
    public static final String OUTPUT_IS_NOT_FIRST = "is_not_first";
    public static final String OUTPUT_IS_NOT_LAST = "is_not_last";
    public static final String OUTPUT_COUNT = "count";
    public static final String OUTPUT_COUNT_1 = "count_1";
    public static final String S = "s";
    public static final String X = "x";
    public static final String M = "m";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean invertCondition = false;
    private Long maxIterationsCount = null;
    private boolean whileCondition = false;
    private boolean isFirstIteration = false;
    private boolean isLastIteration = false;
    private long counter = 0L;

    public RepeatWhile() {
        this.addInputScalar(INPUT_CONDITION);
        this.addOutputScalar(OUTPUT_IS_FIRST);
        this.addOutputScalar(OUTPUT_IS_LAST);
        this.addOutputScalar(OUTPUT_IS_NOT_FIRST);
        this.setDefaultOutputScalar(OUTPUT_IS_NOT_LAST);
        this.addOutputScalar(OUTPUT_COUNT);
        this.addOutputScalar(OUTPUT_COUNT_1);
        this.addInputScalar(S);
        this.addInputNumbers(X);
        this.addInputMat(M);
        this.addOutputScalar(S);
        this.addOutputNumbers(X);
        this.addOutputMat(M);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public RepeatWhile setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = RepeatWhile.nonNull(conditionStyle);
        return this;
    }

    public boolean isInvertCondition() {
        return this.invertCondition;
    }

    public RepeatWhile setInvertCondition(boolean invertCondition) {
        this.invertCondition = invertCondition;
        return this;
    }

    public Long getMaxIterationsCount() {
        return this.maxIterationsCount;
    }

    public RepeatWhile setMaxIterationsCount(Long maxIterationsCount) {
        if (maxIterationsCount != null) {
            RepeatWhile.positive(maxIterationsCount);
        }
        this.maxIterationsCount = maxIterationsCount;
        return this;
    }

    @Override
    public void initialize() {
        this.isFirstIteration = true;
        this.counter = 0L;
    }

    @Override
    public void process() {
        this.getScalar(S).exchange(this.getInputScalar(S, true));
        this.getNumbers(X).exchange(this.getInputNumbers(X, true));
        this.getMat(M).exchange(this.getInputMat(M, true));
        String conditionString = this.getInputScalar(INPUT_CONDITION, true).getValue();
        if (conditionString == null && this.maxIterationsCount == null) {
            throw new IllegalArgumentException("Both input condition and maximal iterations count are not specified: infinite loop!");
        }
        this.whileCondition = this.conditionStyle.toBoolean(conditionString, true);
        if (this.invertCondition) {
            this.whileCondition = !this.whileCondition;
        }
        this.getScalar(OUTPUT_COUNT).setTo(this.counter);
        this.getScalar(OUTPUT_COUNT_1).setTo(this.counter == Long.MAX_VALUE ? this.counter : this.counter + 1L);
        if (this.counter < Long.MAX_VALUE) {
            ++this.counter;
        }
        this.isLastIteration = !this.whileCondition || this.maxIterationsCount != null && this.counter >= this.maxIterationsCount;
        this.getScalar(OUTPUT_IS_FIRST).setTo(this.isFirstIteration);
        this.getScalar(OUTPUT_IS_LAST).setTo(this.isLastIteration);
        this.getScalar(OUTPUT_IS_NOT_FIRST).setTo(!this.isFirstIteration);
        this.getScalar(OUTPUT_IS_NOT_LAST).setTo(this.whileCondition);
        this.isFirstIteration = false;
    }

    @Override
    public boolean needToRepeat() {
        RepeatWhile.logDebug(() -> !this.isLastIteration ? "Repeating loop" : "FINISHING loop according " + (!this.whileCondition ? "input condition" : "maximal number of iterations"));
        return !this.isLastIteration;
    }
}

