/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.List;
import net.algart.arrays.ColorMatrices;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;

public enum ChannelsColorSpace {
    RGBA{

        @Override
        List<Matrix<? extends PArray>> split(List<Matrix<? extends PArray>> rgba) {
            return rgba;
        }

        @Override
        List<Matrix<? extends PArray>> merge(List<Matrix<? extends PArray>> channels) {
            return channels;
        }
    }
    ,
    HSV{

        @Override
        List<Matrix<? extends PArray>> split(List<Matrix<? extends PArray>> rgba) {
            Class resultType = rgba.get(0).type(PArray.class);
            return Matrices.several(PArray.class, (Matrix[])new Matrix[]{ColorMatrices.asHue((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2)), ColorMatrices.asHSVSaturation((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2)), ColorMatrices.asHSVValue((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2))});
        }

        @Override
        List<Matrix<? extends PArray>> merge(List<Matrix<? extends PArray>> channels) {
            return ColorMatrices.asRGBFromHSV((Class)channels.get(0).type(PArray.class), channels.get(0), channels.get(1), channels.get(2));
        }
    }
    ,
    HLS{

        @Override
        List<Matrix<? extends PArray>> split(List<Matrix<? extends PArray>> rgba) {
            Class resultType = rgba.get(0).type(PArray.class);
            return Matrices.several(PArray.class, (Matrix[])new Matrix[]{ColorMatrices.asHue((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2)), ColorMatrices.asHSLLightness((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2)), ColorMatrices.asHSLSaturation((Class)resultType, rgba.get(0), rgba.get(1), rgba.get(2))});
        }

        @Override
        List<Matrix<? extends PArray>> merge(List<Matrix<? extends PArray>> channels) {
            return ColorMatrices.asRGBFromHSL((Class)channels.get(0).type(PArray.class), channels.get(0), channels.get(2), channels.get(1));
        }
    };


    abstract List<Matrix<? extends PArray>> split(List<Matrix<? extends PArray>> var1);

    abstract List<Matrix<? extends PArray>> merge(List<Matrix<? extends PArray>> var1);
}

