/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.multimatrix.MultiMatrix;

public final class ExtractChannelsGroup
extends MultiMatrixFilter {
    private int indexOfFirstChannel = 0;
    private int numberOfExtractedChannels = 1;

    public int getIndexOfFirstChannel() {
        return this.indexOfFirstChannel;
    }

    public void setIndexOfFirstChannel(int indexOfFirstChannel) {
        this.indexOfFirstChannel = indexOfFirstChannel;
    }

    public int getNumberOfExtractedChannels() {
        return this.numberOfExtractedChannels;
    }

    public void setNumberOfExtractedChannels(int numberOfExtractedChannels) {
        this.numberOfExtractedChannels = ExtractChannelsGroup.nonNegative(numberOfExtractedChannels);
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        if (this.numberOfExtractedChannels == 0) {
            return source;
        }
        assert (this.numberOfExtractedChannels > 0);
        ExtractChannelsGroup.logDebug(() -> "Extracting channels " + this.indexOfFirstChannel + ".." + (this.indexOfFirstChannel + this.numberOfExtractedChannels - 1) + " from matrix " + String.valueOf(source));
        Matrix<? extends PArray> zeroConstant = source.constantMatrix(0.0);
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        List<Matrix<? extends PArray>> channels = source.allChannels();
        for (int k = 0; k < this.numberOfExtractedChannels; ++k) {
            int i = k + this.indexOfFirstChannel;
            result.add(i >= 0 && i < channels.size() ? channels.get(i) : zeroConstant);
        }
        return MultiMatrix.of(result);
    }
}

