/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.math.functions.Func;

public final class RawCastPrecision
extends MultiMatrixChannelFilter {
    private Class<?> elementType = Byte.TYPE;

    public Class<?> getElementType() {
        return this.elementType;
    }

    public RawCastPrecision setElementType(Class<?> elementType) {
        this.elementType = RawCastPrecision.nonNull(elementType, "element type");
        return this;
    }

    public RawCastPrecision setElementType(String elementType) {
        return this.setElementType(MultiMatrixGenerator.elementType(elementType));
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (this.elementType == m.elementType()) {
            return m;
        }
        if (this.currentChannel() == 0) {
            RawCastPrecision.logDebug(() -> "Cast precision " + m.elementType().getSimpleName() + " -> " + this.elementType.getSimpleName() + " for matrix " + this.numberOfChannels() + "x" + m.dimX() + "x" + m.dimY());
        }
        Class newType = Arrays.type(PArray.class, this.elementType);
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)Func.IDENTITY, (Class)newType, m));
    }
}

