/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.matrices.conversions.ColorSpaceConversion;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SplitColorChannels
extends ColorSpaceConversion {
    public static final String CHANNEL_1 = "channel_1";
    public static final String CHANNEL_2 = "channel_2";
    public static final String CHANNEL_3 = "channel_3";
    public static final String CHANNEL_4 = "channel_4";
    public static final String VISIBLE_RESULT_IS_FIRST_CONNECTED = "first_connected";
    public static final List<String> CHANNEL_PORTS = List.of("channel_1", "channel_2", "channel_3", "channel_4");

    public SplitColorChannels() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        for (String port : CHANNEL_PORTS) {
            this.addOutputMat(port);
        }
    }

    @Override
    public void process() {
        boolean somethingNecesary = false;
        for (String port : CHANNEL_PORTS) {
            somethingNecesary |= this.isOutputNecessary(port);
        }
        if (!somethingNecesary) {
            return;
        }
        SMat input = this.getInputMat();
        MultiMatrix2D source = input.toMultiMatrix2D();
        List rgba = source.allChannelsInRGBAOrder();
        if (rgba.size() == 1) {
            rgba = Matrices.several(PArray.class, (Matrix[])new Matrix[]{rgba.get(0), rgba.get(0), rgba.get(0)});
        }
        List<Matrix<? extends PArray>> channels = this.getChannelsColorSpace().split(rgba);
        int channelIndex = 0;
        for (String port : CHANNEL_PORTS) {
            if (channelIndex >= channels.size()) break;
            int finalIndex = channelIndex;
            if (this.isOutputNecessary(port)) {
                SMat outputPortMat = this.getMat(port);
                SplitColorChannels.logDebug(() -> "Extracting channel #" + (finalIndex + 1) + "/" + channels.size() + " -> monochrome matrix " + source.dimX() + "x" + source.dimY());
                outputPortMat.setTo(MultiMatrix.of2DMono(channels.get(channelIndex)).clone());
            } else {
                SplitColorChannels.logDebug(() -> "(extracting channel #" + (finalIndex + 1) + "/" + channels.size() + " skipped: it is not visible and not connected to any other processing)");
            }
            ++channelIndex;
        }
    }

    @Override
    public String visibleOutputPortName() {
        String visibleResult = super.visibleOutputPortName();
        if (VISIBLE_RESULT_IS_FIRST_CONNECTED.equals(visibleResult)) {
            for (String port : CHANNEL_PORTS) {
                Port outputPort = this.getOutputPort(port);
                if (outputPort == null || !outputPort.isConnected()) continue;
                return port;
            }
            return null;
        }
        return visibleResult;
    }
}

