/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.geometry;

import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannel2DFilter;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix2D;

public final class Resize
extends MultiMatrixChannel2DFilter {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    private double dimX = 0.0;
    private double dimY = 0.0;
    private boolean percents = false;
    private ResizingMode resizingMode = ResizingMode.AVERAGING_BILINEAR;
    private boolean convertBitToByte = false;
    private boolean requireInput = false;

    public Resize() {
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
    }

    public double getDimX() {
        return this.dimX;
    }

    public Resize setDimX(double dimX) {
        this.dimX = Resize.nonNegative(dimX);
        return this;
    }

    public double getDimY() {
        return this.dimY;
    }

    public Resize setDimY(double dimY) {
        this.dimY = Resize.nonNegative(dimY);
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public Resize setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public ResizingMode getResizingMode() {
        return this.resizingMode;
    }

    public Resize setResizingMode(ResizingMode resizingMode) {
        this.resizingMode = Resize.nonNull(resizingMode);
        return this;
    }

    public boolean isConvertBitToByte() {
        return this.convertBitToByte;
    }

    public Resize setConvertBitToByte(boolean convertBitToByte) {
        this.convertBitToByte = convertBitToByte;
        return this;
    }

    public boolean requireInput() {
        return this.requireInput;
    }

    public Resize setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public MultiMatrix2D process(MultiMatrix2D source) {
        if (source == null) {
            return null;
        }
        MultiMatrix2D result = super.process(source);
        this.getScalar(OUTPUT_DIM_X).setTo(result.dimX());
        this.getScalar(OUTPUT_DIM_Y).setTo(result.dimY());
        return result;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        long newDimX = m.dimX();
        long newDimY = m.dimY();
        if (this.dimX != 0.0 || this.dimY != 0.0) {
            if (this.dimX != 0.0) {
                long l = newDimX = this.percents ? (long)Math.round((float)(this.dimX / 100.0 * (double)m.dimX())) : (long)Math.round((float)this.dimX);
            }
            if (this.dimY != 0.0) {
                long l = newDimY = this.percents ? (long)Math.round((float)(this.dimY / 100.0 * (double)m.dimY())) : (long)Math.round((float)this.dimY);
            }
            if (this.dimX == 0.0) {
                newDimX = Math.round((float)newDimX * (float)newDimY / (float)m.dimY());
            }
            if (this.dimY == 0.0) {
                newDimY = Math.round((float)newDimY * (float)newDimX / (float)m.dimX());
            }
        }
        if (this.currentChannel() == 0 && LOGGABLE_DEBUG) {
            Resize.logDebug("Resizing to " + newDimX + "x" + newDimY + " of" + String.valueOf(m));
        }
        if (m.elementType() == Boolean.TYPE && this.convertBitToByte) {
            m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{255.0}), ByteArray.class, m);
        }
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, m.elementType(), new long[]{newDimX, newDimY});
        Matrices.resize(null, (Matrices.ResizingMethod)this.resizingMode.resizingMethod, (Matrix)result, (Matrix)m);
        return result;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return !this.requireInput;
    }

    @Override
    protected boolean resultRequired() {
        return this.requireInput;
    }

    public static enum ResizingMode {
        NEAREST(Matrices.ResizingMethod.SIMPLE),
        AVERAGING(Matrices.ResizingMethod.AVERAGING),
        BILINEAR(Matrices.ResizingMethod.POLYLINEAR_INTERPOLATION),
        AVERAGING_BILINEAR(Matrices.ResizingMethod.POLYLINEAR_AVERAGING),
        AVERAGING_MIN((Matrices.ResizingMethod)new Matrices.ResizingMethod.Averaging(Matrices.InterpolationMethod.STEP_FUNCTION){

            protected Func getAveragingFunc(long[] apertureDim) {
                return Func.MIN;
            }
        }),
        AVERAGING_MAX((Matrices.ResizingMethod)new Matrices.ResizingMethod.Averaging(Matrices.InterpolationMethod.STEP_FUNCTION){

            protected Func getAveragingFunc(long[] apertureDim) {
                return Func.MAX;
            }
        });

        final Matrices.ResizingMethod resizingMethod;

        private ResizingMode(Matrices.ResizingMethod resizingMethod) {
            this.resizingMethod = resizingMethod;
        }
    }
}

