/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.misc;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.executors.modules.core.matrices.misc.LimitInterpretation;
import net.algart.math.Range;
import net.algart.multimatrix.MultiMatrix;

public final class Contrast
extends MultiMatrixFilter {
    private double lowLimit = 0.0;
    private double highLimit = 1.0;
    private LimitInterpretation lowLimitInterpretation = LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX;
    private LimitInterpretation highLimitInterpretation = LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX;

    public double getLowLimit() {
        return this.lowLimit;
    }

    public Contrast setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
        return this;
    }

    public double getHighLimit() {
        return this.highLimit;
    }

    public Contrast setHighLimit(double highLimit) {
        this.highLimit = highLimit;
        return this;
    }

    public LimitInterpretation getLowLimitInterpretation() {
        return this.lowLimitInterpretation;
    }

    public Contrast setLowLimitInterpretation(LimitInterpretation lowLimitInterpretation) {
        this.lowLimitInterpretation = Contrast.nonNull(lowLimitInterpretation);
        return this;
    }

    public LimitInterpretation getHighLimitInterpretation() {
        return this.highLimitInterpretation;
    }

    public Contrast setHighLimitInterpretation(LimitInterpretation highLimitInterpretation) {
        this.highLimitInterpretation = highLimitInterpretation;
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        if (this.lowLimit < 0.0 || this.highLimit > 1.0 || this.lowLimit >= this.highLimit) {
            throw new IllegalArgumentException("Illegal low (" + this.lowLimit + ") or high (" + this.highLimit + ") limits: must be 0 <= low < high <= 1");
        }
        Matrix<? extends PArray> intensityChannel = source.intensityChannelOrNull();
        Range rangeToContrast = this.rangeToContrast(intensityChannel);
        Contrast.logDebug(() -> "Contrast of " + (this.lowLimitInterpretation == LimitInterpretation.PERCENTILE_BETWEEN_MIN_AND_MAX ? "percentile" : "value") + " " + this.lowLimit + ".." + this.highLimit + " for " + String.valueOf(this.sourceMultiMatrix()) + " (range to contrast " + String.valueOf(rangeToContrast) + ")");
        return source.contrast(rangeToContrast, true);
    }

    public Range rangeToContrast(Matrix<? extends PArray> intensity) {
        if (intensity == null) {
            return null;
        }
        Range range = this.lowLimitInterpretation.isUseRange() || this.highLimitInterpretation.isUseRange() ? Arrays.rangeOf((PArray)((PArray)intensity.array())) : null;
        double maxPossibleValue = ((PArray)intensity.array()).maxPossibleValue(1.0);
        long[] histogram = null;
        if (this.lowLimitInterpretation.isUseHistogram() || this.highLimitInterpretation.isUseHistogram()) {
            assert (range != null);
            histogram = new long[65536];
            double increasedSize = range.size() * ((double)histogram.length / ((double)histogram.length - 1.0));
            double increasedMax = range.min() + increasedSize;
            Arrays.histogramOf((PArray)((PArray)intensity.array()), (long[])histogram, (double)range.min(), (double)increasedMax);
        }
        return Range.valueOf((double)this.lowLimitInterpretation.translateLimit(this.lowLimit, range, maxPossibleValue, histogram), (double)this.highLimitInterpretation.translateLimit(this.highLimit, range, maxPossibleValue, histogram));
    }
}

