/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.misc;

import java.util.List;
import java.util.Map;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesToSeveralScalars;
import net.algart.executors.modules.core.matrices.arithmetic.MatrixDifference;
import net.algart.executors.modules.core.matrices.misc.MatrixInfo;
import net.algart.executors.modules.core.matrices.misc.SimpleImageStatistics;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixDifferenceInfo
extends SeveralMultiMatricesToSeveralScalars {
    private MatrixDifference.Operation differenceOperation = MatrixDifference.Operation.ABSOLUTE_DIFFERENCE;
    private boolean requireSameDimensions = true;
    private boolean rawValues = false;

    public MatrixDifferenceInfo() {
        super(new String[0]);
        this.useVisibleResultParameter();
        for (SimpleImageStatistics statistics : SimpleImageStatistics.values()) {
            this.addOutputNumbers(statistics.statisticsName());
        }
    }

    public MatrixDifference.Operation getDifferenceOperation() {
        return this.differenceOperation;
    }

    public void setDifferenceOperation(MatrixDifference.Operation differenceOperation) {
        this.differenceOperation = MatrixDifferenceInfo.nonNull(differenceOperation);
    }

    public boolean isRequireSameDimensions() {
        return this.requireSameDimensions;
    }

    public MatrixDifferenceInfo setRequireSameDimensions(boolean requireSameDimensions) {
        this.requireSameDimensions = requireSameDimensions;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public void setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
    }

    @Override
    public void analyse(Map<String, SScalar> results, List<MultiMatrix> sources) {
        MultiMatrix differenceMatrix;
        if (sources.get(0) == null || sources.get(1) == null) {
            differenceMatrix = null;
        } else if (!this.requireSameDimensions && !sources.get(0).dimEquals(sources.get(1))) {
            differenceMatrix = null;
        } else {
            try (MatrixDifference matrixDifference = new MatrixDifference();){
                differenceMatrix = matrixDifference.setOperation(this.differenceOperation).process(sources);
            }
        }
        try (MatrixInfo matrixInfo = new MatrixInfo();){
            matrixInfo.setRawValues(this.rawValues);
            matrixInfo.analyse(results, this.allOutputContainers(SNumbers.class, true), differenceMatrix);
        }
    }

    @Override
    protected Integer requiredNumberOfInputs() {
        return 2;
    }

    @Override
    protected boolean dimensionsEqualityRequired() {
        return this.requireSameDimensions;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }
}

