/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.misc;

import java.util.function.ToIntFunction;
import net.algart.additions.arrays.ArrayMinMaxFinder;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.Range;
import net.algart.multimatrix.MultiMatrix;

public enum SimpleImageStatistics {
    MEAN("mean", m -> 1),
    SUM("sum", m -> 1),
    MIN("min", m -> 1),
    MAX("max", m -> 1),
    MIN_POSITION("min_position", MultiMatrix::dimCount),
    MAX_POSITION("max_position", MultiMatrix::dimCount),
    RANGE("range", m -> 2),
    NONZERO_RANGE("non_zero_range", m -> 2),
    HASH("hash", m -> 1);

    private static final boolean DEBUG_MODE = false;
    private static final boolean LEGACY_MODE = false;
    private final String statisticsName;
    private final ToIntFunction<MultiMatrix> channelBlockLength;

    private SimpleImageStatistics(String statisticsName, ToIntFunction<MultiMatrix> channelBlockLength) {
        this.statisticsName = statisticsName;
        this.channelBlockLength = channelBlockLength;
    }

    public String statisticsName() {
        return this.statisticsName;
    }

    public boolean isLongResult() {
        return this == MIN_POSITION || this == MAX_POSITION || this == HASH;
    }

    public int channelBlockLength(MultiMatrix m) {
        return this.channelBlockLength.applyAsInt(m);
    }

    public double[] statistics(Matrix<? extends PArray> m, boolean rawValues) {
        double[] dArray;
        double scale = rawValues ? 1.0 : ((PArray)m.array()).maxPossibleValue(1.0);
        switch (this.ordinal()) {
            case 0: {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = Arrays.sumOf((PArray)((PArray)m.array())) / ((double)m.size() * scale);
                break;
            }
            case 1: {
                double[] dArray3 = new double[1];
                dArray = dArray3;
                dArray3[0] = Arrays.sumOf((PArray)((PArray)m.array())) / scale;
                break;
            }
            case 2: {
                double[] dArray4 = new double[1];
                dArray = dArray4;
                dArray4[0] = SimpleImageStatistics.findMin((PArray)m.array()) / scale;
                break;
            }
            case 3: {
                double[] dArray5 = new double[1];
                dArray = dArray5;
                dArray5[0] = SimpleImageStatistics.findMax((PArray)m.array()) / scale;
                break;
            }
            case 6: {
                double[] range = SimpleImageStatistics.findRange((PArray)m.array());
                double[] dArray6 = new double[2];
                dArray6[0] = range[0] / scale;
                dArray = dArray6;
                dArray6[1] = range[1] / scale;
                break;
            }
            case 7: {
                Range range = MultiMatrix.nonZeroRangeOf(null, (PArray)m.array());
                if (range != null) {
                    double[] dArray7 = new double[2];
                    dArray7[0] = range.min() / scale;
                    dArray = dArray7;
                    dArray7[1] = range.max() / scale;
                    break;
                }
                double[] dArray8 = new double[2];
                dArray8[0] = Double.NaN;
                dArray = dArray8;
                dArray8[1] = Double.NaN;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown double statistics " + String.valueOf((Object)this));
            }
        }
        return dArray;
    }

    public long[] longStatistics(Matrix<? extends PArray> m) {
        long[] lArray;
        switch (this.ordinal()) {
            case 4: {
                lArray = SimpleImageStatistics.findPositionOfMin(m);
                break;
            }
            case 5: {
                lArray = SimpleImageStatistics.findPositionOfMax(m);
                break;
            }
            case 8: {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = m.hashCode();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown long statistics " + String.valueOf((Object)this));
            }
        }
        return lArray;
    }

    public Object allChannelsStatistics(MultiMatrix multiMatrix, boolean rawValues) {
        if (this.isLongResult()) {
            if (multiMatrix == null) {
                return new long[0];
            }
            long[] result = new long[multiMatrix.numberOfChannels() * this.channelBlockLength(multiMatrix)];
            int disp = 0;
            for (Matrix<? extends PArray> m : multiMatrix.allChannels()) {
                for (long v : this.longStatistics(m)) {
                    result[disp++] = v;
                }
            }
            return result;
        }
        if (multiMatrix == null) {
            return new double[0];
        }
        double[] result = new double[multiMatrix.numberOfChannels() * this.channelBlockLength(multiMatrix)];
        int disp = 0;
        for (Matrix<? extends PArray> m : multiMatrix.allChannels()) {
            for (double v : this.statistics(m, rawValues)) {
                result[disp++] = v;
            }
        }
        return result;
    }

    private static double findMin(PArray array) {
        ArrayMinMaxFinder.Min finder = ArrayMinMaxFinder.newInstance(true).getMinFinder();
        double min = finder.find(array).min();
        return min;
    }

    private static double findMax(PArray array) {
        ArrayMinMaxFinder.Max finder = ArrayMinMaxFinder.newInstance(true).getMaxFinder();
        double max = finder.find(array).max();
        return max;
    }

    private static long[] findPositionOfMin(Matrix<? extends PArray> m) {
        Arrays.MinMaxInfo minMaxInfo = new Arrays.MinMaxInfo();
        ArrayMinMaxFinder.Min finder = ArrayMinMaxFinder.newInstance(true).getMinFinder();
        finder.find((PArray)m.array());
        return finder.isMinFound() ? m.coordinates(finder.indexOfMin(), null) : new long[]{};
    }

    private static long[] findPositionOfMax(Matrix<? extends PArray> m) {
        Arrays.MinMaxInfo minMaxInfo = new Arrays.MinMaxInfo();
        ArrayMinMaxFinder.Max finder = ArrayMinMaxFinder.newInstance(true).getMaxFinder();
        finder.find((PArray)m.array());
        return finder.isMaxFound() ? m.coordinates(finder.indexOfMax(), null) : new long[]{};
    }

    private static double[] findRange(PArray array) {
        ArrayMinMaxFinder.MinMax finder = ArrayMinMaxFinder.newInstance(true).getMinMaxFinder();
        finder.find(array);
        double min = finder.min();
        double max = finder.max();
        return new double[]{min, max};
    }
}

