/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public final class NumbersEquality
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private Class<?> elementType = Float.TYPE;
    private double trueValue = 1.0;
    private double falseValue = 0.0;
    private boolean invert = false;

    public NumbersEquality() {
        super(INPUT_X, INPUT_Y);
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public NumbersEquality setElementType(Class<?> elementType) {
        this.elementType = NumbersEquality.nonNull(elementType, "element type");
        return this;
    }

    public NumbersEquality setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public double getTrueValue() {
        return this.trueValue;
    }

    public NumbersEquality setTrueValue(double trueValue) {
        this.trueValue = trueValue;
        return this;
    }

    public double getFalseValue() {
        return this.falseValue;
    }

    public NumbersEquality setFalseValue(double falseValue) {
        this.falseValue = falseValue;
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public NumbersEquality setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        SNumbers x = sources.get(0);
        SNumbers y = sources.get(1);
        if (x.elementType() != Long.TYPE || y.elementType() != Long.TYPE) {
            return super.processNumbers(sources);
        }
        assert (x.getBlockLength() == y.getBlockLength()) : "must be checked by superclass";
        assert (x.getArrayLength() == y.getArrayLength()) : "must be checked by superclass";
        long[] xLongs = (long[])x.getArray();
        long[] yLongs = (long[])y.getArray();
        SNumbers result = SNumbers.zeros(this.elementType, x.n(), x.getBlockLength());
        double equalValue = this.invert ? this.falseValue : this.trueValue;
        double nonEqualValue = this.invert ? this.trueValue : this.falseValue;
        for (int k = 0; k < xLongs.length; ++k) {
            result.setValue(k, xLongs[k] == yLongs[k] ? equalValue : nonEqualValue);
        }
        return result;
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        PNumberArray x = sources.get(0);
        PNumberArray y = sources.get(1);
        final double equalValue = this.invert ? this.falseValue : this.trueValue;
        final double nonEqualValue = this.invert ? this.trueValue : this.falseValue;
        return Arrays.asFuncArray((Func)new AbstractFunc(this){

            public double get(double ... x) {
                return this.get(x[0], x[1]);
            }

            public double get(double x0, double x1) {
                return x0 == x1 ? equalValue : nonEqualValue;
            }
        }, (Class)Arrays.type(PNumberArray.class, this.elementType), (PArray[])new PArray[]{x, y});
    }
}

