/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class ExtractNumbers
extends Executor
implements ReadOnlyExecutionInput {
    private int blockIndex = 0;
    private int numberOfBlocks = 1;

    public ExtractNumbers() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public ExtractNumbers setBlockIndex(int blockIndex) {
        this.blockIndex = ExtractNumbers.nonNegative(blockIndex);
        return this;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public ExtractNumbers setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = ExtractNumbers.nonNegative(numberOfBlocks);
        return this;
    }

    @Override
    public void process() {
        SNumbers source = this.getInputNumbers();
        int n = source.n();
        int blockIndex = Math.min(this.blockIndex, n);
        int numberOfBlocks = this.numberOfBlocks != 0 ? Math.min(this.numberOfBlocks, n - blockIndex) : n - blockIndex;
        long t1 = ExtractNumbers.debugTime();
        this.getNumbers().setTo(source.blockRange(blockIndex, numberOfBlocks));
        long t2 = ExtractNumbers.debugTime();
        ExtractNumbers.logDebug(() -> String.format(Locale.US, "Extracting block%s #%d%s of number array %s: %.3f ms", numberOfBlocks == 1 ? "" : "s", blockIndex, numberOfBlocks == 1 ? "" : ".." + (blockIndex + numberOfBlocks - 1), source, (double)(t2 - t1) * 1.0E-6));
    }
}

