/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.math.functions.Func;
import net.algart.math.functions.RectangularFunc;

public final class ExtractNumbersInRange
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_SELECTOR = "selector";
    private int checkedIndexInSelectorBlocks = 0;
    private double min = 0.0;
    private double max = Double.POSITIVE_INFINITY;
    private boolean invert = false;

    public ExtractNumbersInRange() {
        this.addInputNumbers(INPUT_SELECTOR);
    }

    public int getCheckedIndexInSelectorBlocks() {
        return this.checkedIndexInSelectorBlocks;
    }

    public ExtractNumbersInRange setCheckedIndexInSelectorBlocks(int checkedIndexInSelectorBlocks) {
        this.checkedIndexInSelectorBlocks = checkedIndexInSelectorBlocks;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public ExtractNumbersInRange setMin(double min) {
        this.min = min;
        return this;
    }

    public ExtractNumbersInRange setMin(String min) {
        this.min = ExtractNumbersInRange.doubleOrNegativeInfinity(min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public ExtractNumbersInRange setMax(double max) {
        this.max = max;
        return this;
    }

    public ExtractNumbersInRange setMax(String max) {
        this.max = ExtractNumbersInRange.doubleOrPositiveInfinity(max);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public ExtractNumbersInRange setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers source) {
        SNumbers selector = this.getInputNumbers(INPUT_SELECTOR, true);
        if (!selector.isInitialized()) {
            selector = source;
        }
        return this.processNumbers(source, selector);
    }

    public SNumbers processNumbers(SNumbers source, SNumbers selector) {
        double inValue = this.invert ? 0.0 : 1.0;
        double outValue = this.invert ? 1.0 : 0.0;
        SNumbers column = selector.column(this.checkedIndexInSelectorBlocks);
        BitArray bits = this.min > this.max ? Arrays.nBitCopies((long)column.n(), (boolean)false) : (BitArray)Arrays.asFuncArray((Func)RectangularFunc.getInstance((double)this.min, (double)this.max, (double)inValue, (double)outValue), BitArray.class, (PArray[])new PArray[]{(PArray)SimpleMemoryModel.asUpdatableArray((Object)column.getArray())});
        return source.selectBlockSet(bits);
    }
}

