/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.numbers.conversions.CastNumbers;
import net.algart.json.Jsons;

public final class JsonToIndexValueTable
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_JSON_TABLE = "json_table";
    public static final String INPUT_JSON_NAMED_INDEXES = "json_named_indexes";
    public static final String INPUT_JSON_NAMED_VALUES = "json_named_values";
    public static final String OUTPUT_TABLE = "table";
    public static final int MAX_ALLOWED_INDEX = 0x1000000;
    private Class<?> valueElementType = Integer.TYPE;
    private int minimalTableLength = 0;
    private String tableFiller = "0.0";
    private IndexingBase indexingBase = IndexingBase.ZERO_BASED;
    private boolean allowTooLowIndexes = false;

    public JsonToIndexValueTable() {
        this.setDefaultInputScalar(INPUT_JSON_TABLE);
        this.addInputScalar(INPUT_JSON_NAMED_INDEXES);
        this.addInputScalar(INPUT_JSON_NAMED_VALUES);
        this.setDefaultOutputNumbers(OUTPUT_TABLE);
    }

    public Class<?> getValueElementType() {
        return this.valueElementType;
    }

    public JsonToIndexValueTable setValueElementType(Class<?> valueElementType) {
        this.valueElementType = JsonToIndexValueTable.nonNull(valueElementType, "element type");
        return this;
    }

    public JsonToIndexValueTable setElementType(String elementType) {
        this.setValueElementType(SNumbers.elementType(elementType));
        return this;
    }

    public int getMinimalTableLength() {
        return this.minimalTableLength;
    }

    public JsonToIndexValueTable setMinimalTableLength(int minimalTableLength) {
        this.minimalTableLength = JsonToIndexValueTable.nonNegative(minimalTableLength);
        return this;
    }

    public String getTableFiller() {
        return this.tableFiller;
    }

    public JsonToIndexValueTable setTableFiller(String tableFiller) {
        this.tableFiller = JsonToIndexValueTable.nonEmpty(tableFiller);
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public JsonToIndexValueTable setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = JsonToIndexValueTable.nonNull(indexingBase);
        return this;
    }

    public boolean isAllowTooLowIndexes() {
        return this.allowTooLowIndexes;
    }

    public JsonToIndexValueTable setAllowTooLowIndexes(boolean allowTooLowIndexes) {
        this.allowTooLowIndexes = allowTooLowIndexes;
        return this;
    }

    @Override
    public void process() {
        double[] resultTable;
        JsonObject jsonTable = Jsons.toJson(this.getInputScalar(INPUT_JSON_TABLE).getValue().trim());
        JsonObject jsonIndexNames = Jsons.toJson(this.getInputScalar(INPUT_JSON_NAMED_INDEXES, true).getValue(), true);
        JsonObject jsonValueNames = Jsons.toJson(this.getInputScalar(INPUT_JSON_NAMED_VALUES, true).getValue(), true);
        int maxLength = Math.max(this.minimalTableLength, JsonToIndexValueTable.findTableLength(jsonTable, jsonIndexNames, this.indexingBase.start, INPUT_JSON_NAMED_INDEXES, this.allowTooLowIndexes));
        Object[] objectArray = resultTable = this.valueElementType == Double.TYPE || this.valueElementType == Float.TYPE ? new double[maxLength] : (Object[])new long[maxLength];
        if (resultTable instanceof double[]) {
            Arrays.fill(resultTable, this.tableFiller(jsonValueNames));
        } else {
            Arrays.fill((long[])resultTable, (long)this.tableFiller(jsonValueNames));
        }
        block9: for (Map.Entry entry : jsonTable.entrySet()) {
            int index = JsonToIndexValueTable.toIndex(jsonIndexNames, (String)entry.getKey(), INPUT_JSON_NAMED_INDEXES);
            int k = index - this.indexingBase.start;
            if (k < 0) continue;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            switch (jsonValue.getValueType()) {
                case NUMBER: {
                    if (resultTable instanceof double[]) {
                        resultTable[k] = ((JsonNumber)jsonValue).doubleValue();
                        continue block9;
                    }
                    ((long[])resultTable)[k] = ((JsonNumber)jsonValue).longValueExact();
                    continue block9;
                }
                case STRING: {
                    String name = ((JsonString)jsonValue).getString();
                    if (resultTable instanceof double[]) {
                        resultTable[k] = JsonToIndexValueTable.toDoubleValue(jsonValueNames, name, INPUT_JSON_NAMED_VALUES);
                        continue block9;
                    }
                    ((long[])resultTable)[k] = JsonToIndexValueTable.toLongValue(jsonValueNames, name, INPUT_JSON_NAMED_VALUES);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Table must contain integer or string values, but for key \"" + (String)entry.getKey() + "\" it contains \"" + String.valueOf(jsonValue) + "\"");
        }
        try (CastNumbers castNumbers = new CastNumbers();){
            this.getNumbers(OUTPUT_TABLE).setToArray(castNumbers.setElementType(this.valueElementType).processUnstructuredJavaArray(resultTable), 1);
        }
    }

    static int findTableLength(JsonObject jsonTable, JsonObject jsonIndexNames, int indexingBase, String nameOfJsonIndexNames, boolean allowTooLowIndexes) {
        int maxLength = 0;
        for (String key : jsonTable.keySet()) {
            int index = JsonToIndexValueTable.toIndex(jsonIndexNames, key, nameOfJsonIndexNames);
            if (index < indexingBase && !allowTooLowIndexes) {
                throw new IllegalArgumentException("Too small index " + index + ", corresponding to key \"" + key + "\", is not allowed: all indexes must be >=" + indexingBase + " (indexing base)");
            }
            if (index > 0x1000000 + indexingBase) {
                throw new IllegalArgumentException("Too large index " + index + ", corresponding to key \"" + key + "\": indexes must be <=" + (0x1000000 + indexingBase));
            }
            maxLength = Math.max(index - indexingBase + 1, maxLength);
        }
        return maxLength;
    }

    static int toIndex(JsonObject namesToNumber, String name, String namesJsonName) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            return JsonToIndexValueTable.toNumber(namesToNumber, name, namesJsonName).intValueExact();
        }
    }

    private double tableFiller(JsonObject namesToNumber) {
        try {
            return Double.parseDouble(this.tableFiller);
        }
        catch (NumberFormatException numberFormatException) {
            return JsonToIndexValueTable.toNumber(namesToNumber, this.tableFiller, INPUT_JSON_NAMED_VALUES).doubleValue();
        }
    }

    private static double toDoubleValue(JsonObject namesToNumber, String name, String namesJsonName) {
        JsonNumber value = JsonToIndexValueTable.toNumberOrNull(namesToNumber, name, namesJsonName);
        if (value == null) {
            try {
                return Double.parseDouble(name);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException("There is a symbolic name \"" + name + "\", but JSON names map \"" + namesJsonName + "\" " + (namesToNumber.isEmpty() ? "is empty" : "does not contain this name"));
            }
        }
        return value.doubleValue();
    }

    private static long toLongValue(JsonObject namesToNumber, String name, String namesJsonName) {
        JsonNumber value = JsonToIndexValueTable.toNumberOrNull(namesToNumber, name, namesJsonName);
        if (value == null) {
            try {
                return Long.parseLong(name);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException("There is a symbolic name \"" + name + "\", but JSON names map \"" + namesJsonName + "\" " + (namesToNumber.isEmpty() ? "is empty" : "does not contain this name"));
            }
        }
        return value.longValueExact();
    }

    private static JsonNumber toNumber(JsonObject namesToNumber, String name, String namesJsonName) {
        JsonNumber value = JsonToIndexValueTable.toNumberOrNull(namesToNumber, name, namesJsonName);
        if (value == null) {
            throw new IllegalArgumentException("There is a symbolic name \"" + name + "\", but JSON names map \"" + namesJsonName + "\" " + (namesToNumber.isEmpty() ? "is empty" : "does not contain this name"));
        }
        return value;
    }

    private static JsonNumber toNumberOrNull(JsonObject namesToNumber, String name, String namesJsonName) {
        JsonValue value;
        Objects.requireNonNull(namesToNumber);
        JsonValue jsonValue = value = namesToNumber.isEmpty() ? null : (JsonValue)namesToNumber.get((Object)name);
        if (value != null && !(value instanceof JsonNumber)) {
            throw new IllegalArgumentException("Invalid JSON names map \"" + namesJsonName + "\": it must contain numeric values, but it contains not a number \"" + String.valueOf(value) + "\" for key \"" + name + "\"");
        }
        return (JsonNumber)value;
    }
}

