/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableLongArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.numbers.conversions.CastNumbers;
import net.algart.json.Jsons;

public final class JsonToNumbers
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_JSON = "json";
    public static final String INPUT_KEY_TO_FLAG_TABLE_JSON = "key_to_flag_table_json";
    public static final String INPUT_FLAGS_JSON = "flags_json";
    public static final String OUTPUT_KEYS = "keys";
    public static final String OUTPUT_JSON = "json";
    private int blockLength = 1;
    private boolean singleBlock = true;
    private Class<?> elementType = Double.TYPE;
    private int indexOfFirstElement = 0;
    private Integer numberOfElements = null;
    private ExtractedTypes extractedTypes = ExtractedTypes.ALL;
    private SelectionMode extractingMode = SelectionMode.ALL;

    public JsonToNumbers() {
        this.setDefaultInputScalar("json");
        this.addInputScalar(INPUT_KEY_TO_FLAG_TABLE_JSON);
        this.addInputScalar(INPUT_FLAGS_JSON);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_KEYS);
        this.addOutputScalar("json");
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public JsonToNumbers setBlockLength(int blockLength) {
        this.blockLength = JsonToNumbers.positive(blockLength);
        return this;
    }

    public boolean isSingleBlock() {
        return this.singleBlock;
    }

    public JsonToNumbers setSingleBlock(boolean singleBlock) {
        this.singleBlock = singleBlock;
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public JsonToNumbers setElementType(Class<?> elementType) {
        this.elementType = JsonToNumbers.nonNull(elementType, "element type");
        return this;
    }

    public JsonToNumbers setElementType(String elementType) {
        this.setElementType(SNumbers.elementType(elementType));
        return this;
    }

    public int getIndexOfFirstElement() {
        return this.indexOfFirstElement;
    }

    public JsonToNumbers setIndexOfFirstElement(int indexOfFirstElement) {
        this.indexOfFirstElement = JsonToNumbers.nonNegative(indexOfFirstElement);
        return this;
    }

    public Integer getNumberOfElements() {
        return this.numberOfElements;
    }

    public JsonToNumbers setNumberOfElements(Integer numberOfElements) {
        if (numberOfElements != null) {
            JsonToNumbers.nonNegative(numberOfElements);
        }
        this.numberOfElements = numberOfElements;
        return this;
    }

    public ExtractedTypes getExtractedTypes() {
        return this.extractedTypes;
    }

    public JsonToNumbers setExtractedTypes(ExtractedTypes extractedTypes) {
        this.extractedTypes = JsonToNumbers.nonNull(extractedTypes);
        return this;
    }

    public SelectionMode getExtractingMode() {
        return this.extractingMode;
    }

    public JsonToNumbers setExtractingMode(SelectionMode extractingMode) {
        this.extractingMode = JsonToNumbers.nonNull(extractingMode);
        return this;
    }

    @Override
    public void process() {
        JsonObject json = Jsons.toJson(this.getInputScalar("json").getValue().trim());
        JsonObject keyToFlagTableJson = null;
        JsonObject flagsJson = null;
        if (this.extractingMode != SelectionMode.ALL) {
            keyToFlagTableJson = Jsons.toJson(this.getInputScalar(INPUT_KEY_TO_FLAG_TABLE_JSON).getValue().trim());
            flagsJson = Jsons.toJson(this.getInputScalar(INPUT_FLAGS_JSON).getValue().trim());
        }
        MutableDoubleArray values = this.elementType == Double.TYPE || this.elementType == Float.TYPE ? MutableDoubleArray.newArray() : MutableLongArray.newArray();
        ArrayList<String> keys = new ArrayList<String>();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        int index = 0;
        int count = this.numberOfElements == null ? -157 : this.numberOfElements;
        block11: for (Map.Entry entry : json.entrySet()) {
            if (index++ < this.indexOfFirstElement) continue;
            if (this.numberOfElements != null && count-- == 0) break;
            String key = (String)entry.getKey();
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (!this.extractedTypes.accept(jsonValue) || !this.extractingMode.accept(key, keyToFlagTableJson, flagsJson)) continue;
            keys.add(key);
            builder.add(key, (JsonValue)entry.getValue());
            switch (jsonValue.getValueType()) {
                case FALSE: {
                    if (values instanceof MutableDoubleArray) {
                        values.pushDouble(0.0);
                        continue block11;
                    }
                    ((MutableLongArray)values).pushLong(0L);
                    continue block11;
                }
                case TRUE: {
                    if (values instanceof MutableDoubleArray) {
                        values.pushDouble(1.0);
                        continue block11;
                    }
                    ((MutableLongArray)values).pushLong(1L);
                    continue block11;
                }
                case NUMBER: {
                    JsonNumber number = (JsonNumber)jsonValue;
                    if (values instanceof MutableDoubleArray) {
                        values.pushDouble(number.doubleValue());
                        continue block11;
                    }
                    ((MutableLongArray)values).pushLong(number.longValue());
                    continue block11;
                }
                case STRING: {
                    String s = ((JsonString)jsonValue).getString();
                    if (values instanceof MutableDoubleArray) {
                        values.pushDouble(JsonToNumbers.smartParseDouble(s));
                        continue block11;
                    }
                    ((MutableLongArray)values).pushLong(JsonToNumbers.smartParseLong(s));
                    continue block11;
                }
            }
            if (values instanceof MutableDoubleArray) {
                values.pushDouble(Double.NaN);
                continue;
            }
            ((MutableLongArray)values).pushLong(0L);
        }
        this.getScalar(OUTPUT_KEYS).setTo(String.join((CharSequence)"\n", keys));
        this.getScalar("json").setTo(Jsons.toPrettyString(builder.build()));
        try (CastNumbers castNumbers = new CastNumbers();){
            this.getNumbers().setToArray(castNumbers.setElementType(this.elementType).processUnstructuredJavaArray(values.toJavaArray()), this.singleBlock ? (int)values.length() : this.blockLength);
        }
    }

    private static long smartParseLong(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static double smartParseDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static Double smartExtractDouble(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
            case STRING: {
                String s = ((JsonString)jsonValue).getString();
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static enum ExtractedTypes {
        ALL(jsonValue -> true),
        NUMBERS(jsonValue -> jsonValue.getValueType() == JsonValue.ValueType.NUMBER),
        NON_ZERO_NUMBERS(jsonValue -> jsonValue.getValueType() == JsonValue.ValueType.NUMBER && ((JsonNumber)jsonValue).doubleValue() != 0.0),
        NUMBERS_AND_NUMERIC_STRINGS(jsonValue -> JsonToNumbers.smartExtractDouble(jsonValue) != null),
        NON_ZERO_NUMBERS_AND_NUMERIC_STRINGS(jsonValue -> {
            Double v = JsonToNumbers.smartExtractDouble(jsonValue);
            return v != null && v != 0.0;
        }),
        BOOLEANS(jsonValue -> {
            JsonValue.ValueType valueType = jsonValue.getValueType();
            return valueType == JsonValue.ValueType.FALSE || valueType == JsonValue.ValueType.TRUE;
        }),
        TRUE_BOOLEANS(jsonValue -> jsonValue.getValueType() == JsonValue.ValueType.TRUE);

        private final Predicate<JsonValue> doAccept;

        private ExtractedTypes(Predicate<JsonValue> doAccept) {
            this.doAccept = doAccept;
        }

        public final boolean accept(JsonValue jsonValue) {
            return this.doAccept.test(jsonValue);
        }
    }

    public static enum SelectionMode {
        ALL{

            @Override
            public boolean accept(String key, JsonObject keyToFlagTableJson, JsonObject flagsJson) {
                return true;
            }
        }
        ,
        SELECTED_ONLY{

            @Override
            public boolean accept(String key, JsonObject keyToFlagTableJson, JsonObject flagsJson) {
                String flagName = keyToFlagTableJson.getString(key, null);
                if (flagName == null) {
                    throw new JsonException("Key-to-flag table does not contain flag name (string value) for the key \"" + key + "\"");
                }
                return flagsJson.getBoolean(flagName, false);
            }
        };


        public abstract boolean accept(String var1, JsonObject var2, JsonObject var3);
    }
}

