/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;

public final class MergeNumbers
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    private boolean requireInput = true;
    private ResultElementType resultElementType = ResultElementType.FIRST_INPUT;

    public MergeNumbers() {
        super(new String[0]);
    }

    public boolean requireInput() {
        return this.requireInput;
    }

    public MergeNumbers setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    public ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public MergeNumbers setResultElementType(ResultElementType resultElementType) {
        this.resultElementType = MergeNumbers.nonNull(resultElementType);
        return this;
    }

    @Override
    public SNumbers processNumbers(List<SNumbers> sources) {
        if (sources.stream().noneMatch(Objects::nonNull)) {
            if (this.requireInput) {
                throw new IllegalArgumentException("No non-null input arrays");
            }
            return new SNumbers();
        }
        Class<?> resultElementType = MergeNumbers.findElementType(sources, this.resultElementType);
        assert (resultElementType != null) : "must not be null if there are non-null sources: " + String.valueOf(sources);
        int blockLength = sources.stream().filter(Objects::nonNull).findFirst().map(SNumbers::getBlockLength).orElse(1);
        long n = sources.stream().filter(Objects::nonNull).mapToLong(SNumbers::n).sum();
        if (n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large summary number of blocks: " + n + " >=2^31");
        }
        SNumbers result = SNumbers.zeros(resultElementType, (int)n, blockLength);
        int disp = 0;
        for (SNumbers source : sources) {
            if (source == null) continue;
            if (source.elementType() != resultElementType) {
                source = source.toPrecision(resultElementType);
            }
            int numberOfBlocks = source.n();
            result.replaceBlockRange(disp, source, 0, numberOfBlocks);
            disp += numberOfBlocks;
        }
        return result;
    }

    @Override
    protected boolean allowAllUninitializedInputs() {
        return !this.requireInput;
    }

    @Override
    protected boolean numberOfBlocksEqualityRequired() {
        return false;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return true;
    }

    static Class<?> findElementType(List<SNumbers> sources, ResultElementType resultElementType) {
        switch (resultElementType.ordinal()) {
            case 0: {
                Class<?> result = null;
                for (SNumbers source : sources) {
                    if (source == null) continue;
                    if (result == null) {
                        result = source.elementType();
                        continue;
                    }
                    if (result == source.elementType()) continue;
                    throw new IllegalArgumentException("Different element type of source arrays: " + String.valueOf(result) + "[] and " + String.valueOf(source.elementType()) + "[]");
                }
                return result;
            }
            case 1: {
                for (SNumbers source : sources) {
                    if (source == null) continue;
                    return source.elementType();
                }
                return null;
            }
        }
        assert (resultElementType.elementType != null);
        return resultElementType.elementType;
    }

    public static enum ResultElementType {
        REQUIRE_IDENTICAL(null),
        FIRST_INPUT(null),
        INT(Integer.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE);

        final Class<?> elementType;

        private ResultElementType(Class<?> elementType) {
            this.elementType = elementType;
        }
    }
}

