/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.functions.Func;
import net.algart.math.functions.Func1;

public final class CreateArithmeticProgression
extends Executor
implements ReadOnlyExecutionInput {
    private int blockLength = 1;
    private int numberOfBlocks = 100;
    private Class<?> elementType = Float.TYPE;
    private double startValue = 0.0;
    private double increment = 0.0;

    public CreateArithmeticProgression() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public CreateArithmeticProgression setBlockLength(int blockLength) {
        this.blockLength = CreateArithmeticProgression.positive(blockLength);
        return this;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public CreateArithmeticProgression setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = CreateArithmeticProgression.nonNegative(numberOfBlocks);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public CreateArithmeticProgression setElementType(Class<?> elementType) {
        this.elementType = CreateArithmeticProgression.nonNull(elementType);
        return this;
    }

    public CreateArithmeticProgression setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public double getStartValue() {
        return this.startValue;
    }

    public CreateArithmeticProgression setStartValue(double startValue) {
        this.startValue = startValue;
        return this;
    }

    public double getIncrement() {
        return this.increment;
    }

    public CreateArithmeticProgression setIncrement(double increment) {
        this.increment = increment;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            CreateArithmeticProgression.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            Object result = Arrays.asIndexFuncArray((Func)((Func1)x0 -> {
                int blockIndex = (int)x0 / this.blockLength;
                return this.startValue + (double)blockIndex * this.increment;
            }), (Class)Arrays.type(PArray.class, this.elementType), (long)((long)this.blockLength * (long)this.numberOfBlocks)).toJavaArray();
            this.setEndProcessingTimeStamp();
            this.getNumbers().setToArray(result, this.blockLength);
        }
    }
}

