/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import java.util.HashMap;
import java.util.Map;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class CreateNumbersFromValues
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_PORT_PREFIX = "v";
    private int blockLength = 1;
    private boolean singleBlock = false;
    private int numberOfBlocks = 100;
    private Class<?> elementType = Double.TYPE;
    private final Map<Integer, Double> values = new HashMap<Integer, Double>();

    public CreateNumbersFromValues() {
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public CreateNumbersFromValues setBlockLength(int blockLength) {
        this.blockLength = CreateNumbersFromValues.positive(blockLength);
        return this;
    }

    public boolean isSingleBlock() {
        return this.singleBlock;
    }

    public CreateNumbersFromValues setSingleBlock(boolean singleBlock) {
        this.singleBlock = singleBlock;
        return this;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public CreateNumbersFromValues setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = CreateNumbersFromValues.nonNegative(numberOfBlocks);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public CreateNumbersFromValues setElementType(Class<?> elementType) {
        this.elementType = CreateNumbersFromValues.nonNull(elementType, "element type");
        return this;
    }

    public CreateNumbersFromValues setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public double getValue(int index) {
        return this.values.getOrDefault(index, 0.0);
    }

    public CreateNumbersFromValues setValue(int index, double value) {
        this.values.put(index, value);
        return this;
    }

    @Override
    public void onChangeParameter(String name) {
        if (name.startsWith(INPUT_PORT_PREFIX)) {
            int index;
            try {
                index = Integer.parseInt(name.substring(INPUT_PORT_PREFIX.length()));
            }
            catch (NumberFormatException ignored) {
                return;
            }
            this.setValue(index, this.parameters().getDouble(name));
            return;
        }
        super.onChangeParameter(name);
    }

    @Override
    public void process() {
        if ((long)this.blockLength * (long)this.numberOfBlocks > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("numberOfBlocks * blockLength = " + this.numberOfBlocks + " * " + this.blockLength + " >= 2^31");
        }
        int length = this.blockLength * this.numberOfBlocks;
        double[] values = new double[length];
        for (int k = 0; k < values.length; ++k) {
            values[k] = this.getValue(k);
        }
        this.getNumbers().setToArray(values, this.singleBlock ? values.length : this.blockLength).setPrecision(this.elementType);
    }
}

