/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.Arrays;
import java.util.List;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.executors.modules.core.numbers.misc.ValuesDistanceMetric;

public final class NearestClusterCenters
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_VALUES = "values";
    public static final String INPUT_CENTERS = "centers";
    public static final String OUTPUT_INDEXES = "indexes";
    public static final String OUTPUT_DISTANCES = "distances";
    private ValuesDistanceMetric distanceMetric = ValuesDistanceMetric.NORMALIZED_EUCLIDEAN;
    private double[] valuesWeights = new double[0];
    private double maxDistance = Double.POSITIVE_INFINITY;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public NearestClusterCenters() {
        super(INPUT_VALUES, INPUT_CENTERS);
        this.setDefaultOutputNumbers(OUTPUT_INDEXES);
        this.addOutputNumbers(OUTPUT_DISTANCES);
    }

    public ValuesDistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    public NearestClusterCenters setDistanceMetric(ValuesDistanceMetric distanceMetric) {
        this.distanceMetric = NearestClusterCenters.nonNull(distanceMetric);
        if (!distanceMetric.isSingleNumber()) {
            throw new IllegalArgumentException("Illegal " + String.valueOf((Object)distanceMetric) + ": distance metric must be single-number");
        }
        return this;
    }

    public double[] getValuesWeights() {
        return (double[])this.valuesWeights.clone();
    }

    public NearestClusterCenters setValuesWeights(double[] valuesWeights) {
        this.valuesWeights = (double[])NearestClusterCenters.nonNull(valuesWeights).clone();
        return this;
    }

    public NearestClusterCenters setValuesWeights(String valueWeights) {
        this.valuesWeights = new SScalar(NearestClusterCenters.nonNull(valueWeights)).toDoubles();
        return this;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public NearestClusterCenters setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    public NearestClusterCenters setMaxDistance(String maxDistance) {
        this.maxDistance = NearestClusterCenters.doubleOrPositiveInfinity(maxDistance);
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public NearestClusterCenters setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = NearestClusterCenters.nonNull(indexingBase);
        return this;
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        SNumbers values = sources.get(0);
        SNumbers centers = sources.get(1);
        if (values.getBlockLength() != centers.getBlockLength()) {
            throw new IllegalArgumentException("Different blockLength");
        }
        float[] valuesArray = values.toFloatArray();
        float[] centersArray = centers.toFloatArray();
        float[] distanceArray = new float[values.n()];
        Arrays.fill(distanceArray, Float.NaN);
        int[] result = this.process(valuesArray, centersArray, values.getBlockLength(), distanceArray);
        this.getNumbers(OUTPUT_DISTANCES).setTo(distanceArray, 1);
        return SNumbers.ofArray(result);
    }

    public int[] process(float[] values, float[] centers, int blockLength, float[] minDistances) {
        if (blockLength <= 0) {
            throw new IllegalArgumentException("Zero or negative blockLength");
        }
        if (values.length % blockLength != 0) {
            throw new IllegalArgumentException("values length % blockLength != 0");
        }
        if (centers.length % blockLength != 0) {
            throw new IllegalArgumentException("centers length % blockLength != 0");
        }
        double[] value = new double[blockLength];
        double[] center = new double[blockLength];
        double[] weights = new double[blockLength];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = i >= this.valuesWeights.length ? 1.0 : this.valuesWeights[i];
        }
        int[] result = new int[values.length / blockLength];
        int valueDisp = 0;
        for (int k = 0; k < result.length; ++k) {
            for (int j = 0; j < blockLength; ++j) {
                value[j] = values[valueDisp++];
            }
            double minDistance = Double.POSITIVE_INFINITY;
            int betsIndex = -1;
            int index = 0;
            int centerDisp = 0;
            while (centerDisp < centers.length) {
                for (int j = 0; j < blockLength; ++j) {
                    center[j] = centers[centerDisp++];
                }
                double distance = this.distanceMetric.distance(value, center, weights);
                if (!(distance > this.maxDistance) && distance <= minDistance) {
                    minDistance = distance;
                    betsIndex = index + this.indexingBase.start;
                }
                ++index;
            }
            if (minDistances != null) {
                minDistances[k] = (float)minDistance;
            }
            result[k] = betsIndex;
        }
        return result;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return false;
    }

    @Override
    protected boolean numberOfBlocksEqualityRequired() {
        return false;
    }
}

