/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.statistics;

import java.util.Locale;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.executors.modules.core.numbers.statistics.NumbersStatistics;
import net.algart.math.IRange;

public final class NumbersColumnsStatistics
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_HISTOGRAM = "histogram";
    public static final String OUTPUT_MEAN = "mean";
    public static final String OUTPUT_SUM = "sum";
    public static final String OUTPUT_VARIANCE = "variance";
    public static final String OUTPUT_STANDARD_DEVIATION = "standard_deviation";
    public static final String OUTPUT_PERCENTILES_PREFIX = "percentile_";
    public static final String OUTPUT_ALL_PERCENTILES = "percentiles";
    public static final String OUTPUT_TWO_PERCENTILES_DIFFERENCE = "two_percentiles_difference";
    public static final String OUTPUT_NUMBER_OF_BLOCKS = "number_of_blocks";
    public static final String OUTPUT_BLOCK_LENGTH = "block_length";
    public static final String OUTPUT_ARRAY_LENGTH = "array_length";
    private int numberOfHistogramColumns = 100;
    private Double histogramFrom = null;
    private Double histogramTo = null;
    private double[] percentileLevels = new double[0];

    public NumbersColumnsStatistics() {
        this.useVisibleResultParameter();
        this.setDefaultOutputNumbers(OUTPUT_HISTOGRAM);
        this.addOutputNumbers(OUTPUT_MEAN);
        this.addOutputNumbers(OUTPUT_SUM);
        this.addOutputNumbers(OUTPUT_VARIANCE);
        this.addOutputNumbers(OUTPUT_STANDARD_DEVIATION);
        for (int k = 0; k < 5; ++k) {
            this.addOutputNumbers(NumbersColumnsStatistics.outputPercentilePortName(k));
        }
        this.addOutputNumbers(OUTPUT_ALL_PERCENTILES);
        this.addOutputNumbers(OUTPUT_TWO_PERCENTILES_DIFFERENCE);
        this.addOutputScalar(OUTPUT_NUMBER_OF_BLOCKS);
        this.addOutputScalar(OUTPUT_BLOCK_LENGTH);
        this.addOutputScalar(OUTPUT_ARRAY_LENGTH);
    }

    public int getNumberOfHistogramColumns() {
        return this.numberOfHistogramColumns;
    }

    public NumbersColumnsStatistics setNumberOfHistogramColumns(int numberOfHistogramColumns) {
        this.numberOfHistogramColumns = NumbersColumnsStatistics.positive(numberOfHistogramColumns);
        return this;
    }

    public Double getHistogramFrom() {
        return this.histogramFrom;
    }

    public NumbersColumnsStatistics setHistogramFrom(Double histogramFrom) {
        this.histogramFrom = histogramFrom;
        return this;
    }

    public NumbersColumnsStatistics setHistogramFrom(String histogramFrom) {
        return this.setHistogramFrom(NumbersColumnsStatistics.doubleOrNull(histogramFrom));
    }

    public Double getHistogramTo() {
        return this.histogramTo;
    }

    public NumbersColumnsStatistics setHistogramTo(Double histogramTo) {
        this.histogramTo = histogramTo;
        return this;
    }

    public NumbersColumnsStatistics setHistogramTo(String histogramTo) {
        return this.setHistogramTo(NumbersColumnsStatistics.doubleOrNull(histogramTo));
    }

    public double[] getPercentileLevels() {
        return (double[])this.percentileLevels.clone();
    }

    public NumbersColumnsStatistics setPercentileLevels(double[] percentileLevels) {
        this.percentileLevels = NumbersColumnsStatistics.nonNull(percentileLevels);
        return this;
    }

    public NumbersColumnsStatistics setPercentileLevels(String percentileLevels) {
        this.percentileLevels = new SScalar(NumbersColumnsStatistics.nonNull(percentileLevels)).toDoubles();
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers source) {
        long t1 = NumbersColumnsStatistics.debugTime();
        Object[] allColumns = this.getLengthInBlock() <= 0 ? source.allColumnsArrays() : source.columnRangeArrays(this.getIndexInBlock(), this.getLengthInBlock());
        long t2 = NumbersColumnsStatistics.debugTime();
        int blockLength = allColumns.length;
        int n = source.n();
        SNumbers histogramNumbers = this.isOutputNecessary(OUTPUT_HISTOGRAM) ? SNumbers.zeros(Long.TYPE, this.numberOfHistogramColumns, blockLength) : null;
        SNumbers sumNumbers = this.create(OUTPUT_SUM, 1, blockLength);
        SNumbers meanNumbers = this.create(OUTPUT_MEAN, 1, blockLength);
        SNumbers varianceNumbers = this.create(OUTPUT_VARIANCE, 1, blockLength);
        SNumbers standardDeviationNumbers = this.create(OUTPUT_STANDARD_DEVIATION, 1, blockLength);
        SNumbers percentileNumbers = this.isOutputNecessary(OUTPUT_ALL_PERCENTILES) || this.isOutputNecessary(OUTPUT_TWO_PERCENTILES_DIFFERENCE) || IntStream.range(0, this.percentileLevels.length).anyMatch(this::isPercentileNecessary) ? SNumbers.zeros(Double.TYPE, this.percentileLevels.length, blockLength) : null;
        boolean needVariance = varianceNumbers != null || standardDeviationNumbers != null;
        boolean needSum = needVariance || sumNumbers != null || meanNumbers != null;
        long t3 = NumbersColumnsStatistics.debugTime();
        IntStream.range(0, blockLength).parallel().forEach(c -> {
            double variance;
            double sum;
            UpdatablePArray array = (UpdatablePArray)SimpleMemoryModel.asUpdatableArray((Object)allColumns[c]);
            assert (array.length() == (long)n);
            if (histogramNumbers != null) {
                long[] histogram = NumbersStatistics.analyseHistogram((PArray)array, this.numberOfHistogramColumns, this.histogramFrom, this.histogramTo);
                IntStream.range(0, histogram.length).forEach(k -> histogramNumbers.setLongValue(k, c, histogram[k]));
            }
            double d = sum = needSum ? Arrays.sumOf((PArray)array) : Double.NaN;
            if (sumNumbers != null) {
                sumNumbers.setValue(c, sum);
            }
            if (meanNumbers != null) {
                meanNumbers.setValue(c, sum / (double)n);
            }
            double d2 = variance = needVariance ? NumbersStatistics.analyseVariance((PArray)array, sum / (double)n) : Double.NaN;
            if (varianceNumbers != null) {
                varianceNumbers.setValue(c, variance);
            }
            if (standardDeviationNumbers != null) {
                standardDeviationNumbers.setValue(c, Math.sqrt(variance));
            }
            if (percentileNumbers != null) {
                double[] percentiles = NumbersStatistics.analysePercentiles(array, this.percentileLevels);
                IntStream.range(0, percentiles.length).forEach(k -> percentileNumbers.setValue(k, c, percentiles[k]));
            }
        });
        long t4 = NumbersColumnsStatistics.debugTime();
        NumbersColumnsStatistics.logDebug(String.format(Locale.US, "Calculating multi-column statistics for %dx%d numbers: %.3f ms = %.3f ms splitting + %.3f ms initializing + %.3f ms (%.3f ns/block) processing", blockLength, n, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t4 - t3) / (double)n));
        this.getScalar(OUTPUT_NUMBER_OF_BLOCKS).setTo(n);
        this.getScalar(OUTPUT_BLOCK_LENGTH).setTo(blockLength);
        this.getScalar(OUTPUT_ARRAY_LENGTH).setTo(source.getArrayLength());
        if (percentileNumbers != null) {
            if (this.isOutputNecessary(OUTPUT_ALL_PERCENTILES)) {
                this.getNumbers(OUTPUT_ALL_PERCENTILES).setTo(percentileNumbers);
            }
            for (int k = 0; k < this.percentileLevels.length; ++k) {
                String portName = NumbersColumnsStatistics.outputPercentilePortName(k);
                if (!this.isOutputNecessary(portName)) continue;
                this.getNumbers(portName).setTo(percentileNumbers.blockRange(k, 1));
            }
            if (this.isOutputNecessary(OUTPUT_TWO_PERCENTILES_DIFFERENCE) && this.percentileLevels.length >= 2) {
                SNumbers difference = this.create(OUTPUT_TWO_PERCENTILES_DIFFERENCE, 1, blockLength);
                assert (difference != null) : "illegal change of output necessary flag: parallel thread?";
                for (int c2 = 0; c2 < blockLength; ++c2) {
                    double percentile1 = percentileNumbers.getValue(blockLength + c2);
                    double percentile0 = percentileNumbers.getValue(c2);
                    difference.setValue(c2, percentile1 - percentile0);
                }
            }
        }
        return histogramNumbers;
    }

    private SNumbers create(String outputPortName, int n, int blockLength) {
        if (this.isOutputNecessary(outputPortName)) {
            return this.getNumbers(outputPortName).setToZeros(Double.TYPE, n, blockLength);
        }
        return null;
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    @Override
    protected IRange selectedColumnRange() {
        return null;
    }

    private boolean isPercentileNecessary(int index) {
        return this.isOutputNecessary(NumbersColumnsStatistics.outputPercentilePortName(index));
    }

    private static String outputPercentilePortName(int index) {
        return OUTPUT_PERCENTILES_PREFIX + (index + 1);
    }
}

