/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import net.algart.executors.api.Executor;
import net.algart.executors.api.HighLevelException;
import net.algart.executors.modules.core.logic.ConditionStyle;
import net.algart.executors.modules.core.scalars.arithmetic.CheckScalarsEquality;

public final class CheckNumberInRange
extends Executor {
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean invert = false;
    private CheckScalarsEquality.ActionOnFail actionOnFail = CheckScalarsEquality.ActionOnFail.RETURN_FALSE;
    private ConditionStyle booleanStyle = ConditionStyle.JAVA_LIKE;

    public CheckNumberInRange() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public double getMin() {
        return this.min;
    }

    public CheckNumberInRange setMin(double min) {
        this.min = min;
        return this;
    }

    public CheckNumberInRange setMin(String min) {
        this.min = CheckNumberInRange.doubleOrNegativeInfinity(min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public CheckNumberInRange setMax(double max) {
        this.max = max;
        return this;
    }

    public CheckNumberInRange setMax(String max) {
        this.max = CheckNumberInRange.doubleOrPositiveInfinity(max);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public CheckNumberInRange setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public CheckScalarsEquality.ActionOnFail getActionOnFail() {
        return this.actionOnFail;
    }

    public CheckNumberInRange setActionOnFail(CheckScalarsEquality.ActionOnFail actionOnFail) {
        this.actionOnFail = CheckNumberInRange.nonNull(actionOnFail);
        return this;
    }

    public ConditionStyle getBooleanStyle() {
        return this.booleanStyle;
    }

    public CheckNumberInRange setBooleanStyle(ConditionStyle booleanStyle) {
        this.booleanStyle = CheckNumberInRange.nonNull(booleanStyle);
        return this;
    }

    @Override
    public void process() {
        boolean result;
        double value;
        String scalar = this.getInputScalar().getValue();
        try {
            value = Double.parseDouble(scalar);
        }
        catch (NumberFormatException e) {
            throw new HighLevelException(new IllegalArgumentException("Input value " + scalar + " is not a number (it must be a number " + (!this.invert ? "inside" : "outside") + " the range " + this.min + ".." + this.max + ")"));
        }
        boolean bl = result = this.min <= value && value <= this.max;
        if (this.invert) {
            result = !result;
        }
        this.booleanStyle.setScalar(this.getScalar(), result);
        if (!result && this.actionOnFail == CheckScalarsEquality.ActionOnFail.THROW_EXCEPTION) {
            throw new HighLevelException(new IllegalArgumentException("Input number " + value + " is " + (this.invert ? "inside" : "outside") + " the range " + this.min + ".." + this.max));
        }
    }
}

