/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.conversions;

import java.util.Locale;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.NumbersToScalar;

public class JoinNumbersToScalar
extends NumbersToScalar
implements ReadOnlyExecutionInput {
    private int blockIndex = -1;
    private SNumbers.FormattingType formattingType = SNumbers.FormattingType.SIMPLE;
    private String locale = null;
    private String fixedPointFormat = "%7d";
    private String floatingPointFormat = "%10.3f";
    private String elementsDelimiter = ", ";
    private int minimalElementLength = 0;
    private boolean addLineIndexes = false;
    private String lineIndexFormat = "%d";
    private String lineIndexDelimiter = ": ";
    private int minimalLineIndexLength = 0;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private String linesDelimiter = "\\n";
    private boolean addEndingLinesDelimiter = true;
    private boolean simpleFormatForIntegers = false;
    private boolean parallelExecution = true;

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public JoinNumbersToScalar setBlockIndex(int blockIndex) {
        this.blockIndex = blockIndex;
        return this;
    }

    public SNumbers.FormattingType getFormattingType() {
        return this.formattingType;
    }

    public JoinNumbersToScalar setFormattingType(SNumbers.FormattingType formattingType) {
        this.formattingType = JoinNumbersToScalar.nonNull(formattingType);
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public JoinNumbersToScalar setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getFixedPointFormat() {
        return this.fixedPointFormat;
    }

    public JoinNumbersToScalar setFixedPointFormat(String fixedPointFormat) {
        this.fixedPointFormat = JoinNumbersToScalar.nonEmpty(fixedPointFormat);
        return this;
    }

    public String getFloatingPointFormat() {
        return this.floatingPointFormat;
    }

    public JoinNumbersToScalar setFloatingPointFormat(String floatingPointFormat) {
        this.floatingPointFormat = JoinNumbersToScalar.nonEmpty(floatingPointFormat);
        return this;
    }

    public String getElementsDelimiter() {
        return this.elementsDelimiter;
    }

    public JoinNumbersToScalar setElementsDelimiter(String elementsDelimiter) {
        this.elementsDelimiter = JoinNumbersToScalar.nonNull(elementsDelimiter);
        return this;
    }

    public int getMinimalElementLength() {
        return this.minimalElementLength;
    }

    public JoinNumbersToScalar setMinimalElementLength(int minimalElementLength) {
        this.minimalElementLength = JoinNumbersToScalar.nonNegative(minimalElementLength);
        return this;
    }

    public boolean isAddLineIndexes() {
        return this.addLineIndexes;
    }

    public JoinNumbersToScalar setAddLineIndexes(boolean addLineIndexes) {
        this.addLineIndexes = addLineIndexes;
        return this;
    }

    public String getLineIndexFormat() {
        return this.lineIndexFormat;
    }

    public JoinNumbersToScalar setLineIndexFormat(String lineIndexFormat) {
        this.lineIndexFormat = JoinNumbersToScalar.nonNull(lineIndexFormat);
        return this;
    }

    public String getLineIndexDelimiter() {
        return this.lineIndexDelimiter;
    }

    public JoinNumbersToScalar setLineIndexDelimiter(String lineIndexDelimiter) {
        this.lineIndexDelimiter = JoinNumbersToScalar.nonNull(lineIndexDelimiter);
        return this;
    }

    public int getMinimalLineIndexLength() {
        return this.minimalLineIndexLength;
    }

    public JoinNumbersToScalar setMinimalLineIndexLength(int minimalLineIndexLength) {
        this.minimalLineIndexLength = JoinNumbersToScalar.nonNegative(minimalLineIndexLength);
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public JoinNumbersToScalar setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = JoinNumbersToScalar.nonNull(indexingBase);
        return this;
    }

    public String getLinesDelimiter() {
        return this.linesDelimiter;
    }

    public JoinNumbersToScalar setLinesDelimiter(String linesDelimiter) {
        this.linesDelimiter = JoinNumbersToScalar.nonNull(linesDelimiter);
        return this;
    }

    public boolean isAddEndingLinesDelimiter() {
        return this.addEndingLinesDelimiter;
    }

    public JoinNumbersToScalar setAddEndingLinesDelimiter(boolean addEndingLinesDelimiter) {
        this.addEndingLinesDelimiter = addEndingLinesDelimiter;
        return this;
    }

    public boolean isSimpleFormatForIntegers() {
        return this.simpleFormatForIntegers;
    }

    public JoinNumbersToScalar setSimpleFormatForIntegers(boolean simpleFormatForIntegers) {
        this.simpleFormatForIntegers = simpleFormatForIntegers;
        return this;
    }

    public boolean isParallelExecution() {
        return this.parallelExecution;
    }

    public JoinNumbersToScalar setParallelExecution(boolean parallelExecution) {
        this.parallelExecution = parallelExecution;
        return this;
    }

    @Override
    public SScalar analyse(SNumbers source) {
        return SScalar.of(this.join(source));
    }

    public String join(SNumbers source) {
        if (!source.isInitialized()) {
            return null;
        }
        long t1 = JoinNumbersToScalar.debugTime();
        String locale = JoinNumbersToScalar.trimOrNull(this.locale);
        String elementsFormat = source.isFloatingPoint() ? this.floatingPointFormat : this.fixedPointFormat;
        SNumbers.Formatter formatter = source.getFormatter(this.formattingType, locale == null ? null : Locale.forLanguageTag(locale)).setElementsFormat(elementsFormat).setElementsDelimiter(this.elementsDelimiter).setMinimalElementLength(this.minimalElementLength).setAddLineIndexes(this.addLineIndexes).setLineIndexFormat(this.lineIndexFormat).setLineIndexDelimiter(this.lineIndexDelimiter).setMinimalLineIndexLength(this.minimalLineIndexLength).setLineIndexStart(this.indexingBase.start).setLinesDelimiter(this.linesDelimiter.replace("\\n", "\n").replace("\\r", "\r")).setAddEndingLinesDelimiter(this.addEndingLinesDelimiter).setSimpleFormatForIntegers(this.simpleFormatForIntegers).setParallelExecution(this.parallelExecution);
        long t2 = JoinNumbersToScalar.debugTime();
        String result = this.blockIndex >= 0 ? formatter.formatRange(this.blockIndex, 1) : formatter.format();
        long t3 = JoinNumbersToScalar.debugTime();
        JoinNumbersToScalar.logDebug(() -> String.format(Locale.US, "Joining %dx%d numbers (%s): %.3f ms = %.3f ms initializing + %.3f ms processing", new Object[]{source.getBlockLength(), source.n(), this.formattingType, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6}));
        return result;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }

    private static String trimOrNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }
}

