/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SettingsTree;
import net.algart.executors.api.system.SmartSearchSettings;

public class GetSettingsTree
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DEFAULT_SETTINGS = "default_settings";
    public static final String OUTPUT_SETTINGS_SPECIFICATION = "settings_specification";
    public static final String OUTPUT_CATEGORY = "category";
    public static final String OUTPUT_NAME = "name";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_ID = "id";
    public static final String OUTPUT_COMPLETE = "complete";
    public static final String OUTPUT_NUMBER_OF_TREES = "number_of_trees";
    public static final String OUTPUT_SUBTREE_PATHS = "tree_paths";
    public static final String OUTPUT_CONTROL_PATHS = "control_paths";
    private static final List<String> ALL_OUTPUT_PORTS = List.of(DEFAULT_OUTPUT_PORT, "default_settings", "settings_specification", "category", "name", "description", "id", "complete", "number_of_trees", "tree_paths", "control_paths");
    private String id = "n/a";
    private boolean buildTree = true;
    private boolean smartSearch = true;
    private ExecutorSpecification.JsonMode jsonMode = ExecutorSpecification.JsonMode.MEDIUM;
    private System.Logger.Level logLevel = System.Logger.Level.DEBUG;
    private volatile ExecutorSpecificationFactory factory = null;
    private volatile SmartSearchSettings smartSearchSettings = null;

    public GetSettingsTree() {
        this.addInputScalar("executor_id");
        ALL_OUTPUT_PORTS.forEach(this::addOutputScalar);
    }

    public String getId() {
        return this.id;
    }

    public GetSettingsTree setId(String id) {
        this.id = GetSettingsTree.nonNull(id);
        return this;
    }

    public boolean isBuildTree() {
        return this.buildTree;
    }

    public GetSettingsTree setBuildTree(boolean buildTree) {
        this.buildTree = buildTree;
        return this;
    }

    public boolean isSmartSearch() {
        return this.smartSearch;
    }

    public GetSettingsTree setSmartSearch(boolean smartSearch) {
        this.smartSearch = smartSearch;
        return this;
    }

    public ExecutorSpecification.JsonMode getJsonMode() {
        return this.jsonMode;
    }

    public GetSettingsTree setJsonMode(ExecutorSpecification.JsonMode jsonMode) {
        this.jsonMode = GetSettingsTree.nonNull(jsonMode);
        return this;
    }

    public System.Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public GetSettingsTree setLogLevel(System.Logger.Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public void process() {
        SettingsTree tree;
        ALL_OUTPUT_PORTS.forEach(s -> this.getScalar((String)s).remove());
        this.getScalar(OUTPUT_COMPLETE).setTo(false);
        this.getScalar(OUTPUT_NUMBER_OF_TREES).setTo(0);
        String id = this.getInputScalar("executor_id", true).getValue();
        if (id == null) {
            id = this.id;
        }
        if ((tree = this.buildSettingsTree(id)) == null) {
            return;
        }
        ExecutorSpecification specification = tree.specification();
        if (specification.hasSettings()) {
            this.getScalar(OUTPUT_SETTINGS_SPECIFICATION).setTo(specification.getSettings().jsonString());
        }
        this.getScalar(OUTPUT_CATEGORY).setTo(specification.getCategory());
        this.getScalar(OUTPUT_NAME).setTo(specification.getName());
        this.getScalar(OUTPUT_DESCRIPTION).setTo(specification.getDescription());
        this.getScalar(OUTPUT_ID).setTo(specification.getId());
        this.getScalar(OUTPUT_COMPLETE).setTo(tree.isComplete());
        this.getScalar(OUTPUT_NUMBER_OF_TREES).setTo(tree.numberOfTrees());
        this.setOutputScalarIfNecessary(OUTPUT_SUBTREE_PATHS, () -> GetSettingsTree.listToString(tree.treePaths()));
        this.setOutputScalarIfNecessary(OUTPUT_CONTROL_PATHS, () -> GetSettingsTree.listToString(tree.controlPaths()));
    }

    public SettingsTree buildSettingsTree(String executorId) {
        String defaultSettingsJson;
        long t4;
        String treeJson;
        Objects.requireNonNull(executorId, "Null executorId");
        long t1 = GetSettingsTree.debugTime();
        if (this.factory == null || this.smartSearchSettings == null) {
            ExecutorLoaderSet globalLoaders = GetSettingsTree.globalLoaders();
            String sessionId = this.getSessionId();
            this.smartSearchSettings = SmartSearchSettings.newInstance(globalLoaders, sessionId);
            this.factory = this.smartSearchSettings.factory();
        }
        this.smartSearchSettings.setLogLevel(this.logLevel);
        ExecutorSpecification specification = this.factory.getSpecification(executorId);
        if (specification == null) {
            return null;
        }
        long t2 = GetSettingsTree.debugTime();
        SettingsTree tree = this.smartSearch ? SettingsTree.of(this.smartSearchSettings, specification) : SettingsTree.of(this.factory, specification);
        long t3 = GetSettingsTree.debugTime();
        if (this.buildTree) {
            treeJson = tree.specificationJsonString(this.jsonMode);
            t4 = GetSettingsTree.debugTime();
            defaultSettingsJson = tree.defaultSettingsJsonString();
        } else {
            treeJson = specification.jsonString(this.jsonMode);
            t4 = GetSettingsTree.debugTime();
            defaultSettingsJson = specification.defaultSettingsJsonString();
        }
        long t5 = GetSettingsTree.debugTime();
        this.getScalar().setTo(treeJson);
        this.getScalar(OUTPUT_DEFAULT_SETTINGS).setTo(defaultSettingsJson);
        GetSettingsTree.logDebug(() -> String.format(Locale.US, "Settings \"%s\": %.5f ms = %.3f ms requesting description + %.3f ms building tree + %.3f ms specification JSON + %.3f ms default values JSON ", executorId, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        return tree;
    }

    private static String listToString(List<?> paths) {
        return paths.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

