/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.util.Objects;
import net.algart.graalvm.GraalSourceContainer;

public enum JSType {
    COMMON("common"){

        @Override
        void doConfigure(GraalSourceContainer container) {
        }
    }
    ,
    MODULE("module"){

        @Override
        void doConfigure(GraalSourceContainer container) {
            container.setMimeType("application/javascript+module");
        }
    };

    private final String typeName;

    private JSType(String typeName) {
        this.typeName = typeName;
    }

    public String typeName() {
        return this.typeName;
    }

    public static JSType valueOfTypeNameOrNull(String name) {
        Objects.requireNonNull(name, "Null type name");
        for (JSType type : JSType.values()) {
            if (!name.equals(type.typeName)) continue;
            return type;
        }
        return null;
    }

    public void configure(GraalSourceContainer container, Object scriptOrigin, String name) {
        Objects.requireNonNull(container, "Null container");
        Objects.requireNonNull(scriptOrigin, "Null script origin");
        container.setLanguage("js");
        container.setOrigin(scriptOrigin, name);
        this.doConfigure(container);
    }

    abstract void doConfigure(GraalSourceContainer var1);
}

