/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.home.HomeFinder;
import org.graalvm.home.Version;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.ResourceLimits;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.IOAccess;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyDate;
import org.graalvm.polyglot.proxy.ProxyDuration;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyHashMap;
import org.graalvm.polyglot.proxy.ProxyInstant;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyIterable;
import org.graalvm.polyglot.proxy.ProxyIterator;
import org.graalvm.polyglot.proxy.ProxyNativeObject;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyTime;
import org.graalvm.polyglot.proxy.ProxyTimeZone;

public final class Engine
implements AutoCloseable {
    private static volatile Throwable initializationException;
    private static volatile boolean shutdownHookInitialized;
    private static final Set<CleanableReference<Engine>> ENGINES;
    final AbstractPolyglotImpl.AbstractEngineDispatch dispatch;
    final Object receiver;
    final Engine currentAPI;
    final Engine creatorEngine;
    private static final Engine EMPTY;

    <T> Engine(AbstractPolyglotImpl.AbstractEngineDispatch dispatch, T receiver) {
        this.dispatch = dispatch;
        this.receiver = receiver;
        this.currentAPI = new Engine(this);
        this.creatorEngine = this;
    }

    private <T> Engine(Engine engine) {
        this.dispatch = engine.dispatch;
        this.receiver = engine.receiver;
        this.currentAPI = null;
        this.creatorEngine = engine;
    }

    public Map<String, Language> getLanguages() {
        try {
            Map<String, Object> map = this.dispatch.getLanguages(this.receiver);
            return map;
        }
        finally {
            Reference.reachabilityFence(this.creatorEngine);
        }
    }

    public Map<String, Instrument> getInstruments() {
        try {
            Map<String, Object> map = this.dispatch.getInstruments(this.receiver);
            return map;
        }
        finally {
            Reference.reachabilityFence(this.creatorEngine);
        }
    }

    public OptionDescriptors getOptions() {
        try {
            OptionDescriptors optionDescriptors = this.dispatch.getOptions(this.receiver);
            return optionDescriptors;
        }
        finally {
            Reference.reachabilityFence(this.creatorEngine);
        }
    }

    public String getVersion() {
        return this.dispatch.getVersion(this.receiver);
    }

    public void close(boolean cancelIfExecuting) {
        if (this.currentAPI == null) {
            throw new IllegalStateException("Engine instances that were indirectly received using Context.getCurrent() cannot be closed.");
        }
        this.dispatch.close(this.receiver, this, cancelIfExecuting);
        Reference.reachabilityFence(this.creatorEngine);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public String getImplementationName() {
        return this.dispatch.getImplementationName(this.receiver);
    }

    public static Engine create() {
        return Engine.newBuilder().build();
    }

    public static Engine create(String ... permittedLanguages) {
        return Engine.newBuilder(permittedLanguages).build();
    }

    public static Builder newBuilder() {
        Engine engine = EMPTY;
        Objects.requireNonNull(engine);
        return engine.new Builder(new String[0]);
    }

    public static Builder newBuilder(String ... permittedLanguages) {
        Objects.requireNonNull(permittedLanguages);
        Engine engine = EMPTY;
        Objects.requireNonNull(engine);
        return engine.new Builder(permittedLanguages);
    }

    public static Path findHome() {
        return HomeFinder.getInstance().getHomeFolder();
    }

    public Set<Source> getCachedSources() {
        try {
            Set<Object> set = this.dispatch.getCachedSources(this.receiver);
            return set;
        }
        finally {
            Reference.reachabilityFence(this.creatorEngine);
        }
    }

    public static boolean copyResources(Path targetFolder, String ... components) throws IOException {
        return Engine.getImpl().copyResources(targetFolder, components);
    }

    static AbstractPolyglotImpl getImpl() {
        try {
            return ImplHolder.IMPL;
        }
        catch (NoClassDefFoundError e) {
            Throwable cause = initializationException;
            if (cause != null && e.getCause() == null) {
                e.initCause(cause);
            }
            throw e;
        }
        catch (Throwable e) {
            initializationException = e;
            throw e;
        }
    }

    static Class<?> loadLanguageClass(String className) {
        return Engine.getImpl().loadLanguageClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<Engine> findActiveEngines() {
        Set<CleanableReference<Engine>> set = ENGINES;
        synchronized (set) {
            ArrayList<Engine> result = new ArrayList<Engine>(ENGINES.size());
            for (Reference reference : ENGINES) {
                Engine engine = (Engine)reference.get();
                if (engine == null) continue;
                result.add(engine);
            }
            return result;
        }
    }

    static void validateSandboxPolicy(SandboxPolicy previous, SandboxPolicy policy) {
        Objects.requireNonNull(policy, "The set policy must not be null.");
        if (previous != null && previous.isStricterThan(policy)) {
            throw new IllegalArgumentException(String.format("The sandbox policy %s was set for this builder and the newly set policy %s is less restrictive than the previous policy. Only equal or more strict policies are allowed. ", new Object[]{previous, policy}));
        }
    }

    static boolean isSystemStream(InputStream in) {
        return System.in == in;
    }

    static boolean isSystemStream(OutputStream out) {
        return System.out == out || System.err == out;
    }

    private static AbstractPolyglotImpl loadAndValidateProviders(Iterator<? extends AbstractPolyglotImpl> providers) throws AssertionError {
        ArrayList<AbstractPolyglotImpl> impls = new ArrayList<AbstractPolyglotImpl>();
        while (providers.hasNext()) {
            AbstractPolyglotImpl found = providers.next();
            for (AbstractPolyglotImpl impl : impls) {
                if (impl.getClass().getName().equals(found.getClass().getName())) {
                    throw new AssertionError((Object)"Same polyglot impl found twice on the classpath.");
                }
            }
            impls.add(found);
        }
        Collections.sort(impls, Comparator.comparing(AbstractPolyglotImpl::getPriority));
        Version polyglotVersion = Boolean.getBoolean("polyglotimpl.DisableVersionChecks") ? null : Engine.getPolyglotVersion();
        AbstractPolyglotImpl prev = null;
        for (AbstractPolyglotImpl impl : impls) {
            if (impl.getPriority() == Integer.MIN_VALUE) continue;
            if (polyglotVersion != null) {
                Version truffleVersion;
                String truffleVersionString = impl.getTruffleVersion();
                Version version = truffleVersion = truffleVersionString != null ? Version.parse(truffleVersionString) : Version.create(23, 1, 1);
                if (!polyglotVersion.equals(truffleVersion)) {
                    StringBuilder errorMessage = new StringBuilder(String.format("Polyglot version compatibility check failed.\nThe polyglot version '%s' is not compatible to the used Truffle version '%s'.\n", polyglotVersion, truffleVersion));
                    if (polyglotVersion.compareTo(truffleVersion) < 0) {
                        errorMessage.append(String.format("The polyglot version is older than the Truffle or language version in use.\nThe polygot and truffle version must always match.\nUpdate the org.graalvm.polyglot versions to '%s' to resolve this.\n", truffleVersion));
                    } else {
                        errorMessage.append(String.format("The Truffle or language version is older than the polyglot version in use.\nThe polygot and truffle version must always match.\nUpdate the Truffle or language versions to '%s' to resolve this.\n", polyglotVersion));
                    }
                    errorMessage.append("To disable this version check the '-Dpolyglotimpl.DisableVersionChecks=true' system property can be used.\nIt is not recommended to disable version checks.\n");
                    throw new IllegalStateException(errorMessage.toString());
                }
            }
            impl.setNext(prev);
            try {
                impl.setConstructors(APIAccessImpl.INSTANCE);
                Field ioAccess = Class.forName("org.graalvm.polyglot.io.IOHelper").getDeclaredField("ACCESS");
                ioAccess.setAccessible(true);
                impl.setIO((AbstractPolyglotImpl.IOAccessor)ioAccess.get(null));
                Field managementAccess = Class.forName("org.graalvm.polyglot.management.Management").getDeclaredField("ACCESS");
                managementAccess.setAccessible(true);
                impl.setMonitoring((AbstractPolyglotImpl.ManagementAccess)managementAccess.get(null));
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError(e);
            }
            impl.initialize();
            prev = impl;
        }
        return prev;
    }

    private static Version getPolyglotVersion() {
        Version version;
        InputStream in = Engine.class.getResourceAsStream("/META-INF/graalvm/org.graalvm.polyglot/version");
        if (in == null) {
            throw new InternalError("Polyglot must have a version file.");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            version = Version.parse(r.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new InternalError(ioe);
            }
        }
        r.close();
        return version;
    }

    private static AbstractPolyglotImpl initEngineImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<AbstractPolyglotImpl>(){

            @Override
            public AbstractPolyglotImpl run() {
                AbstractPolyglotImpl polyglot = null;
                if (!Boolean.getBoolean("graalvm.ForcePolyglotInvalid")) {
                    polyglot = Engine.loadAndValidateProviders(this.searchServiceLoader());
                }
                if (polyglot == null) {
                    polyglot = Engine.loadAndValidateProviders(Engine.createInvalidPolyglotImpl());
                }
                return polyglot;
            }

            private Iterator<? extends AbstractPolyglotImpl> searchServiceLoader() throws InternalError {
                Class<AbstractPolyglotImpl> serviceClass = AbstractPolyglotImpl.class;
                Module polyglotModule = serviceClass.getModule();
                ServiceLoader<AbstractPolyglotImpl> services = polyglotModule.isNamed() ? ServiceLoader.load(polyglotModule.getLayer(), AbstractPolyglotImpl.class) : ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
                Iterator iterator = services.iterator();
                if (!iterator.hasNext()) {
                    services = ServiceLoader.load(AbstractPolyglotImpl.class);
                    iterator = services.iterator();
                }
                return iterator;
            }
        });
    }

    static Iterator<? extends AbstractPolyglotImpl> createInvalidPolyglotImpl() {
        return Arrays.asList(new PolyglotInvalid()).iterator();
    }

    static {
        ENGINES = Collections.synchronizedSet(new HashSet());
        EMPTY = new Engine(null, null);
    }

    public final class Builder {
        private static final AtomicReference<Boolean> allowExperimentalOptionSystemPropertyValue = new AtomicReference();
        private OutputStream out = System.out;
        private OutputStream err = System.err;
        private InputStream in = null;
        private Map<String, String> options = new HashMap<String, String>();
        private boolean allowExperimentalOptions = false;
        private boolean useSystemProperties = true;
        private boolean boundEngine;
        private MessageTransport messageTransport;
        private Object customLogHandler;
        private String[] permittedLanguages;
        private SandboxPolicy sandboxPolicy = SandboxPolicy.TRUSTED;

        Builder(String[] permittedLanguages) {
            Objects.requireNonNull(permittedLanguages);
            for (String language : permittedLanguages) {
                Objects.requireNonNull(language);
            }
            this.permittedLanguages = permittedLanguages;
        }

        Builder setBoundEngine(boolean boundEngine) {
            this.boundEngine = boundEngine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        public Builder allowExperimentalOptions(boolean enabled) {
            this.allowExperimentalOptions = enabled;
            return this;
        }

        public Builder useSystemProperties(boolean enabled) {
            this.useSystemProperties = enabled;
            return this;
        }

        public Builder option(String key, String value) {
            Objects.requireNonNull(key, "Key must not be null.");
            Objects.requireNonNull(value, "Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder sandbox(SandboxPolicy policy) {
            Engine.validateSandboxPolicy(this.sandboxPolicy, policy);
            this.sandboxPolicy = policy;
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (String key : options.keySet()) {
                Objects.requireNonNull(options.get(key), "All option values must be non-null.");
            }
            this.options.putAll(options);
            return this;
        }

        public Builder serverTransport(MessageTransport serverTransport) {
            Objects.requireNonNull(serverTransport, "MessageTransport must be non null.");
            this.messageTransport = serverTransport;
            return this;
        }

        public Builder logHandler(Handler logHandler) {
            Objects.requireNonNull(logHandler, "Handler must be non null.");
            this.customLogHandler = logHandler;
            return this;
        }

        public Builder logHandler(OutputStream logOut) {
            Objects.requireNonNull(logOut, "LogOut must be non null.");
            this.customLogHandler = logOut;
            return this;
        }

        public Engine build() {
            AbstractPolyglotImpl polyglot = Engine.getImpl();
            if (polyglot == null) {
                throw new IllegalStateException("The Polyglot API implementation failed to load.");
            }
            this.validateSandbox();
            InputStream useIn = this.in;
            if (useIn == null) {
                useIn = switch (this.sandboxPolicy) {
                    case SandboxPolicy.TRUSTED -> System.in;
                    case SandboxPolicy.CONSTRAINED, SandboxPolicy.ISOLATED, SandboxPolicy.UNTRUSTED -> InputStream.nullInputStream();
                    default -> throw new IllegalArgumentException(String.valueOf((Object)this.sandboxPolicy));
                };
            }
            Object logHandler = this.customLogHandler != null ? polyglot.newLogHandler(this.customLogHandler) : null;
            Map<String, String> useOptions = this.useSystemProperties ? Builder.readOptionsFromSystemProperties(this.options) : this.options;
            boolean useAllowExperimentalOptions = this.allowExperimentalOptions || Builder.readAllowExperimentalOptionsFromSystemProperties();
            Engine engine = polyglot.buildEngine(this.permittedLanguages, this.sandboxPolicy, this.out, this.err, useIn, useOptions, useAllowExperimentalOptions, this.boundEngine, this.messageTransport, logHandler, polyglot.createHostLanguage(polyglot.createHostAccess()), false, true, null);
            return engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Map<String, String> readOptionsFromSystemProperties(Map<String, String> options) {
            Properties properties = System.getProperties();
            HashMap<String, String> newOptions = null;
            String systemPropertyPrefix = "polyglot.";
            Properties properties2 = properties;
            synchronized (properties2) {
                for (Object systemKey : properties.keySet()) {
                    String optionKey;
                    String key = (String)systemKey;
                    if ("polyglot.engine.AllowExperimentalOptions".equals(key) || key.equals("polyglot.engine.resourcePath") || key.startsWith("polyglot.engine.resourcePath.") || key.equals("polyglot.engine.userResourceCache") || !key.startsWith(systemPropertyPrefix) || (optionKey = key.substring(systemPropertyPrefix.length())).startsWith("image-build-time") || options.containsKey(optionKey)) continue;
                    if (newOptions == null) {
                        newOptions = new HashMap<String, String>(options);
                    }
                    newOptions.put(optionKey, System.getProperty(key));
                }
            }
            if (newOptions == null) {
                return options;
            }
            return newOptions;
        }

        private static boolean readAllowExperimentalOptionsFromSystemProperties() {
            Boolean old;
            Boolean res = allowExperimentalOptionSystemPropertyValue.get();
            if (res == null && (old = allowExperimentalOptionSystemPropertyValue.compareAndExchange(null, res = Boolean.valueOf(Boolean.getBoolean("polyglot.engine.AllowExperimentalOptions")))) != null) {
                res = old;
            }
            return res;
        }

        private void validateSandbox() {
            if (this.sandboxPolicy == SandboxPolicy.TRUSTED) {
                return;
            }
            if (this.permittedLanguages.length == 0) {
                throw Builder.throwSandboxException(this.sandboxPolicy, "Builder does not have a list of permitted languages.", String.format("create a Builder with a list of permitted languages, for example, %s.newBuilder(\"js\")", this.boundEngine ? "Context" : "Engine"));
            }
            if (Engine.isSystemStream(this.in)) {
                throw Builder.throwSandboxException(this.sandboxPolicy, "Builder uses the standard input stream, but the input must be redirected.", "do not set Builder.in(InputStream) to use InputStream.nullInputStream() or redirect it to other stream than System.in");
            }
            if (Engine.isSystemStream(this.out)) {
                throw Builder.throwSandboxException(this.sandboxPolicy, "Builder uses the standard output stream, but the output must be redirected.", "set Builder.out(OutputStream)");
            }
            if (Engine.isSystemStream(this.err)) {
                throw Builder.throwSandboxException(this.sandboxPolicy, "Builder uses the standard error stream, but the error output must be redirected.", "set Builder.err(OutputStream)");
            }
            if (this.messageTransport != null) {
                throw Builder.throwSandboxException(this.sandboxPolicy, "Builder.serverTransport(MessageTransport) is set, but must not be set.", "do not set Builder.serverTransport(MessageTransport)");
            }
        }

        static IllegalArgumentException throwSandboxException(SandboxPolicy sandboxPolicy, String reason, String fix) {
            Objects.requireNonNull(sandboxPolicy);
            Objects.requireNonNull(reason);
            Objects.requireNonNull(fix);
            String spawnIsolateHelp = sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED) ? " If you switch to a less strict sandbox policy you can still spawn an isolate with an isolated heap using Builder.option(\"engine.SpawnIsolate\",\"true\")." : "";
            String message = String.format("The validation for the given sandbox policy %s failed. %s In order to resolve this %s or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%s", new Object[]{sandboxPolicy, reason, fix, spawnIsolateHelp});
            throw new IllegalArgumentException(message);
        }
    }

    private static final class ImplHolder {
        private static AbstractPolyglotImpl IMPL = Engine.initEngineImpl();

        private ImplHolder() {
        }

        private static void preInitializeEngine() {
            IMPL.preInitializeEngine();
        }

        private static void resetPreInitializedEngine() {
            IMPL.resetPreInitializedEngine();
        }

        private static void debugContextPreInitialization() {
            if (!ImageInfo.inImageCode() && System.getProperty("polyglot.image-build-time.PreinitializeContexts") != null) {
                IMPL.preInitializeEngine();
            }
        }

        static {
            ImplHolder.debugContextPreInitialization();
        }
    }

    static class APIAccessImpl
    extends AbstractPolyglotImpl.APIAccess {
        private static final APIAccessImpl INSTANCE = new APIAccessImpl();
        private static final ProxyArray EMPTY = new ProxyArray(){

            @Override
            public void set(long index, Value value) {
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public long getSize() {
                return 0L;
            }

            @Override
            public Object get(long index) {
                throw new ArrayIndexOutOfBoundsException();
            }
        };

        APIAccessImpl() {
        }

        @Override
        public Context newContext(AbstractPolyglotImpl.AbstractContextDispatch dispatch, Object receiver, Engine engine, boolean registerInActiveContexts) {
            Context context = new Context(dispatch, receiver, null, engine);
            ContextReference apiReference = registerInActiveContexts ? new ContextReference(context, dispatch, receiver) : new WeakReference(context);
            dispatch.setContextAPIReference(receiver, apiReference);
            return context;
        }

        @Override
        public Context newInnerContext(AbstractPolyglotImpl.AbstractContextDispatch dispatch, Object receiver, Context parentContext, Engine engine) {
            Context innerContext = new Context(dispatch, receiver, parentContext, engine);
            ContextReference apiReference = new ContextReference(innerContext, dispatch, receiver);
            dispatch.setContextAPIReference(receiver, apiReference);
            return innerContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Engine newEngine(AbstractPolyglotImpl.AbstractEngineDispatch dispatch, Object receiver, boolean registerInActiveEngines) {
            EngineReference apiReference;
            Engine engine = new Engine(dispatch, receiver);
            if (registerInActiveEngines) {
                if (!shutdownHookInitialized) {
                    Set<CleanableReference<Engine>> set = ENGINES;
                    synchronized (set) {
                        if (!shutdownHookInitialized) {
                            shutdownHookInitialized = true;
                            try {
                                Runtime.getRuntime().addShutdownHook(new Thread(new EngineShutDownHook()));
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                        }
                    }
                }
                EngineReference cleanableReference = new EngineReference(engine, dispatch, receiver);
                ENGINES.add(cleanableReference);
                apiReference = cleanableReference;
            } else {
                apiReference = new WeakReference(engine);
            }
            dispatch.setEngineAPIReference(receiver, apiReference);
            return engine;
        }

        @Override
        public void processReferenceQueue() {
            CleanableReference.processReferenceQueue();
        }

        @Override
        public void engineClosed(Reference<Engine> engineReference) {
            ENGINES.remove(engineReference);
            if (engineReference.get() != null) {
                engineReference.clear();
            }
        }

        @Override
        public void contextClosed(Reference<Context> contextReference) {
            if (contextReference instanceof ContextReference) {
                ((ContextReference)contextReference).receiver = null;
            }
            if (contextReference.get() != null) {
                contextReference.clear();
                CleanableReference.processReferenceQueue();
            }
        }

        @Override
        public Language newLanguage(AbstractPolyglotImpl.AbstractLanguageDispatch dispatch, Object receiver, Engine engine) {
            return new Language(dispatch, receiver, engine);
        }

        @Override
        public Instrument newInstrument(AbstractPolyglotImpl.AbstractInstrumentDispatch dispatch, Object receiver, Engine engine) {
            return new Instrument(dispatch, receiver, engine);
        }

        @Override
        public Object getInstrumentReceiver(Object instrument) {
            return ((Instrument)instrument).receiver;
        }

        @Override
        public Object getValueContext(Object value) {
            return ((Value)value).context;
        }

        @Override
        public Value newValue(AbstractPolyglotImpl.AbstractValueDispatch dispatch, Object context, Object receiver, Context creatorContext) {
            return new Value(dispatch, context, receiver, creatorContext);
        }

        @Override
        public Source newSource(AbstractPolyglotImpl.AbstractSourceDispatch dispatch, Object receiver) {
            return new Source(dispatch, receiver);
        }

        @Override
        public Object getLanguageReceiver(Object language) {
            return ((Language)language).receiver;
        }

        @Override
        public Object newSourceSection(Object source, AbstractPolyglotImpl.AbstractSourceSectionDispatch dispatch, Object receiver) {
            return new SourceSection((Source)source, dispatch, receiver);
        }

        @Override
        public Object getSourceSectionSource(Object sourceSection) {
            return ((SourceSection)sourceSection).getSource();
        }

        @Override
        public AbstractPolyglotImpl.AbstractValueDispatch getValueDispatch(Object value) {
            return ((Value)value).dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractInstrumentDispatch getInstrumentDispatch(Object value) {
            return ((Instrument)value).dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractContextDispatch getContextDispatch(Object context) {
            return ((Context)context).dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractEngineDispatch getEngineDispatch(Object engine) {
            return ((Engine)engine).dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch(Object source) {
            return ((Source)source).dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch(Object sourceSection) {
            return ((SourceSection)sourceSection).dispatch;
        }

        @Override
        public Object newResourceLimitsEvent(Object context) {
            return new ResourceLimitEvent((Context)context);
        }

        @Override
        public AbstractPolyglotImpl.AbstractLanguageDispatch getLanguageDispatch(Object value) {
            return ((Language)value).dispatch;
        }

        @Override
        public Object getResourceLimitsReceiver(Object value) {
            return ((ResourceLimits)value).receiver;
        }

        @Override
        public Object getSourceReceiver(Object source) {
            return ((Source)source).receiver;
        }

        @Override
        public Object getSourceSectionReceiver(Object sourceSection) {
            return ((SourceSection)sourceSection).receiver;
        }

        @Override
        public RuntimeException newLanguageException(String message, AbstractPolyglotImpl.AbstractExceptionDispatch dispatch, Object receiver, Object anchor) {
            return new PolyglotException(message, dispatch, receiver, anchor);
        }

        @Override
        public AbstractPolyglotImpl.AbstractStackFrameImpl getStackFrameDispatch(Object value) {
            return ((PolyglotException.StackFrame)value).impl;
        }

        @Override
        public Object getValueReceiver(Object value) {
            return ((Value)value).receiver;
        }

        @Override
        public Object getContextReceiver(Object context) {
            return ((Context)context).receiver;
        }

        @Override
        public Object getEngineReceiver(Object engine) {
            return ((Engine)engine).receiver;
        }

        @Override
        public Object getPolyglotExceptionReceiver(RuntimeException polyglot) {
            return ((PolyglotException)polyglot).impl;
        }

        @Override
        public PolyglotException.StackFrame newPolyglotStackTraceElement(AbstractPolyglotImpl.AbstractStackFrameImpl dispatch, RuntimeException receiver) {
            PolyglotException polyglotException = (PolyglotException)receiver;
            Objects.requireNonNull(polyglotException);
            return polyglotException.new PolyglotException.StackFrame(dispatch);
        }

        @Override
        public boolean allowsAccess(Object access, AnnotatedElement element) {
            return ((HostAccess)access).allowsAccess(element);
        }

        @Override
        public boolean allowsImplementation(Object access, Class<?> type) {
            return ((HostAccess)access).allowsImplementation(type);
        }

        @Override
        public boolean isMethodScopingEnabled(Object access) {
            return ((HostAccess)access).isMethodScopingEnabled();
        }

        @Override
        public boolean isMethodScoped(Object access, Executable e) {
            return ((HostAccess)access).isMethodScoped(e);
        }

        @Override
        public HostAccess.MutableTargetMapping[] getMutableTargetMappings(Object access) {
            return ((HostAccess)access).getMutableTargetMappings();
        }

        @Override
        public List<Object> getTargetMappings(Object hostAccess) {
            return ((HostAccess)hostAccess).getTargetMappings();
        }

        @Override
        public boolean isArrayAccessible(Object access) {
            return ((HostAccess)access).allowArrayAccess;
        }

        @Override
        public boolean isListAccessible(Object access) {
            return ((HostAccess)access).allowListAccess;
        }

        @Override
        public boolean isBufferAccessible(Object access) {
            return ((HostAccess)access).allowBufferAccess;
        }

        @Override
        public boolean isIterableAccessible(Object access) {
            return ((HostAccess)access).allowIterableAccess;
        }

        @Override
        public boolean isIteratorAccessible(Object access) {
            return ((HostAccess)access).allowIteratorAccess;
        }

        @Override
        public boolean isMapAccessible(Object access) {
            return ((HostAccess)access).allowMapAccess;
        }

        @Override
        public boolean isBigIntegerAccessibleAsNumber(Object access) {
            return ((HostAccess)access).allowBigIntegerNumberAccess;
        }

        @Override
        public boolean allowsPublicAccess(Object access) {
            return ((HostAccess)access).allowPublic;
        }

        @Override
        public boolean allowsAccessInheritance(Object access) {
            return ((HostAccess)access).allowAccessInheritance;
        }

        @Override
        public Object getHostAccessImpl(Object access) {
            return ((HostAccess)access).impl;
        }

        @Override
        public MethodHandles.Lookup getMethodLookup(Object access) {
            return ((HostAccess)access).methodLookup;
        }

        @Override
        public void setHostAccessImpl(Object access, Object impl) {
            ((HostAccess)access).impl = impl;
        }

        @Override
        public Set<String> getEvalAccess(Object access, String language) {
            return ((PolyglotAccess)access).getEvalAccess(language);
        }

        @Override
        public Map<String, Set<String>> getEvalAccess(Object access) {
            return ((PolyglotAccess)access).getEvalAccess();
        }

        @Override
        public Set<String> getBindingsAccess(Object access) {
            return ((PolyglotAccess)access).getBindingsAccess();
        }

        @Override
        public String validatePolyglotAccess(Object access, Set<String> languages) {
            return ((PolyglotAccess)access).validate(languages);
        }

        @Override
        public Map<String, String> readOptionsFromSystemProperties() {
            return Builder.readOptionsFromSystemProperties(Collections.emptyMap());
        }

        @Override
        public boolean isByteSequence(Object origin) {
            return origin instanceof ByteSequence;
        }

        @Override
        public ByteSequence asByteSequence(Object origin) {
            return (ByteSequence)origin;
        }

        @Override
        public Object toByteSequence(Object origin) {
            return Engine.getImpl().asByteSequence(origin);
        }

        @Override
        public int byteSequenceLength(Object origin) {
            return ((ByteSequence)origin).length();
        }

        @Override
        public byte byteSequenceByteAt(Object origin, int index) {
            return ((ByteSequence)origin).byteAt(index);
        }

        @Override
        public Object byteSequenceSubSequence(Object origin, int index, int length) {
            return ((ByteSequence)origin).subSequence(index, index + length);
        }

        @Override
        public byte[] byteSequenceToByteArray(Object origin) {
            return ((ByteSequence)origin).toByteArray();
        }

        @Override
        public boolean isInstrument(Object instrument) {
            return instrument instanceof Instrument;
        }

        @Override
        public boolean isLanguage(Object language) {
            return language instanceof Language;
        }

        @Override
        public boolean isEngine(Object engine) {
            return engine instanceof Engine;
        }

        @Override
        public boolean isContext(Object context) {
            return context instanceof Context;
        }

        @Override
        public boolean isPolyglotException(Object exception) {
            return exception instanceof PolyglotException;
        }

        @Override
        public boolean isValue(Object value) {
            return value instanceof Value;
        }

        @Override
        public boolean isSource(Object value) {
            return value instanceof Source;
        }

        @Override
        public boolean isSourceSection(Object value) {
            return value instanceof SourceSection;
        }

        @Override
        public AbstractPolyglotImpl.AbstractStackFrameImpl getStackFrameReceiver(Object value) {
            return ((PolyglotException.StackFrame)value).impl;
        }

        @Override
        public boolean isProxyArray(Object proxy) {
            return proxy instanceof ProxyArray;
        }

        @Override
        public boolean isProxyDate(Object proxy) {
            return proxy instanceof ProxyDate;
        }

        @Override
        public boolean isProxyDuration(Object proxy) {
            return proxy instanceof ProxyDuration;
        }

        @Override
        public boolean isProxyExecutable(Object proxy) {
            return proxy instanceof ProxyExecutable;
        }

        @Override
        public boolean isProxyHashMap(Object proxy) {
            return proxy instanceof ProxyHashMap;
        }

        @Override
        public boolean isProxyInstant(Object proxy) {
            return proxy instanceof ProxyInstant;
        }

        @Override
        public boolean isProxyInstantiable(Object proxy) {
            return proxy instanceof ProxyInstantiable;
        }

        @Override
        public boolean isProxyIterable(Object proxy) {
            return proxy instanceof ProxyIterable;
        }

        @Override
        public boolean isProxyIterator(Object proxy) {
            return proxy instanceof ProxyIterator;
        }

        @Override
        public boolean isProxyNativeObject(Object proxy) {
            return proxy instanceof ProxyNativeObject;
        }

        @Override
        public boolean isProxyObject(Object proxy) {
            return proxy instanceof ProxyObject;
        }

        @Override
        public boolean isProxyTime(Object proxy) {
            return proxy instanceof ProxyTime;
        }

        @Override
        public boolean isProxyTimeZone(Object proxy) {
            return proxy instanceof ProxyTimeZone;
        }

        @Override
        public boolean isProxy(Object proxy) {
            return proxy instanceof Proxy;
        }

        @Override
        public Class<?> getProxyArrayClass() {
            return ProxyArray.class;
        }

        @Override
        public Class<?> getProxyDateClass() {
            return ProxyDate.class;
        }

        @Override
        public Class<?> getProxyDurationClass() {
            return ProxyDuration.class;
        }

        @Override
        public Class<?> getProxyExecutableClass() {
            return ProxyExecutable.class;
        }

        @Override
        public Class<?> getProxyHashMapClass() {
            return ProxyHashMap.class;
        }

        @Override
        public Class<?> getProxyInstantClass() {
            return ProxyInstant.class;
        }

        @Override
        public Class<?> getProxyInstantiableClass() {
            return ProxyInstantiable.class;
        }

        @Override
        public Class<?> getProxyIterableClass() {
            return ProxyIterable.class;
        }

        @Override
        public Class<?> getProxyIteratorClass() {
            return ProxyIterator.class;
        }

        @Override
        public Class<?> getProxyNativeObjectClass() {
            return ProxyNativeObject.class;
        }

        @Override
        public Class<?> getProxyObjectClass() {
            return ProxyObject.class;
        }

        @Override
        public Class<?> getProxyTimeClass() {
            return ProxyTime.class;
        }

        @Override
        public Class<?> getProxyTimeZoneClass() {
            return ProxyTimeZone.class;
        }

        @Override
        public Class<?> getProxyClass() {
            return Proxy.class;
        }

        @Override
        public Object callProxyExecutableExecute(Object proxy, Object[] objects) {
            return ((ProxyExecutable)proxy).execute((Value[])objects);
        }

        @Override
        public Object callProxyNativeObjectAsPointer(Object proxy) {
            return ((ProxyNativeObject)proxy).asPointer();
        }

        @Override
        public Object callProxyInstantiableNewInstance(Object proxy, Object[] objects) {
            return ((ProxyInstantiable)proxy).newInstance((Value[])objects);
        }

        @Override
        public Object callProxyArrayGet(Object proxy, long index) {
            return ((ProxyArray)proxy).get(index);
        }

        @Override
        public void callProxyArraySet(Object proxy, long index, Object value) {
            ((ProxyArray)proxy).set(index, (Value)value);
        }

        @Override
        public boolean callProxyArrayRemove(Object proxy, long index) {
            return ((ProxyArray)proxy).remove(index);
        }

        @Override
        public Object callProxyArraySize(Object proxy) {
            return ((ProxyArray)proxy).getSize();
        }

        @Override
        public Object callProxyObjectMemberKeys(Object proxy) {
            Object result = ((ProxyObject)proxy).getMemberKeys();
            if (result == null) {
                result = EMPTY;
            }
            return result;
        }

        @Override
        public Object callProxyObjectGetMember(Object proxy, String member) {
            return ((ProxyObject)proxy).getMember(member);
        }

        @Override
        public void callProxyObjectPutMember(Object proxy, String member, Object value) {
            ((ProxyObject)proxy).putMember(member, (Value)value);
        }

        @Override
        public boolean callProxyObjectRemoveMember(Object proxy, String member) {
            return ((ProxyObject)proxy).removeMember(member);
        }

        @Override
        public Object callProxyObjectHasMember(Object proxy, String member) {
            return ((ProxyObject)proxy).hasMember(member);
        }

        @Override
        public ZoneId callProxyTimeZoneAsTimeZone(Object proxy) {
            return ((ProxyTimeZone)proxy).asTimeZone();
        }

        @Override
        public LocalDate callProxyDateAsDate(Object proxy) {
            return ((ProxyDate)proxy).asDate();
        }

        @Override
        public LocalTime callProxyTimeAsTime(Object proxy) {
            return ((ProxyTime)proxy).asTime();
        }

        @Override
        public Instant callProxyInstantAsInstant(Object proxy) {
            return ((ProxyInstant)proxy).asInstant();
        }

        @Override
        public Duration callProxyDurationAsDuration(Object proxy) {
            return ((ProxyDuration)proxy).asDuration();
        }

        @Override
        public Object callProxyIterableGetIterator(Object proxy) {
            return ((ProxyIterable)proxy).getIterator();
        }

        @Override
        public Object callProxyIteratorHasNext(Object proxy) {
            return ((ProxyIterator)proxy).hasNext();
        }

        @Override
        public Object callProxyIteratorGetNext(Object proxy) {
            return ((ProxyIterator)proxy).getNext();
        }

        @Override
        public Object callProxyHashMapHasHashEntry(Object proxy, Object key) {
            return ((ProxyHashMap)proxy).hasHashEntry((Value)key);
        }

        @Override
        public Object callProxyHashMapGetHashSize(Object proxy) {
            return ((ProxyHashMap)proxy).getHashSize();
        }

        @Override
        public Object callProxyHashMapGetHashValue(Object proxy, Object key) {
            return ((ProxyHashMap)proxy).getHashValue((Value)key);
        }

        @Override
        public void callProxyHashMapPutHashEntry(Object proxy, Object key, Object value) {
            ((ProxyHashMap)proxy).putHashEntry((Value)key, (Value)value);
        }

        @Override
        public Object callProxyHashMapRemoveHashEntry(Object proxy, Object key) {
            return ((ProxyHashMap)proxy).removeHashEntry((Value)key);
        }

        @Override
        public Object callProxyHashMapGetEntriesIterator(Object proxy) {
            return ((ProxyHashMap)proxy).getHashEntriesIterator();
        }

        @Override
        public Object getIOAccessNone() {
            return IOAccess.NONE;
        }

        @Override
        public Object getEnvironmentAccessNone() {
            return EnvironmentAccess.NONE;
        }

        @Override
        public Object getEnvironmentAccessInherit() {
            return EnvironmentAccess.INHERIT;
        }

        @Override
        public Object getPolyglotAccessNone() {
            return PolyglotAccess.NONE;
        }

        @Override
        public Object getPolyglotAccessAll() {
            return PolyglotAccess.ALL;
        }

        @Override
        public Object createPolyglotAccess(Set<String> bindingsAccess, Map<String, Set<String>> evalAccess) {
            PolyglotAccess.Builder builder = PolyglotAccess.newBuilder();
            for (String string : bindingsAccess) {
                builder.allowBindingsAccess(string);
            }
            for (Map.Entry entry : evalAccess.entrySet()) {
                String from = (String)entry.getKey();
                for (String to : (Set)entry.getValue()) {
                    builder.allowEval(from, to);
                }
            }
            return builder.build();
        }

        @Override
        public Object getHostAccessNone() {
            return HostAccess.NONE;
        }

        @Override
        public Object getIOAccessAll() {
            return IOAccess.ALL;
        }

        @Override
        public Object[] newValueArray(int size) {
            return new Value[size];
        }

        @Override
        public Class<?> getValueClass() {
            return Value.class;
        }

        @Override
        public <T> T callValueAs(Object delegateBindings, Class<T> targetType) {
            return ((Value)delegateBindings).as(targetType);
        }

        @Override
        public <T> T callValueAs(Object delegateBindings, Class<T> rawType, Type type) {
            Value v = (Value)delegateBindings;
            return v.dispatch.asTypeLiteral(v.context, v.receiver, rawType, type);
        }

        @Override
        public Object callValueGetMetaObject(Object delegateBindings) {
            return ((Value)delegateBindings).getMetaObject();
        }

        @Override
        public long callValueGetArraySize(Object value) {
            return ((Value)value).getArraySize();
        }

        @Override
        public Object callValueGetArrayElement(Object value, int i) {
            return ((Value)value).getArrayElement(i);
        }

        @Override
        public boolean callValueIsString(Object value) {
            return ((Value)value).isString();
        }

        @Override
        public String callValueAsString(Object value) {
            return ((Value)value).asString();
        }

        @Override
        public Object contextAsValue(Object context, Object hostValue) {
            return ((Context)context).asValue(hostValue);
        }

        @Override
        public void contextClose(Object context, boolean cancelIfClosing) {
            ((Context)context).close(cancelIfClosing);
        }

        @Override
        public void contextEnter(Object context) {
            ((Context)context).enter();
        }

        @Override
        public void contextLeave(Object context) {
            ((Context)context).leave();
        }

        @Override
        public Class<?> getPolyglotExceptionClass() {
            return PolyglotException.class;
        }

        @Override
        public Engine getPolyglotExceptionAPIEngine(RuntimeException polyglotException) {
            Object anchor = ((PolyglotException)polyglotException).anchor;
            if (anchor instanceof Context) {
                Context context = (Context)anchor;
                return context.engine;
            }
            if (anchor instanceof Engine) {
                Engine engine = (Engine)anchor;
                return engine;
            }
            return null;
        }

        @Override
        public Context getPolyglotExceptionAPIContext(RuntimeException polyglotException) {
            Object anchor = ((PolyglotException)polyglotException).anchor;
            if (anchor instanceof Context) {
                Context context = (Context)anchor;
                return context;
            }
            return null;
        }

        @Override
        public Class<?> getByteSequenceClass() {
            return ByteSequence.class;
        }

        @Override
        public Object callContextAsValue(Object current, Object classOverrides) {
            return ((Context)current).asValue(classOverrides);
        }

        @Override
        public Object callContextGetCurrent() {
            return Context.getCurrent();
        }
    }

    private static class PolyglotInvalid
    extends AbstractPolyglotImpl {
        PolyglotInvalid() {
        }

        @Override
        public int getPriority() {
            return -2147483647;
        }

        @Override
        public Object getCurrentContext() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Engine buildEngine(String[] permittedLanguages, SandboxPolicy sandboxPolicy, OutputStream out, OutputStream err, InputStream in, Map<String, String> arguments, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandler, Object hostLanguage, boolean hostLanguageOnly, boolean registerInActiveEngines, Object polyglotHostService) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public void onEngineCreated(Object polyglotEngine) {
        }

        @Override
        public Object createHostLanguage(Object access) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Object buildLimits(long statementLimit, Predicate<Object> statementLimitSourceFilter, Consumer<Object> onLimit) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public AbstractPolyglotImpl.AbstractHostAccess createHostAccess() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public boolean copyResources(Path targetFolder, String ... components) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        private static RuntimeException noPolyglotImplementationFound() {
            return new IllegalStateException("No language and polyglot implementation was found on the module-path. Make sure at last one language is added to the module-path. ");
        }

        @Override
        public Class<?> loadLanguageClass(String className) {
            return null;
        }

        @Override
        public void preInitializeEngine() {
        }

        @Override
        public void resetPreInitializedEngine() {
        }

        @Override
        public Object asValue(Object o) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newDefaultFileSystem(String hostTmpDir) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem allowInternalResourceAccess(FileSystem fileSystem) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newReadOnlyFileSystem(FileSystem fileSystem) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newNIOFileSystem(java.nio.file.FileSystem fileSystem) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newCompositeFileSystem(FileSystem fallbackFileSystem, FileSystem.Selector ... delegates) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newDenyIOFileSystem() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public ByteSequence asByteSequence(Object object) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public ProcessHandler newDefaultProcessHandler() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
            return false;
        }

        @Override
        public boolean isInternalFileSystem(FileSystem fileSystem) {
            return false;
        }

        @Override
        public AbstractPolyglotImpl.ThreadScope createThreadScope() {
            return null;
        }

        @Override
        public boolean isInCurrentEngineHostCallback(Object engine) {
            return false;
        }

        @Override
        public OptionDescriptors createUnionOptionDescriptors(OptionDescriptors ... optionDescriptors) {
            return OptionDescriptors.createUnion(optionDescriptors);
        }

        @Override
        public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
            return new Object();
        }

        @Override
        public Source buildSource(String language, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding, URL url, String path) throws IOException {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public String findLanguage(File file) throws IOException {
            return null;
        }

        @Override
        public String findLanguage(URL url) throws IOException {
            return null;
        }

        @Override
        public String findMimeType(File file) throws IOException {
            return null;
        }

        @Override
        public String findMimeType(URL url) throws IOException {
            return null;
        }

        @Override
        public String findLanguage(String mimeType) {
            return null;
        }

        @Override
        public String getTruffleVersion() {
            return Engine.getPolyglotVersion().toString();
        }
    }

    private static final class ContextReference
    extends CleanableReference<Context> {
        private final AbstractPolyglotImpl.AbstractContextDispatch dispatch;
        private volatile Object receiver;

        ContextReference(Context context, AbstractPolyglotImpl.AbstractContextDispatch dispatch, Object receiver) {
            super(context);
            this.dispatch = Objects.requireNonNull(dispatch, "Dispatch must be non-null");
            this.receiver = Objects.requireNonNull(receiver, "Receiver must be non-null");
        }

        @Override
        protected void clean() {
            Object target = this.receiver;
            if (target != null) {
                this.dispatch.onContextCollected(target);
            }
        }
    }

    private static final class EngineReference
    extends CleanableReference<Engine> {
        private final AbstractPolyglotImpl.AbstractEngineDispatch dispatch;
        private final Object receiver;

        EngineReference(Engine engine, AbstractPolyglotImpl.AbstractEngineDispatch dispatch, Object receiver) {
            super(engine);
            this.dispatch = Objects.requireNonNull(dispatch, "Dispatch must be non-null");
            this.receiver = Objects.requireNonNull(receiver, "Receiver must be non-null");
        }

        @Override
        protected void clean() {
            ENGINES.remove(this);
            this.dispatch.onEngineCollected(this.receiver);
        }
    }

    private static abstract class CleanableReference<T>
    extends WeakReference<T> {
        private static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();

        protected CleanableReference(T referent) {
            super(referent, QUEUE);
        }

        protected abstract void clean();

        static void processReferenceQueue() {
            Reference<Object> ref;
            while ((ref = QUEUE.poll()) != null) {
                ((CleanableReference)ref).clean();
            }
        }
    }

    private static final class EngineShutDownHook
    implements Runnable {
        private EngineShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<CleanableReference<Engine>> engines;
            Set<CleanableReference<Engine>> set = ENGINES;
            synchronized (set) {
                engines = List.copyOf(ENGINES);
            }
            for (Reference reference : engines) {
                Engine engine = (Engine)reference.get();
                if (engine == null) continue;
                engine.dispatch.shutdown(engine.receiver);
            }
        }
    }
}

