/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.model.app.ProjectManager;
import com.siams.cv.monitor.model.app.StareProject;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.property.PropertyModel;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.factory.UILink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.apache.log4j.Logger;

public class StareClipboard {
    private static Logger logger = Logger.getLogger(StareClipboard.class);

    public static CompletableFuture<String> copySelectedObjects() {
        App app = App.getInstance();
        AtomicReference clipboardProject = new AtomicReference();
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            List<Model> models = app.getSelectedObjects().stream().map(StareNode::getNodeModel).collect(Collectors.toList());
            Project cpyProject = ProjectManager.build();
            cpyProject.setModels(models);
            clipboardProject.set(cpyProject);
            return cpyProject;
        }).thenCompose(cpyProject -> {
            CompletableFuture[] result = (CompletableFuture[])cpyProject.findAllModels(UIBlockModel.class).stream().map(uiBlockModel -> app.rqGetObjectProperties((IIdentifiable)uiBlockModel).thenAccept(dRs -> uiBlockModel.setPropertyModels(dRs.getProperties().stream().map(SimplePrimitive::convertTo).collect(Collectors.toList())))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> cpyProject);
        })).thenApply(cpyProject -> {
            try {
                StareProject stareProject = cpyProject.getStareProject();
                return stareProject.toJson();
            }
            catch (Throwable t) {
                throw new CompletionException("Failed create stare json project", t);
            }
        })).thenCompose(json -> {
            CompletableFuture cpyJsonClipboard = new CompletableFuture();
            Platform.runLater(() -> {
                try {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(json);
                    Clipboard.getSystemClipboard().setContent((Map)content);
                    cpyJsonClipboard.complete(json);
                }
                catch (Throwable t) {
                    cpyJsonClipboard.completeExceptionally(t);
                }
            });
            return cpyJsonClipboard;
        });
    }

    public static CompletableFuture<String> cutSelectedObjects() {
        return StareClipboard.copySelectedObjects().thenApply(cpyJsonClipboard -> {
            UserAction.deleteSelectedObjects(false);
            return cpyJsonClipboard;
        });
    }

    public static CompletableFuture<Void> pasteObjects(double destX, double destY) {
        App app = App.getInstance();
        String clipboardData = Clipboard.getSystemClipboard().getString();
        AtomicReference clipboardStareProject = new AtomicReference();
        return CompletableFuture.supplyAsync(() -> {
            try {
                StareProject stareProject = StareProject.valueOf(clipboardData);
                clipboardStareProject.set(stareProject);
                return stareProject;
            }
            catch (Throwable t) {
                throw new CompletionException("Failed parse project", t);
            }
        }).thenCompose(pastProject -> {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            ArrayList<UIBlockModel> pastWorkers = new ArrayList<UIBlockModel>();
            ArrayList<UILinkModel> pastLinks = new ArrayList<UILinkModel>();
            for (Model model : pastProject.getModels()) {
                if (UIBlockModel.class.isAssignableFrom(model.getClass())) {
                    UIBlockModel uiBlockModel = (UIBlockModel)model;
                    pastWorkers.add(uiBlockModel);
                    if (!((double)uiBlockModel.getLayoutX() < minX)) continue;
                    minX = uiBlockModel.getLayoutX();
                    minY = uiBlockModel.getLayoutY();
                    continue;
                }
                if (!UILinkModel.class.isAssignableFrom(model.getClass())) continue;
                UILinkModel uiLinkModel = (UILinkModel)model;
                UUID srcPortUuid = uiLinkModel.getSrcPortUuid();
                UUID destPortUuid = uiLinkModel.getDestPortUuid();
                if (srcPortUuid == null || destPortUuid == null) continue;
                pastLinks.add(uiLinkModel);
            }
            double dx = destX - minX;
            double dy = destY - minY;
            HashMap<UIBlockModel, UIBlockModel> translateMap = new HashMap<UIBlockModel, UIBlockModel>();
            List<StareNode> createdNodes = Collections.synchronizedList(new ArrayList());
            return StareClipboard.pasteWorkers(pastWorkers, dx, dy, translateMap, createdNodes).thenAccept(v -> {
                StareClipboard.pasteLinksSync(pastLinks, translateMap, createdNodes, (StareProject)clipboardStareProject.get());
                app.unselectObjects();
                app.selectNodes(createdNodes);
            });
        });
    }

    private static CompletableFuture<Void> pasteWorkers(List<UIBlockModel> pastWorkers, double dx, double dy, Map<UIBlockModel, UIBlockModel> translateMap, List<StareNode> createdNodes) {
        logger.debug((Object)"PastWorkers started");
        CompletableFuture[] futureWorkers = new CompletableFuture[pastWorkers.size()];
        for (int itWorker = 0; itWorker < futureWorkers.length; ++itWorker) {
            UIBlockModel pastWorker = pastWorkers.get(itWorker);
            UUID typeId = pastWorker.getWorkerType();
            WorkerType workerType = IIDStorage.getInstance().findFirst(typeId, WorkerType.class).orElseThrow(() -> {
                String message = String.format("Failed to find worker type: %s", typeId == null ? "null" : typeId);
                return new CompletionException(new RuntimeException(message));
            });
            futureWorkers[itWorker] = StareClipboard.workerCopyRequest(pastWorker, workerType, dx, dy, translateMap, createdNodes);
        }
        return CompletableFuture.allOf(futureWorkers);
    }

    private static CompletableFuture<Void> workerCopyRequest(UIBlockModel pastWorker, WorkerType workerType, double dx, double dy, Map<UIBlockModel, UIBlockModel> translateMap, List<StareNode> createdNodes) {
        App app = App.getInstance();
        return ((CompletableFuture)((CompletableFuture)app.rqAddWorker(workerType, uiBlockModel -> {
            uiBlockModel.copyFrom(pastWorker);
            uiBlockModel.setLayoutX((double)pastWorker.getLayoutX() + dx);
            uiBlockModel.setLayoutY((double)pastWorker.getLayoutY() + dy);
        }).thenApply(uiBlock -> {
            createdNodes.add((StareNode)uiBlock);
            UIBlockModel createdUiBlockModel = uiBlock.getNodeModel();
            translateMap.put(pastWorker, createdUiBlockModel);
            return createdUiBlockModel;
        })).thenCompose(createdUIBlockModel -> app.rqGetObjectSystemPropertyIfExist((IIdentifiable)pastWorker, "name", "").thenApply(systemName -> {
            if (!systemName.isEmpty()) {
                createdUIBlockModel.setCaption(systemName);
                app.rqSetObjectSystemProperty((IIdentifiable)createdUIBlockModel, "name", systemName);
            }
            return createdUIBlockModel;
        }))).thenCompose(createdUiBlockModel -> {
            CompletableFuture[] futureProperties = (CompletableFuture[])pastWorker.getPropertyModels().stream().map(propertyModel -> {
                SimplePrimitive primitive = SimplePrimitive.valueOf((PropertyModel)propertyModel);
                return app.rqSetWorkerProperty(createdUiBlockModel.getUuid(), primitive.getName(), primitive.getVal());
            }).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futureProperties);
        });
    }

    private static CompletableFuture<Void> pasteLinks(List<UILinkModel> pastLinks, Map<UIBlockModel, UIBlockModel> translateMap, List<StareNode> createdNodes, StareProject clipboardProject) {
        logger.debug((Object)"PastLinks started");
        App app = App.getInstance();
        CompletableFuture[] futureLinks = new CompletableFuture[pastLinks.size()];
        for (int itLink = 0; itLink < pastLinks.size(); ++itLink) {
            try {
                UILinkModel pastLink = pastLinks.get(itLink);
                UIPortModel srcPortModel = StareClipboard.findPortModel(pastLink.getSrcPortUuid(), translateMap, clipboardProject);
                UIPortModel destPortModel = StareClipboard.findPortModel(pastLink.getDestPortUuid(), translateMap, clipboardProject);
                futureLinks[itLink] = app.rqCreateNewLink(srcPortModel.getUuid(), destPortModel.getUuid()).thenAccept(createdNodes::add);
                continue;
            }
            catch (Throwable t) {
                CompletableFuture fail = new CompletableFuture();
                fail.completeExceptionally(new RuntimeException(String.format("Failed create link: %s", t.getMessage()), t));
                futureLinks[itLink] = fail;
            }
        }
        return CompletableFuture.allOf(futureLinks);
    }

    private static void pasteLinksSync(List<UILinkModel> pastLinks, Map<UIBlockModel, UIBlockModel> translateMap, List<StareNode> createdNodes, StareProject clipboardProject) {
        logger.debug((Object)"PastLinks started");
        App app = App.getInstance();
        for (UILinkModel pastLink : pastLinks) {
            try {
                UIPortModel srcPortModel = StareClipboard.findPortModel(pastLink.getSrcPortUuid(), translateMap, clipboardProject);
                UIPortModel destPortModel = StareClipboard.findPortModel(pastLink.getDestPortUuid(), translateMap, clipboardProject);
                UILink pastedLink = app.rqCreateNewLink(srcPortModel.getUuid(), destPortModel.getUuid()).get();
                createdNodes.add(pastedLink);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println(String.format("Failed create link: %s", t.getMessage()));
            }
        }
    }

    private static UIPortModel findPortModel(UUID pastPortId, Map<UIBlockModel, UIBlockModel> translateMap, StareProject clipboardProject) throws Throwable {
        if (pastPortId == null) {
            throw new RuntimeException("Invalid link, src port identifier required");
        }
        UIBlockModel pastUiBlockModel = clipboardProject.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(pastPortId).isPresent()).orElseThrow(() -> new RuntimeException(String.format("UIBlockModel not found related with port: %s", pastPortId)));
        UIBlockModel uiBlockModel2 = translateMap.get(pastUiBlockModel);
        if (uiBlockModel2 == null) {
            throw new RuntimeException(String.format("Failed get mapped worker: %s", pastUiBlockModel.toString()));
        }
        UIPortModel uiPortModel = (UIPortModel)pastUiBlockModel.findPort(pastPortId).orElseThrow(() -> new RuntimeException(String.format("UIPortModel not found: %s", pastPortId)));
        PortType portType = uiPortModel.getPortType();
        String portName = uiPortModel.getName();
        return (UIPortModel)uiBlockModel2.findPort(portType, portName).orElseThrow(() -> new RuntimeException(String.format("worker: %s port [%s][%s] not found", uiBlockModel2.getCaption(), portType, portName)));
    }

    public static void verifyClipboard(String clipboardData) throws IOException, NullPointerException {
        Objects.requireNonNull(clipboardData, "Clipboard data required");
        Project project = (Project)new ObjectMapper().readValue(clipboardData, Project.class);
        Objects.requireNonNull(project, "Failed parse clipboard project");
    }
}

