/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.entity;

import com.siams.cv.monitor.entity.type.DataTypeBase;
import com.siams.cv.monitor.entity.type.IDataType;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.worker.DefaultWorkerType;
import com.siams.cv.monitor.model.worker.WorkerType;
import java.util.UUID;

public class EntityFactory {
    private static final IIDStorage iidStorage = IIDStorage.getInstance();

    public static <T extends IIdentifiable> T createEntity(UUID uuid, Class<T> clazz) {
        T entity;
        if (WorkerType.class.isAssignableFrom(clazz)) {
            entity = EntityFactory.createDataProcessModel(uuid, clazz);
        } else if (IDataType.class.isAssignableFrom(clazz)) {
            entity = EntityFactory.createDataType(uuid, clazz);
        } else {
            throw new IllegalArgumentException(String.format("Unknown object class: %s", clazz));
        }
        iidStorage.addObject((IIdentifiable)entity);
        return entity;
    }

    private static <T extends IIdentifiable> T createDataProcessModel(UUID uuid, Class clazz) {
        return (T)new DefaultWorkerType(uuid);
    }

    private static <T extends IIdentifiable> T createDataType(UUID uuid, Class clazz) {
        return (T)new DataTypeBase(uuid);
    }
}

