/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export.poke;

import com.siams.cv.monitor.plugin.poke.model.StarePokePlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;

public class ExportPokeFeatureNamesCsv {
    private String delimiter = new String(",");

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void exportAs(File saveTo, StarePokePlugin data) throws IOException {
        if (!Files.exists(saveTo.toPath(), new LinkOption[0])) {
            saveTo.createNewFile();
        }
        List<String> featureNames = data.getLabelFeatureNames();
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            ArrayList<String> headers = new ArrayList<String>(1);
            headers.add("feature");
            String lineHeader = String.join((CharSequence)this.delimiter, headers);
            out.write(lineHeader.getBytes(StandardCharsets.UTF_8));
            out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            ArrayList<String> lineFeatureName = new ArrayList<String>();
            for (String featureName : featureNames) {
                lineFeatureName.clear();
                lineFeatureName.add(featureName);
                out.write(String.join((CharSequence)this.delimiter, lineFeatureName).getBytes(StandardCharsets.UTF_8));
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

