/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.message;

public class ChainStatusChanged {
    private final Status status;

    private ChainStatusChanged(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public static ChainStatusChanged started() {
        return new ChainStatusChanged(Status.STARTED);
    }

    public static ChainStatusChanged executing() {
        return new ChainStatusChanged(Status.EXECUTING);
    }

    public static ChainStatusChanged paused() {
        return new ChainStatusChanged(Status.PAUSED);
    }

    public static ChainStatusChanged undefined() {
        return new ChainStatusChanged(Status.UNDEFINED);
    }

    public static ChainStatusChanged create(int status) {
        return new ChainStatusChanged(Status.valueOf(status));
    }

    public static enum Status {
        UNDEFINED(0),
        PAUSED(1),
        EXECUTING(2),
        STOPPED(3),
        STARTED(100);

        private int id;

        private Status(int id) {
            this.id = id;
        }

        public static Status valueOf(int id) {
            for (Status status : Status.values()) {
                if (status.id != id) continue;
                return status;
            }
            return UNDEFINED;
        }
    }
}

