/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.model.app.StareProject;
import com.siams.cv.monitor.model.legacy.ProjectNode;
import com.siams.cv.monitor.model.legacy.ProjectUIBlock;
import com.siams.cv.monitor.model.legacy.ProjectUIComment;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonParsingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.stage.FileChooser;
import javafx.util.Pair;
import net.algart.arrays.Arrays;
import org.apache.log4j.Logger;

public enum ProjectManager {
    INSTANCE;

    private static boolean USE_NEW_SCICHAINS_FORMAT;
    private static final String APP = "SciChains";
    private static final String CURRENT_VERSION = "1.1";
    public static final String DEMO_CHAINS_FOLDER;
    private static final Logger logger;
    private static final File userFolder;
    private static final File stareMonitorFolder;
    private static final String CHAIN_CONFIG_PREFERENCE = "chain_config_initial_directory";

    public static Optional<File> showSaveAsStareProjectDialog() {
        File initialDirectory = null;
        String initialFileName = "";
        try {
            File projectFile;
            Project project = App.getInstance().getProject();
            if (project.getProjectFile() != null) {
                projectFile = project.getProjectFile();
            } else {
                String caption = project.getCaption();
                projectFile = new File(caption);
            }
            if (!projectFile.exists()) {
                projectFile = null;
            }
            if (projectFile != null) {
                initialFileName = projectFile.getName();
                initialDirectory = projectFile.getParentFile();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ProjectManager.showSaveAsDialog("Save Chain", initialFileName, Collections.singleton(new FileChooser.ExtensionFilter("Chains", Arrays.asList("*.chain", "*.json"))), "save_as_stare_project_initial_directory", initialDirectory);
    }

    public static Optional<File> showOpenStareProjectDialog() {
        String preferenceName = "open_chain_initial_directory";
        Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
        File initialDir = null;
        try {
            initialDir = new File(preferences.get(preferenceName, ""));
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
        Optional<File> opt = ProjectManager.showOpenStareProjectDialog(initialDir);
        opt.ifPresent(file -> {
            try {
                preferences.put(preferenceName, file.getParentFile().getAbsolutePath());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        });
        return opt;
    }

    public static Optional<File> showOpenDemoChainDialog() {
        String preferenceName = "open_demo_chain_initial_directory";
        Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
        File initialDir = null;
        try {
            Path demoChainsFolder = Paths.get(DEMO_CHAINS_FOLDER, new String[0]).toAbsolutePath().normalize();
            initialDir = new File(preferences.get(preferenceName, DEMO_CHAINS_FOLDER));
            if (!initialDir.toPath().toAbsolutePath().normalize().startsWith(demoChainsFolder)) {
                initialDir = demoChainsFolder.toFile();
            }
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
        Optional<File> opt = ProjectManager.showOpenStareProjectDialog(initialDir);
        opt.ifPresent(file -> {
            try {
                preferences.put(preferenceName, file.getParentFile().getAbsolutePath());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        });
        return opt;
    }

    public static Optional<File> showOpenStareProjectDialog(File initialDir) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open chain");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Chain (JSON)", new String[]{"*.chain", "*.json"})});
        if (initialDir != null && initialDir.exists()) {
            fileChooser.setInitialDirectory(initialDir);
        }
        File file = fileChooser.showOpenDialog(null);
        return Optional.ofNullable(file);
    }

    private static FileChooser createProjectConfigFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Chain configuration", new String[]{"*.cc"})});
        Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
        try {
            File initialDirectory = new File(preferences.get(CHAIN_CONFIG_PREFERENCE, ""));
            if (initialDirectory.exists()) {
                chooser.setInitialDirectory(initialDirectory);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
        return chooser;
    }

    private static File saveChainConfigPreference(File file) {
        if (file.getParentFile() != null) {
            Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
            preferences.put(CHAIN_CONFIG_PREFERENCE, file.getParentFile().getAbsolutePath());
        }
        return file;
    }

    public static Optional<File> showOpenImportProjectConfigDialog() {
        FileChooser chooser = ProjectManager.createProjectConfigFileChooser();
        chooser.setTitle("Import chain configuration");
        return Optional.ofNullable(chooser.showOpenDialog(null)).map(ProjectManager::saveChainConfigPreference);
    }

    public static Optional<File> showOpenExportProjectConfigDialog() {
        FileChooser chooser = ProjectManager.createProjectConfigFileChooser();
        chooser.setTitle("Export chain configuration");
        return Optional.ofNullable(chooser.showSaveDialog(null)).map(ProjectManager::saveChainConfigPreference);
    }

    public static Pair<String, String> readStareProject(File stareProject) throws FileNotFoundException {
        try {
            JsonReader reader = Json.createReader(new FileInputStream(stareProject));
            JsonObject jsonStareProject = reader.readObject();
            String clientChain = jsonStareProject.toString();
            JsonObject serverChainJson = jsonStareProject.getJsonObject("chain");
            if (serverChainJson == null) {
                serverChainJson = jsonStareProject.getJsonObject("stare_chain");
            }
            String serverChain = serverChainJson.toString();
            reader.close();
            return new Pair((Object)clientChain, (Object)serverChain);
        }
        catch (JsonParsingException | NullPointerException e) {
            throw new RuntimeException("Incorrect file format", e);
        }
    }

    public static Project build(String jsonStareProject) throws IOException {
        if (jsonStareProject == null) {
            throw new IllegalArgumentException("Json is required");
        }
        if (jsonStareProject.isEmpty()) {
            throw new IllegalArgumentException("Json should be not empty");
        }
        if (!ProjectManager.checkJsonStareProject(jsonStareProject)) {
            throw new IllegalArgumentException("Json should be valid 'json chain'");
        }
        ObjectMapper mapper = new ObjectMapper();
        Project project = (Project)mapper.readValue(jsonStareProject, Project.class);
        Objects.requireNonNull(project, "Failed parse project");
        return project;
    }

    public static Project build() {
        Project project = new Project();
        project.setVersion(CURRENT_VERSION);
        return project;
    }

    static CompletableFuture<StareProject> removeNotMappedUIBlockModels(String projectUrl, StareProject project) {
        return App.getInstance().rqGetListIds("P/worker").thenApplyAsync(serverWorkerIds -> {
            project.removeModels(UIBlockModel.class, model -> serverWorkerIds.stream().noneMatch(serverWorkerId -> model.getUuid().toString().equals(serverWorkerId)));
            return project;
        });
    }

    static CompletableFuture<StareProject> updateExistingUIBlockModels(String projectUrl, StareProject project) {
        CompletableFuture[] futures = (CompletableFuture[])project.getModels().stream().filter(model -> UIBlockModel.class.isAssignableFrom(model.getClass())).map(model -> App.getInstance().rqGetWorkerIfExist(String.format("%s/worker:%s", projectUrl, model.getUuid().toString())).thenAccept(opt -> opt.ifPresent(serverUiBlockModel -> {
            UIBlockModel uiBlockModel = (UIBlockModel)model;
            if (uiBlockModel.getCaption().isEmpty()) {
                uiBlockModel.setCaption(serverUiBlockModel.getCaption());
            }
            serverUiBlockModel.getPorts().forEach(serverUiPortModel -> uiBlockModel.findPort(serverUiPortModel.getUuid()).ifPresent(uiPortModel -> serverUiPortModel.setVisible(uiPortModel.isVisible())));
            uiBlockModel.setPorts(serverUiBlockModel.getPorts());
            uiBlockModel.setWorkerType(serverUiBlockModel.getWorkerType());
        }))).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(v -> project);
    }

    static CompletableFuture<StareProject> addMissingUIBlockModels(String projectUrl, StareProject project) {
        return ((CompletableFuture)App.getInstance().rqGetListIds(String.format("%s/worker", projectUrl)).thenApply(serverWorkerIds -> serverWorkerIds.stream().filter(serverWorkerId -> project.findModel(UUID.fromString(serverWorkerId)).isEmpty()).collect(Collectors.toList()))).thenCompose(missingWorkerIds -> {
            List uiBlockModels = Collections.synchronizedList(new ArrayList());
            CompletableFuture[] missingWorkers = (CompletableFuture[])missingWorkerIds.stream().map(workerId -> App.getInstance().rqGetWorkerIfExist(String.format("%s/worker:%s", projectUrl, workerId)).thenAccept(opt -> opt.ifPresent(uiBlockModels::add))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(missingWorkers).thenApply(v -> {
                uiBlockModels.forEach(project::addModel);
                return project;
            });
        });
    }

    static CompletableFuture<StareProject> updateSystemNameAsCaptionIfNecessary(String projectUrl, StareProject project) {
        CompletableFuture[] result = (CompletableFuture[])project.findModels(UIBlockModel.class).stream().map(uiBlockModel -> App.getInstance().rqGetDataIfExist(String.format("%s/worker:%s/property:$__system_name", projectUrl, uiBlockModel.getUuid()), uiBlockModel.getCaption()).thenAccept(arg_0 -> ((UIBlockModel)uiBlockModel).setCaption(arg_0))).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(result).thenApply(v1 -> project);
    }

    static CompletableFuture<StareProject> validateBlocks(String projectUrl, StareProject project) {
        return CompletableFuture.supplyAsync(() -> {
            project.removeInvalidBlocks().forEach(removed -> logger.debug((Object)String.format("Invalid block was removed: %s", removed.toString())));
            return project;
        }).thenCompose(v -> ProjectManager.updateSystemNameAsCaptionIfNecessary(projectUrl, project));
    }

    static CompletableFuture<StareProject> synchronizeAndValidateBlocks(String projectUrl, StareProject project) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)ProjectManager.removeNotMappedUIBlockModels(projectUrl, project).thenCompose(v -> ProjectManager.updateExistingUIBlockModels(projectUrl, project))).thenCompose(v -> ProjectManager.addMissingUIBlockModels(projectUrl, project))).thenCompose(v -> ProjectManager.validateBlocks(projectUrl, project))).exceptionally(t -> {
            throw new CompletionException(String.format("Failed synchronize and validate blocks: %s", projectUrl), (Throwable)t);
        });
    }

    static CompletableFuture<StareProject> removeNotMappedUILinkModels(String projectUrl, StareProject project) {
        return App.getInstance().rqGetListIds(String.format("%s/link", projectUrl)).thenApply(serverLinkIds -> {
            project.removeModels(UILinkModel.class, model -> serverLinkIds.stream().noneMatch(serverLinkId -> model.getUuid().toString().equals(serverLinkId)));
            return project;
        });
    }

    static CompletableFuture<StareProject> addMissingUILinkModels(String projectUrl, StareProject project) {
        return ((CompletableFuture)App.getInstance().rqGetListIds(String.format("%s/link", projectUrl)).thenApplyAsync(serverLinkIds -> serverLinkIds.stream().filter(serverLinkId -> project.findModel(UUID.fromString(serverLinkId)).isEmpty()).collect(Collectors.toList()))).thenCompose(missingLinkIds -> {
            List uiLinkModels = Collections.synchronizedList(new ArrayList());
            CompletableFuture[] missingLinks = (CompletableFuture[])missingLinkIds.stream().map(linkId -> App.getInstance().rqGetDataIfExist(String.format("%s/link:%s", projectUrl, linkId), "{}").thenAcceptAsync(json -> UILinkModel.valueOf((String)json).ifPresent(uiLinkModels::add))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(missingLinks).thenApply(v -> {
                CollectionsUtils.remove((Collection)uiLinkModels, uiLinkModel -> {
                    UUID srcPortId = uiLinkModel.getSrcPortUuid();
                    if (srcPortId == null) {
                        return true;
                    }
                    UUID destPortId = uiLinkModel.getDestPortUuid();
                    if (destPortId == null) {
                        return true;
                    }
                    if (project.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(srcPortId).isPresent()).isEmpty()) {
                        return true;
                    }
                    return project.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(destPortId).isPresent()).isEmpty();
                });
                uiLinkModels.forEach(project::addModel);
                return project;
            });
        });
    }

    static CompletableFuture<StareProject> validateLinkPortIds(String projectUrl, StareProject project) {
        return App.getInstance().rqGetListIds(String.format("%s/link", projectUrl)).thenCompose(serverLinkIds -> {
            CompletableFuture[] result = (CompletableFuture[])serverLinkIds.stream().map(linkId -> App.getInstance().rqGetDataIfExist(String.format("%s/link:%s", projectUrl, linkId), "{}").thenAcceptAsync(json -> UILinkModel.valueOf((String)json).ifPresent(uiLinkModel -> project.findModel(uiLinkModel.getUuid(), UILinkModel.class).ifPresent(presetUiLinkModel -> {
                presetUiLinkModel.setSrcPortUuid(uiLinkModel.getSrcPortUuid());
                presetUiLinkModel.setDestPortUuid(uiLinkModel.getDestPortUuid());
            })))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> project);
        });
    }

    static CompletableFuture<StareProject> synchronizeAndValidateLinks(String projectUrl, StareProject project) {
        return ((CompletableFuture)((CompletableFuture)ProjectManager.removeNotMappedUILinkModels(projectUrl, project).thenCompose(v -> ProjectManager.addMissingUILinkModels(projectUrl, project))).thenCompose(v -> ProjectManager.validateLinkPortIds(projectUrl, project))).exceptionally(t -> {
            throw new CompletionException(String.format("Failed synchronize and validate blocks: %s", projectUrl), (Throwable)t);
        });
    }

    static CompletableFuture<StareProject> convertOldModelFormatToNewOne(String projectUrl, String oldVersion, StareProject project) {
        return CompletableFuture.supplyAsync(() -> {
            if (!project.getBlocks().isEmpty()) {
                HashSet<UUID> unique = new HashSet<UUID>();
                ArrayList<ProjectNode> uniqueNodes = new ArrayList<ProjectNode>();
                for (ProjectNode pNode : project.getBlocks()) {
                    if (unique.contains(pNode.getUuid())) continue;
                    unique.add(pNode.getUuid());
                    uniqueNodes.add(pNode);
                }
                project.setBlocks(uniqueNodes);
                if (oldVersion.equalsIgnoreCase("0.0.1")) {
                    List<ProjectNode> filtered = project.getBlocks().stream().filter(projectNode -> projectNode instanceof ProjectUIBlock || projectNode instanceof ProjectUIComment).collect(Collectors.toList());
                    project.setBlocks(filtered);
                }
                List<Model> models = project.getBlocks().stream().map(ProjectNode::convertToModel).collect(Collectors.toList());
                project.setBlocks(Collections.EMPTY_LIST);
                project.setModels(models);
            }
            return project;
        });
    }

    public static CompletableFuture<StareProject> updateProjectVersionIfNecessary(String projectUrl, StareProject project) {
        boolean updateEveryTime = true;
        String oldVersion = project.getVersion();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Converting project %s up to version '%s'", project.getVersion(), CURRENT_VERSION));
        }
        project.setApp(USE_NEW_SCICHAINS_FORMAT ? APP : "stare-project");
        project.setVersion(CURRENT_VERSION);
        CompletionStage futureUpdateProjectVersion = ((CompletableFuture)((CompletableFuture)((CompletableFuture)ProjectManager.convertOldModelFormatToNewOne(projectUrl, oldVersion, project).thenCompose(v -> ProjectManager.synchronizeAndValidateBlocks(projectUrl, project))).thenCompose(v -> ProjectManager.synchronizeAndValidateLinks(projectUrl, project))).thenCompose(v -> ProjectManager.displayConnectedPorts(projectUrl, project))).exceptionally(t -> {
            throw new CompletionException(String.format("Failed update project version: %s", projectUrl), (Throwable)t);
        });
        return futureUpdateProjectVersion;
    }

    private static CompletionStage<StareProject> displayConnectedPorts(String projectUrl, StareProject project) {
        return CompletableFuture.supplyAsync(() -> {
            project.findModels(UILinkModel.class).forEach(uiLinkModel -> project.findModels(UIBlockModel.class).forEach(uiBlockModel -> {
                uiBlockModel.findPort(uiLinkModel.getSrcPortUuid()).ifPresent(uiPortModel -> uiPortModel.setVisible(true));
                uiBlockModel.findPort(uiLinkModel.getDestPortUuid()).ifPresent(uiPortModel -> uiPortModel.setVisible(true));
            }));
            return project;
        });
    }

    /*
     * Exception decompiling
     */
    public static String toJson(StareProject project, String jsonStareChainStr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String toJson(Project project) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((OutputStream)out, (Object)project);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            JsonObject projectJson = Json.createReader(in).readObject();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", null);
            out.reset();
            JsonWriter writer = Json.createWriterFactory(config).createWriter(out, StandardCharsets.UTF_8);
            writer.writeObject(projectJson);
            String chainJson = out.toString(StandardCharsets.UTF_8.name());
            in.close();
            out.close();
            return chainJson;
        }
        catch (IOException e) {
            logger.error((Object)"Can't write project to JSON: ", e.getCause());
            return "";
        }
    }

    public static Optional<File> showSaveAsDialog(String title, String initialFileName, Collection<? extends FileChooser.ExtensionFilter> filters, String preferenceId, File initialDirectory) {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        if (filters != null) {
            fileChooser.getExtensionFilters().addAll(filters);
        }
        if (initialDirectory != null && Files.exists(initialDirectory.toPath(), new LinkOption[0])) {
            fileChooser.setInitialDirectory(initialDirectory);
        } else if (preferenceId != null && !preferenceId.isEmpty()) {
            Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
            try {
                File directory = new File(preferences.get(preferenceId, ""));
                if (directory.exists()) {
                    fileChooser.setInitialDirectory(directory);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (initialFileName != null && !initialFileName.isEmpty()) {
            fileChooser.setInitialFileName(initialFileName);
        }
        if ((file = fileChooser.showSaveDialog(null)) != null) {
            try {
                if (preferenceId != null && !preferenceId.isEmpty()) {
                    Preferences preferences = Preferences.userNodeForPackage(ProjectManager.class);
                    preferences.put(preferenceId, file.getParentFile().getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Optional.ofNullable(file);
    }

    private static JsonObjectBuilder jsonObjectToBuilder(JsonObject jo) {
        JsonObjectBuilder job = Json.createObjectBuilder();
        for (Map.Entry entry : jo.entrySet()) {
            job.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return job;
    }

    private static boolean checkJsonStareProject(String json) {
        try {
            return ProjectManager.checkJsonStareProject(Json.createReader(new ByteArrayInputStream(json.getBytes())).readObject());
        }
        catch (Throwable t) {
            logger.error((Object)"Parse stare-project error", t);
            return false;
        }
    }

    private static boolean checkJsonStareProject(JsonObject json) {
        try {
            if (!json.containsKey("app")) {
                logger.error((Object)"Expected 'app' key in project json");
                return false;
            }
            String app = json.getString("app");
            if (!app.equals("stare-project") && !app.equals(APP)) {
                logger.error((Object)"Expected 'app' == 'SciChains'");
                return false;
            }
            return ProjectManager.checkUiEntitiesKey(json);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean checkUiEntitiesKey(JsonObject json) {
        String version;
        if (json.containsKey("version") && (version = json.getString("version")).startsWith("1")) {
            if (!json.containsKey("nodes")) {
                logger.error((Object)"Expected 'nodes' key");
                return false;
            }
            return true;
        }
        if (!json.containsKey("blocks")) {
            logger.error((Object)"Expected 'blocks' key");
            return false;
        }
        return true;
    }

    public static void saveProject(File saveTo, Project project, String jsonStareChain) throws IOException {
        String jsonProject = ProjectManager.toJson(project.getStareProject(), jsonStareChain);
        byte[] bytes = jsonProject.getBytes(StandardCharsets.UTF_8.name());
        Files.write(saveTo.toPath(), bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    static {
        USE_NEW_SCICHAINS_FORMAT = true;
        DEMO_CHAINS_FOLDER = Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.demo_chains", (String)"demo/chains");
        logger = Logger.getLogger(ProjectManager.class);
        userFolder = new File(System.getProperty("user.home"));
        stareMonitorFolder = new File(userFolder, ".scichains-ide");
        try {
            stareMonitorFolder.mkdirs();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("user home folder: " + stareMonitorFolder.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while create stare-monitor application directories", (Throwable)e);
        }
    }
}

