/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.storage;

import com.siams.collection.CollectionsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class BaseStorage<T> {
    protected final Collection<T> storage = Collections.synchronizedList(new ArrayList());

    public void addObject(T object) {
        this.storage.add(object);
    }

    public void addObjects(List<T> objects) {
        this.storage.addAll(objects);
    }

    public List<T> getAll() {
        return new ArrayList<T>(this.storage);
    }

    public void clear() {
        this.storage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void clear(Class<V> ... clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            this.remove(o -> {
                for (Class cl : clazz) {
                    if (!cl.isAssignableFrom(o.getClass())) continue;
                    return true;
                }
                return false;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExcept(Class ... clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            CollectionsUtils.remove(this.storage, node -> {
                for (Class cl : clazz) {
                    if (!cl.isAssignableFrom(node.getClass())) continue;
                    return false;
                }
                return true;
            }, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> findFirst(Predicate<T> predicate) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.findFirst(this.storage, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> removeFirst(Predicate<T> predicate) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.removeFirst(this.storage, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> remove(Predicate<T> predicate) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.remove(this.storage, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> remove(Predicate<T> predicate, Class<T> clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.remove(this.storage, predicate, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> List<V> find(Predicate<V> predicate, Class<V> clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.find(this.storage, predicate, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> Optional<V> findFirst(Predicate<V> predicate, Class<V> clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.findFirst(this.storage, predicate, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            this.storage.forEach(o -> System.out.println(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> List<V> find(Class<V> clazz) {
        Collection<T> collection = this.storage;
        synchronized (collection) {
            return CollectionsUtils.find(this.storage, clazz);
        }
    }

    public boolean has(Predicate<T> predicate) {
        return this.findFirst(predicate).isPresent();
    }
}

