/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport.data.request;

import com.siams.cv.monitor.transport.data.request.DataRequest;
import java.util.Objects;
import java.util.UUID;

public class DRqAddLink
extends DataRequest {
    private final UUID srcPortId;
    private final UUID srcWorkerId;
    private final UUID destPortId;
    private final UUID destWorkerId;

    private DRqAddLink(UUID srcWorkerId, UUID srcPortId, UUID destWorkerId, UUID destPortId) {
        this.srcWorkerId = srcWorkerId;
        this.srcPortId = srcPortId;
        this.destWorkerId = destWorkerId;
        this.destPortId = destPortId;
    }

    public UUID getSrcPortId() {
        return this.srcPortId;
    }

    public UUID getDestPortId() {
        return this.destPortId;
    }

    public UUID getSrcWorkerId() {
        return this.srcWorkerId;
    }

    public UUID getDestWorkerId() {
        return this.destWorkerId;
    }

    public static class Builder {
        private UUID srcPortId;
        private UUID srcWorkerId;
        private UUID destPortId;
        private UUID destWorkerId;

        public Builder setSrcPortId(UUID portId) {
            this.srcPortId = portId;
            return this;
        }

        public Builder setSrcWorkerId(UUID workerId) {
            this.srcWorkerId = workerId;
            return this;
        }

        public Builder setDestPortId(UUID destPortId) {
            this.destPortId = destPortId;
            return this;
        }

        public Builder setDestWorkerId(UUID destWorkerId) {
            this.destWorkerId = destWorkerId;
            return this;
        }

        public DRqAddLink build() {
            Objects.requireNonNull(this.srcPortId, "Source port id required");
            Objects.requireNonNull(this.srcWorkerId, "Source worker id required");
            Objects.requireNonNull(this.destPortId, "Destination port id required");
            Objects.requireNonNull(this.destWorkerId, "Destination worker id required");
            return new DRqAddLink(this.srcWorkerId, this.srcPortId, this.destWorkerId, this.destPortId);
        }
    }
}

